/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.users.config.WxAppConfig;
import com.centit.framework.users.po.UserPlat;
import com.centit.framework.users.service.UserPlatService;
import io.swagger.annotations.Api;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/wxlogin"})
@Api(value="\u5fae\u4fe1\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"\u5fae\u4fe1\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class WeChatLogin
extends BaseController {
    @Autowired
    private WxMpService wxOpenService;
    @Autowired
    private WxAppConfig wxAppConfig;
    @Autowired
    private UserPlatService userPlatService;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @GetMapping(value={"/login"})
    public ModelAndView qrAuthorize(HttpServletResponse response) {
        return new ModelAndView("/sys/wxLogin");
    }

    private WxMpUser getWxUser(String code) {
        WxMpUser wxMpUser = new WxMpUser();
        try {
            WxMpOAuth2AccessToken wxMpOAuth2AccessToken = this.getAccessToken(code);
            wxMpUser = this.wxOpenService.oauth2getUserInfo(wxMpOAuth2AccessToken, null);
        }
        catch (WxErrorException e) {
            e.printStackTrace();
        }
        return wxMpUser;
    }

    private WxMpOAuth2AccessToken getAccessToken(String code) {
        WxMpOAuth2AccessToken wxMpOAuth2AccessToken = new WxMpOAuth2AccessToken();
        try {
            wxMpOAuth2AccessToken = this.wxOpenService.oauth2getAccessToken(code);
        }
        catch (WxErrorException e) {
            e.printStackTrace();
        }
        return wxMpOAuth2AccessToken;
    }

    @GetMapping(value={"/qrUserInfo"})
    @WrapUpResponseBody
    public ResponseData qrUserInfo(@RequestParam(value="code") String code, @RequestParam(value="state") String state, HttpServletRequest request) {
        WxMpUser wxMpUser = this.getWxUser(code);
        String openId = wxMpUser.getOpenId();
        String unionId = wxMpUser.getUnionId();
        this.logger.info("openid={}", (Object)openId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("userId", openId);
        paramsMap.put("appKey", this.wxAppConfig.getAppID());
        paramsMap.put("unionId", unionId);
        UserPlat userPlat = this.userPlatService.getUserPlatByProperties(paramsMap);
        if (userPlat != null) {
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByUserCode(userPlat.getUserCode());
            SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
            resultMap.put("userInfo", ud);
            resultMap.put("userCode", userPlat.getUserCode());
            resultMap.put("accessToken", request.getSession().getId());
            return ResponseData.makeResponseData(resultMap);
        }
        return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u7cfb\u7edf\u7528\u6237\u4fe1\u606f\u5931\u8d25");
    }

    @RequestMapping(value={"/bindUserInfo"})
    @WrapUpResponseBody
    public ResponseData bindUserInfo(@RequestParam(value="code") String code, @RequestParam(value="userCode") String userCode, HttpServletRequest request) {
        WxMpUser wxMpUser = this.getWxUser(code);
        String openId = wxMpUser.getOpenId();
        String unionId = wxMpUser.getUnionId();
        String weChatName = wxMpUser.getNickname();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("userCode", userCode);
        paramsMap.put("appKey", this.wxAppConfig.getAppID());
        UserPlat userPlat = this.userPlatService.getUserPlatByProperties(paramsMap);
        if (userPlat != null) {
            userPlat.setUnionId(unionId);
            userPlat.setUserId(openId);
            userPlat.setPlatId("2");
            userPlat.setCorpId("");
            userPlat.setAppKey(this.wxAppConfig.getAppID());
            userPlat.setAppSecret(this.wxAppConfig.getAppSecret());
            userPlat.setWeChatName(weChatName);
            this.userPlatService.updateUserPlat(userPlat);
        } else {
            CentitUserDetails userDetails = this.platformEnvironment.loadUserDetailsByUserCode(userCode);
            if (null != userDetails) {
                UserPlat newUser = new UserPlat();
                newUser.setUnionId(unionId);
                newUser.setUserId(openId);
                newUser.setUserCode(userDetails.getUserCode());
                newUser.setPlatId("2");
                newUser.setCorpId("");
                newUser.setAppKey(this.wxAppConfig.getAppID());
                newUser.setAppSecret(this.wxAppConfig.getAppSecret());
                newUser.setWeChatName(weChatName);
                this.userPlatService.saveUserPlat(newUser);
            }
        }
        return ResponseData.successResponse;
    }
}

