/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.config.WxAppConfig;
import com.centit.support.common.ObjectException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import me.chanjar.weixin.mp.api.WxMpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/third"})
@Api(value="\u7b2c\u4e09\u65b9\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"\u7b2c\u4e09\u65b9\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class ThirdLogin {
    @Autowired
    private WxMpService wxOpenService;
    @Autowired
    private WxAppConfig wxAppConfig;
    @Autowired
    private AppConfig appConfig;
    private static final String WECHAT_LOGIN = "wx";
    private static final String WECHAT_BIND = "wxBind";
    private static final String DING_LOGIN = "ding";

    @ApiOperation(value="\u5fae\u4fe1\u4e8c\u7ef4\u7801\u767b\u5f55/\u7ed1\u5b9a", notes="\u5fae\u4fe1\u4e8c\u7ef4\u7801\u767b\u5f55/\u7ed1\u5b9a")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u8bf7\u6c42\u7c7b\u578b;\u767b\u5f55:wx;\u7ed1\u5b9a:wxBind;\u9489\u9489:ding", required=true, paramType="body", dataType="String"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u540d,\u7c7b\u578b\u4e3abind\u65f6,\u4e0d\u53ef\u4e3a\u7a7a", required=true, paramType="body", dataType="String")})
    @GetMapping(value={"/login"})
    public void qrAuthorize(@RequestParam(value="type") String type, @RequestParam(value="userCode") String userCode, @RequestParam(value="returnUrl") String returnUrl, HttpServletResponse response) throws IOException {
        String url = "";
        String authorizeUrl = "";
        if (WECHAT_LOGIN.equals(type)) {
            url = this.wxAppConfig.getRedirectLoginUri() + "?returnUrl=" + returnUrl;
            authorizeUrl = this.wxOpenService.buildQrConnectUrl(url, "snsapi_login", "");
        } else if (WECHAT_BIND.equals(type)) {
            if (userCode == null || "".equals(userCode)) {
                throw new ObjectException("\u7f3a\u5c11\u53c2\u6570userCode;");
            }
            url = this.wxAppConfig.getRedirectBindUri() + "?userCode=" + userCode;
            authorizeUrl = this.wxOpenService.buildQrConnectUrl(url, "snsapi_login", "");
        } else if (DING_LOGIN.equals(type)) {
            authorizeUrl = "https://oapi.dingtalk.com/connect/qrconnect?appid=" + this.appConfig.getAppKey() + "&response_type=code" + "&scope=snsapi_login&redirect_uri=" + this.appConfig.getRedirectUri();
        }
        response.sendRedirect(authorizeUrl);
    }
}

