/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.dto.DingUnitDTO;
import com.centit.framework.users.dto.DingUserDTO;
import com.centit.framework.users.po.Platform;
import com.centit.framework.users.po.UserPlat;
import com.centit.framework.users.service.DingTalkLoginService;
import com.centit.framework.users.service.PlatformService;
import com.centit.framework.users.service.TokenService;
import com.centit.framework.users.service.UserPlatService;
import com.centit.support.common.ObjectException;
import com.taobao.api.ApiException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/ddlogin"})
@Api(value="\u9489\u9489\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"\u9489\u9489\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class DingTalkLogin
extends BaseController {
    @Autowired
    private AppConfig appConfig;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private DingTalkLoginService dingTalkLoginService;
    @Autowired
    private UserPlatService userPlatService;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private PlatformService platformService;

    @ApiOperation(value="\u9489\u9489\u4e8c\u7ef4\u7801\u767b\u5f55", notes="\u9489\u9489\u4e8c\u7ef4\u7801\u767b\u5f55\u3002")
    @GetMapping(value={"/qrconnect"})
    public void qrConnect(HttpServletResponse response) throws IOException {
        String authorizeUrl = "https://oapi.dingtalk.com/connect/qrconnect?appid=" + this.appConfig.getAppKey() + "&response_type=code" + "&scope=snsapi_login&redirect_uri=" + this.appConfig.getRedirectUri();
        response.sendRedirect(authorizeUrl);
    }

    @ApiOperation(value="\u9489\u9489\u8d26\u53f7\u767b\u5f55", notes="\u9489\u9489\u8d26\u53f7\u767b\u5f55\u3002")
    @GetMapping(value={"/snsauthorize"})
    public void snsAuthorize(HttpServletResponse response) throws IOException {
        String authorizeUrl = "https://oapi.dingtalk.com/connect/oauth2/sns_authorize?appid=" + this.appConfig.getAppKey() + "&response_type=code" + "&scope=snsapi_login&redirect_uri=" + this.appConfig.getRedirectUri();
        response.sendRedirect(authorizeUrl);
    }

    @GetMapping(value={"/getUserInfo"})
    public String getUserInfo(@RequestParam(value="code") String code, @RequestParam(value="state") String state, @RequestParam(value="returnUrl") String returnUrl, HttpServletRequest request) throws ApiException {
        CentitUserDetails userDetails;
        JSONObject userObject;
        String accessToken = "";
        ResponseData accessTokenData = this.tokenService.getAccessToken();
        if (accessTokenData.getCode() != 0) {
            throw new ObjectException(accessTokenData.getCode(), accessTokenData.getMessage());
        }
        accessToken = accessTokenData.getData().toString();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new ObjectException(accessTokenData.getCode(), "\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        ResponseData unionIdData = this.dingTalkLoginService.getUserByCode(code);
        if (unionIdData.getCode() != 0) {
            throw new ObjectException(unionIdData.getCode(), unionIdData.getMessage());
        }
        String unionid = unionIdData.getData().toString();
        ResponseData userIdData = this.dingTalkLoginService.getUserByUnionId(accessToken, unionid);
        if (userIdData.getCode() != 0) {
            throw new ObjectException(userIdData.getCode(), userIdData.getMessage());
        }
        String userId = userIdData.getData().toString();
        ResponseData userInfoData = this.dingTalkLoginService.getUserInfo(accessToken, userId);
        if (userInfoData.getCode() != 0) {
            throw new ObjectException(userIdData.getCode(), userIdData.getMessage());
        }
        JSONObject jsonObject = JSONObject.parseObject((String)userInfoData.getData().toString());
        String regPhone = "";
        if (null != jsonObject && null != (userObject = JSONObject.parseObject((String)jsonObject.getString("result")))) {
            regPhone = userObject.getString("mobile");
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("userId", userId);
        paramsMap.put("corpId", this.appConfig.getCorpId());
        paramsMap.put("appKey", this.appConfig.getAppKey());
        paramsMap.put("appSecret", this.appConfig.getAppSecret());
        UserPlat userPlat = this.userPlatService.getUserPlatByProperties(paramsMap);
        if (null != userPlat) {
            userPlat.setUnionId(unionid);
            this.userPlatService.updateUserPlat(userPlat);
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByUserCode(userPlat.getUserCode());
            SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
        } else if (userPlat == null && StringUtils.isNotBlank((CharSequence)regPhone) && null != (userDetails = this.platformEnvironment.loadUserDetailsByRegCellPhone(regPhone))) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)userDetails);
            UserPlat newUser = new UserPlat();
            newUser.setUserCode(userDetails.getUserCode());
            HashMap<String, Object> platMap = new HashMap<String, Object>();
            platMap.put("corpId", this.appConfig.getCorpId());
            Platform platform = this.platformService.getPlatformByProperties(platMap);
            if (null != platform) {
                newUser.setPlatId(platform.getPlatId());
            }
            newUser.setCorpId(this.appConfig.getCorpId());
            newUser.setAppKey(this.appConfig.getAppKey());
            newUser.setAppSecret(this.appConfig.getAppSecret());
            newUser.setUnionId(unionid);
            newUser.setUserId(userId);
            this.userPlatService.saveUserPlat(newUser);
        }
        returnUrl = returnUrl != null && returnUrl.contains("?") ? returnUrl + "&accessToken=" + request.getSession().getId() : returnUrl + "?accessToken=" + request.getSession().getId();
        if (returnUrl != null && returnUrl.indexOf("/A/") > -1) {
            returnUrl = returnUrl.replace("/A/", "/#/");
        }
        return "redirect:" + returnUrl;
    }

    @GetMapping(value={"/bindUserInfo"})
    public String bindUserInfo(@RequestParam(value="code") String code, @RequestParam(value="userCode") String userCode, @RequestParam(value="returnUrl") String returnUrl, HttpServletRequest request) throws ApiException {
        if (userCode == null || "".equals(userCode)) {
            throw new ObjectException((Object)"500", "userCode\u4e3a\u7a7a");
        }
        String accessToken = "";
        ResponseData accessTokenData = this.tokenService.getAccessToken();
        if (accessTokenData.getCode() != 0) {
            throw new ObjectException(accessTokenData.getCode(), accessTokenData.getMessage());
        }
        accessToken = accessTokenData.getData().toString();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            throw new ObjectException((Object)"500", "\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        ResponseData unionIdData = this.dingTalkLoginService.getUserByCode(code);
        if (unionIdData.getCode() != 0) {
            throw new ObjectException(unionIdData.getCode(), unionIdData.getMessage());
        }
        String unionid = unionIdData.getData().toString();
        ResponseData userIdData = this.dingTalkLoginService.getUserByUnionId(accessToken, unionid);
        if (userIdData.getCode() != 0) {
            throw new ObjectException(userIdData.getCode(), userIdData.getMessage());
        }
        String userId = userIdData.getData().toString();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("userId", userId);
        paramsMap.put("corpId", this.appConfig.getCorpId());
        paramsMap.put("appKey", this.appConfig.getAppKey());
        paramsMap.put("appSecret", this.appConfig.getAppSecret());
        UserPlat userPlat = this.userPlatService.getUserPlatByProperties(paramsMap);
        if (userPlat != null) {
            throw new ObjectException((Object)"500", "\u9489\u9489\u8d26\u53f7\u5df2\u7ed1\u5b9a\uff0c\u8bf7\u52ff\u91cd\u590d\u7ed1\u5b9a\uff01");
        }
        CentitUserDetails userDetails = this.platformEnvironment.loadUserDetailsByUserCode(userCode);
        if (null != userDetails) {
            UserPlat newUser = new UserPlat();
            newUser.setUserCode(userDetails.getUserCode());
            HashMap<String, Object> platMap = new HashMap<String, Object>();
            platMap.put("corpId", this.appConfig.getCorpId());
            Platform platform = this.platformService.getPlatformByProperties(platMap);
            if (null != platform) {
                newUser.setPlatId(platform.getPlatId());
            }
            newUser.setCorpId(this.appConfig.getCorpId());
            newUser.setAppKey(this.appConfig.getAppKey());
            newUser.setAppSecret(this.appConfig.getAppSecret());
            newUser.setUnionId(unionid);
            newUser.setUserId(userId);
            this.userPlatService.saveUserPlat(newUser);
        }
        if ((returnUrl = returnUrl != null && returnUrl.contains("?") ? returnUrl + "&accessToken=" + request.getSession().getId() : returnUrl + "?accessToken=" + request.getSession().getId()) != null && returnUrl.indexOf("/A/") > -1) {
            returnUrl = returnUrl.replace("/A/", "/#/");
        }
        return "redirect:" + returnUrl;
    }

    private String getAccessToken() {
        String accessToken = "";
        ResponseData accessTokenData = this.tokenService.getAccessToken();
        if (accessTokenData.getCode() != 0) {
            return "";
        }
        accessToken = accessTokenData.getData().toString();
        return accessToken;
    }

    @ApiOperation(value="\u540c\u6b65\u9489\u9489\u521b\u5efa\u7528\u6237", notes="\u540c\u6b65\u9489\u9489\u521b\u5efa\u7528\u6237\u3002")
    @PostMapping(value={"/usercreate"})
    @WrapUpResponseBody
    public ResponseData userCreate(DingUserDTO userInfo, HttpServletRequest request) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        return this.dingTalkLoginService.userCreate(accessToken, userInfo);
    }

    @ApiOperation(value="\u540c\u6b65\u9489\u9489\u521b\u5efa\u673a\u6784\u90e8\u95e8", notes="\u540c\u6b65\u9489\u9489\u521b\u5efa\u673a\u6784\u90e8\u95e8\u3002")
    @PostMapping(value={"/unitcreate"})
    @WrapUpResponseBody
    public ResponseData unitCreate(DingUnitDTO unitInfo, HttpServletRequest request) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        return this.dingTalkLoginService.unitCreate(accessToken, unitInfo);
    }

    @ApiOperation(value="\u6839\u636e\u90e8\u95e8deptId\u83b7\u53d6\u9489\u9489\u90e8\u95e8\u8be6\u60c5", notes="\u6839\u636e\u90e8\u95e8deptId\u83b7\u53d6\u9489\u9489\u90e8\u95e8\u8be6\u60c5\u3002")
    @GetMapping(value={"/{deptId}"})
    @WrapUpResponseBody
    public ResponseData getUnitInfo(@PathVariable String deptId, HttpServletResponse response) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        return this.dingTalkLoginService.getUnitInfo(accessToken, deptId);
    }
}

