/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UserSyncDirectory;
import com.centit.framework.system.service.UserSyncDirectoryManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.compiler.Pretreatment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/ldap"})
@Api(value="ldap\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"ldap\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class LdapLogin
extends BaseController {
    private static final String LDAP_USER_ID = "ldapUserURI";
    private static Logger logger = LoggerFactory.getLogger(LdapLogin.class);
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private UserSyncDirectoryManager userSyncDirectoryManager;
    @Value(value="${security.disable.user}")
    private String disableUser;

    public String getOptId() {
        return "LDAPLOGIN";
    }

    @ApiOperation(value="ldap\u767b\u5f55", notes="ldap\u767b\u5f55")
    @PostMapping(value={"/login"})
    @WrapUpResponseBody
    @RecordOperationLog(content="\u7528\u6237{username}\u4f7f\u7528ldap\u767b\u5f55,\u64cd\u4f5cIP\u5730\u5740:{loginIp}", newValue="ldap\u767b\u5f55")
    public ResponseData login(@RequestParam(value="username") String username, @RequestParam(value="password") String password, HttpServletRequest request) throws Exception {
        username = StringEscapeUtils.unescapeHtml4((String)username);
        password = StringEscapeUtils.unescapeHtml4((String)password);
        if (StringUtils.isNotBlank((CharSequence)this.disableUser)) {
            this.disableUser = StringUtils.deleteWhitespace((String)this.disableUser);
            String[] ignoreUsers = this.disableUser.split(",");
            for (int i = 0; i < ignoreUsers.length; ++i) {
                if (!username.contains(ignoreUsers[i])) continue;
                return ResponseData.makeErrorMessage((String)"\u7981\u7528\u7684\u7528\u6237\u8d26\u53f7");
            }
        }
        LeftRightPair<UserSyncDirectory, Map<String, Object>> userLdapInfo = this.searchUserByloginName(username);
        HashMap<String, String> sessionMap = new HashMap<String, String>();
        if (userLdapInfo == null) {
            return ResponseData.makeErrorMessage((String)"\u672a\u67e5\u8be2\u5230\u7528\u6237");
        }
        try {
            Map userLdap = (Map)userLdapInfo.getRight();
            boolean passed = this.checkUserPasswordByDn((UserSyncDirectory)userLdapInfo.getLeft(), (Map)userLdapInfo.getRight(), password);
            if (!passed) {
                return ResponseData.makeErrorMessage((String)"\u7528\u6237\u540d\u5bc6\u7801\u4e0d\u5339\u914d\u3002");
            }
            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(StringBaseOpt.castObjectToString(userLdap.get("loginName")));
            ud.setLoginIp(WebOptUtils.getRequestAddr((HttpServletRequest)request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
            sessionMap.put("accessToken", request.getSession().getId());
            sessionMap.put("userInfo", (String)ud);
        }
        catch (NamingException e) {
            return ResponseData.makeErrorMessage((String)"\u7cfb\u7edf\u9519\u8bef\u3002");
        }
        return ResponseData.makeResponseData(sessionMap);
    }

    public LeftRightPair<UserSyncDirectory, Map<String, Object>> searchUserByloginName(String loginName) {
        List list = this.userSyncDirectoryManager.listObjects();
        if (list != null && list.size() > 0) {
            for (UserSyncDirectory userSyncDirectory : list) {
                Map<String, Object> userDataMap;
                if (!"LDAP".equalsIgnoreCase(userSyncDirectory.getType()) || (userDataMap = LdapLogin.searchLdapUserByloginName(userSyncDirectory, loginName)).size() <= 0) continue;
                return new LeftRightPair((Object)userSyncDirectory, userDataMap);
            }
        }
        return null;
    }

    public static Map<String, Object> searchLdapUserByloginName(UserSyncDirectory directory, String loginName) {
        block9: {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", directory.getUser());
            env.put("java.naming.security.credentials", directory.getUserPwd());
            env.put("java.naming.provider.url", directory.getUrl());
            HashMap<String, Object> attributes = new HashMap<String, Object>(20);
            InitialLdapContext ctx = null;
            try {
                SearchResult sr;
                Attributes attrs;
                String principalId;
                ctx = new InitialLdapContext(env, null);
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                JSONObject searchParams = JSON.parseObject((String)directory.getSearchBase());
                String searchFilter = MessageFormat.format(searchParams.getString("searchBase"), loginName);
                Map returnFields = CollectionsOpt.objectToMap((Object)searchParams.get((Object)"returnFields"));
                String[] fieldNames = new String[returnFields.size()];
                int i = 0;
                for (Object obj : returnFields.values()) {
                    fieldNames[i++] = StringBaseOpt.castObjectToString(obj);
                }
                searchCtls.setReturningAttributes(fieldNames);
                NamingEnumeration<SearchResult> answer = ctx.search(searchParams.getString("searchName"), searchFilter, searchCtls);
                if (answer.hasMoreElements() && StringUtils.isNotBlank((CharSequence)(principalId = LdapLogin.getAttributeString(attrs = (sr = answer.next()).getAttributes(), searchParams.getString("loginNameField"))))) {
                    NamingEnumeration<? extends Attribute> enumeration = attrs.getAll();
                    while (enumeration.hasMore()) {
                        Attribute attr = enumeration.next();
                        attributes.put(attr.getID(), attr.get());
                    }
                }
                ctx.close();
                if (attributes.size() > 0) {
                    HashMap<String, Object> returnMap = new HashMap<String, Object>(attributes.size() + 2);
                    for (Map.Entry ent : returnFields.entrySet()) {
                        Object obj = attributes.get(StringBaseOpt.castObjectToString(ent.getValue()));
                        if (obj == null) continue;
                        returnMap.put((String)ent.getKey(), obj);
                    }
                    returnMap.put(LDAP_USER_ID, Pretreatment.mapTemplateString((String)searchParams.getString("userURIFormat"), attributes));
                    return returnMap;
                }
            }
            catch (NamingException e) {
                System.out.println(e.getLocalizedMessage());
                if (ctx == null) break block9;
                try {
                    ctx.close();
                }
                catch (NamingException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String getAttributeString(Attributes attrs, String attrName) {
        Attribute attr = attrs.get(attrName);
        if (attr == null) {
            return null;
        }
        try {
            return StringBaseOpt.objectToString((Object)attr.get());
        }
        catch (NamingException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUserPasswordByDn(UserSyncDirectory directory, Map<String, Object> userLdapInfo, String password) throws NamingException {
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", StringBaseOpt.castObjectToString((Object)userLdapInfo.get(LDAP_USER_ID)));
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.provider.url", directory.getUrl());
        try (InitialLdapContext ctx = null;){
            ctx = new InitialLdapContext(env, null);
            boolean bl = true;
            return bl;
        }
    }
}

