/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.utils.aes;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getRandomStr(int count) {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("getRandomStr\u5f02\u5e38", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (null == random) continue;
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static byte[] int2Bytes(int count) {
        byte[] byteArr = new byte[4];
        byteArr[3] = (byte)(count & 0xFF);
        byteArr[2] = (byte)(count >> 8 & 0xFF);
        byteArr[1] = (byte)(count >> 16 & 0xFF);
        byteArr[0] = (byte)(count >> 24 & 0xFF);
        return byteArr;
    }

    public static int bytes2int(byte[] byteArr) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            count <<= 8;
            count |= byteArr[i] & 0xFF;
        }
        return count;
    }
}

