/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.users.po.UserPlat;
import com.centit.framework.users.service.UserPlatService;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/userplat"})
@Api(value="\u7528\u6237\u5e73\u53f0\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3", tags={"\u7528\u6237\u5e73\u53f0\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3"})
public class UserPlatController
extends BaseController {
    @Autowired
    private UserPlatService userPlatService;

    @ApiOperation(value="\u521b\u5efa\u7528\u6237\u5e73\u53f0\u5173\u8054\u4fe1\u606f", notes="\u521b\u5efa\u7528\u6237\u5e73\u53f0\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userPlat", value="json\u683c\u5f0f\u7684\u7528\u6237\u5e73\u53f0\u5173\u8054\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=UserPlat.class)
    @PostMapping
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u7528\u6237\u5e73\u53f0\u5173\u8054\u4fe1\u606f", tag="{userPlat.userPlatId}:{userPlat.platId}:{userPlat.userCode}")
    @WrapUpResponseBody
    public ResponseData create(@ParamName(value="userPlat") @Valid UserPlat userPlat, HttpServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("platId", userPlat.getPlatId());
        map.put("corpId", userPlat.getCorpId());
        map.put("userCode", userPlat.getUserCode());
        List<UserPlat> list = this.userPlatService.listObjects(map, new PageDesc());
        if (!CollectionUtils.isEmpty(list)) {
            return ResponseData.makeErrorMessage((String)"\u8be5\u7528\u6237\u5df2\u5b58\u5728");
        }
        userPlat.setCreator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        this.userPlatService.saveUserPlat(userPlat);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u66f4\u65b0\u5e73\u53f0\u7528\u6237\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u5e73\u53f0\u4ee3\u7801\u66f4\u65b0\u5e73\u53f0\u7528\u6237\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userPlatId", value="\u7528\u6237\u5e73\u53f0\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="userPlat", value="json\u683c\u5f0f\u7684\u7528\u6237\u5e73\u53f0\u5173\u8054\u5bf9\u8c61\u4fe1\u606f", required=true, paramType="body", dataTypeClass=UserPlat.class)})
    @PutMapping(value={"/{userPlatId}"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u7528\u6237\u5e73\u53f0\u5173\u8054\u4fe1\u606f", tag="userPlatId")
    @WrapUpResponseBody
    public ResponseData edit(@ParamName(value="userPlatId") @PathVariable String userPlatId, @Valid UserPlat userPlat, HttpServletRequest request) {
        userPlat.setUpdator(WebOptUtils.getCurrentUserCode((HttpServletRequest)request));
        UserPlat dbUserPlat = this.userPlatService.getObjectById(userPlatId);
        if (null == dbUserPlat) {
            return ResponseData.makeErrorMessage((String)"\u5f53\u524d\u5e73\u53f0\u4e2d\u65e0\u6b64\u7528\u6237");
        }
        this.userPlatService.updateUserPlat(userPlat);
        return ResponseData.makeResponseData((Object)userPlat);
    }

    @ApiOperation(value="\u5220\u9664\u7528\u6237\u5e73\u53f0\u5173\u8054\u4fe1\u606f", notes="\u6839\u636e\u7528\u6237\u5e73\u53f0\u4ee3\u7801\u5220\u9664\u7528\u6237\u5e73\u53f0\u5173\u8054\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="userPlatId", value="\u7528\u6237\u5e73\u53f0\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @DeleteMapping(value={"/{userPlatId}"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u7528\u6237\u5e73\u53f0\u5173\u8054\u4fe1\u606f", tag="{userPlatId}")
    @WrapUpResponseBody
    public ResponseData delete(@ParamName(value="userPlatId") @PathVariable String userPlatId) {
        UserPlat dbUserPlat = this.userPlatService.getObjectById(userPlatId);
        this.userPlatService.deleteObject(dbUserPlat);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u901a\u8fc7\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u7528\u6237\u6240\u5728\u5e73\u53f0", notes="\u901a\u8fc7\u7528\u6237\u4ee3\u7801\u83b7\u53d6\u7528\u6237\u6240\u5728\u5e73\u53f0\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u5bf9\u8c61\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)})
    @GetMapping(value={"/userplats/{userCode}"})
    @WrapUpResponseBody
    public PageQueryResult<UserPlat> listUnitsByUser(@PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("userCode", userCode);
        List<UserPlat> listObjects = this.userPlatService.listObjects(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict(listObjects, (PageDesc)pageDesc);
    }
}

