/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.po.DingTalkSuite;
import com.centit.framework.users.service.DingTalkSuiteService;
import com.centit.framework.users.service.TokenService;
import com.centit.framework.users.utils.aes.DingTalkEncryptException;
import com.centit.framework.users.utils.aes.DingTalkEncryptor;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/callback"})
public class CallBackController
extends BaseController {
    @Autowired
    private DingTalkSuiteService dingTalkSuiteService;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private AppConfig appConfig;

    @PostMapping(value={"/dingCallback"})
    @ResponseBody
    public Object dingCallback(@RequestParam(value="suitetbId") String suitetbId, @RequestParam(value="signature") String signature, @RequestParam(value="timestamp") Long timestamp, @RequestParam(value="nonce") String nonce, @RequestBody(required=false) JSONObject json, HttpServletRequest request) {
        try {
            String encrypt = json.getString("encrypt");
            String plainText = this.decodeEncrypt(suitetbId, signature, timestamp.toString(), nonce, encrypt);
            this.logger.info("plainText\u5185\u5bb9: " + plainText);
            JSONObject callBackContent = JSON.parseObject((String)plainText);
            String eventType = callBackContent.getString("EventType");
            String suiteTicket = callBackContent.getString("SuiteTicket");
            this.logger.info("suiteTicket\u5185\u5bb9: " + suiteTicket);
            String res = "success";
            switch (eventType) {
                case "suite_ticket": {
                    this.logger.info("\u5e94\u7528suite_ticket\u6570\u636e\u63a8\u9001: " + plainText);
                    this.suiteTicket(callBackContent, suitetbId);
                    break;
                }
                case "check_create_suite_url": {
                    this.logger.info("\u9a8c\u8bc1\u65b0\u521b\u5efa\u7684\u56de\u8c03URL\u6709\u6548\u6027: " + plainText);
                    this.createSuiteCheck(callBackContent);
                    break;
                }
                case "check_update_suite_url": {
                    this.logger.info("\u9a8c\u8bc1\u66f4\u65b0\u56de\u8c03URL\u6709\u6548\u6027: " + plainText);
                    this.updateSuiteCheck(callBackContent);
                    break;
                }
                case "tmp_auth_code": {
                    this.logger.info("\u4f01\u4e1a\u6388\u6743\u5f00\u901a\u5e94\u7528\u4e8b\u4ef6: " + plainText);
                    break;
                }
            }
            return this.codeEncrypt(suitetbId, res, timestamp.toString(), nonce);
        }
        catch (Exception e) {
            this.logger.error("process callback fail.", (Throwable)e);
            return "fail";
        }
    }

    private void suiteTicket(JSONObject decodeEncryptJson, String suitetbId) {
        try {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("suiteid", suitetbId);
            DingTalkSuite suite = this.dingTalkSuiteService.getDingTalkSuiteByProperty(paramsMap);
            if (null != suite) {
                String suiteTicket = decodeEncryptJson.getString("SuiteTicket");
                suite.setSuitTicket(suiteTicket);
                this.dingTalkSuiteService.updateDingTalkSuiteInfo(suite);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5f02\u5e38:", (Throwable)e);
        }
    }

    private String decodeEncrypt(String suitetbId, String msgSignature, String timeStamp, String nonce, String encrypt) {
        String decodeEncrypt = null;
        try {
            DingTalkEncryptor dingTalkEncryptor = this.createDingTalkEncryptor(suitetbId);
            if (null != dingTalkEncryptor) {
                decodeEncrypt = dingTalkEncryptor.getDecryptMsg(msgSignature, timeStamp, nonce, encrypt);
            }
        }
        catch (DingTalkEncryptException e) {
            this.logger.error("\u5f02\u5e38:", (Throwable)e);
        }
        return decodeEncrypt;
    }

    private JSONObject codeEncrypt(String suitetbId, String res, String timeStamp, String nonce) {
        long timeStampLong = Long.parseLong(timeStamp);
        Map<String, String> jsonMap = null;
        try {
            DingTalkEncryptor dingTalkEncryptor = this.createDingTalkEncryptor(suitetbId);
            if (null != dingTalkEncryptor) {
                jsonMap = dingTalkEncryptor.getEncryptedMap(res, timeStampLong, nonce);
            }
        }
        catch (DingTalkEncryptException e) {
            this.logger.error("\u5f02\u5e38:", (Throwable)e);
        }
        JSONObject json = new JSONObject();
        json.putAll(jsonMap);
        return json;
    }

    private DingTalkEncryptor createDingTalkEncryptor(String suitetbId) {
        DingTalkEncryptor dingTalkEncryptor = null;
        try {
            HashMap<String, Object> paramsMap = new HashMap<String, Object>();
            paramsMap.put("suiteid", suitetbId);
            DingTalkSuite suite = this.dingTalkSuiteService.getDingTalkSuiteByProperty(paramsMap);
            String suiteKey = "";
            if (null != suite) {
                suiteKey = suite.getSuiteKey();
                dingTalkEncryptor = !"".equals(suiteKey) && suiteKey != null ? new DingTalkEncryptor(suite.getToken(), suite.getEncodingAesKey(), suiteKey) : new DingTalkEncryptor(suite.getToken(), suite.getEncodingAesKey(), this.appConfig.getAppKey());
            }
        }
        catch (DingTalkEncryptException e) {
            this.logger.error("\u5f02\u5e38:", (Throwable)e);
        }
        return dingTalkEncryptor;
    }

    private String createSuiteCheck(JSONObject decodeEncryptJson) {
        String res = decodeEncryptJson.getString("Random");
        String testSuiteKey = decodeEncryptJson.getString("TestSuiteKey");
        return res;
    }

    private String updateSuiteCheck(JSONObject decodeEncryptJson) {
        return decodeEncryptJson.getString("Random");
    }
}

