/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.service;

import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.po.AccessToken;
import com.centit.framework.users.po.DingTalkSuite;
import com.centit.framework.users.service.AccessTokenService;
import com.centit.framework.users.service.DingTalkSuiteService;
import com.centit.framework.users.utils.FileUtil;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGetJsapiTicketRequest;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiServiceGetCorpTokenRequest;
import com.dingtalk.api.response.OapiGetJsapiTicketResponse;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiServiceGetCorpTokenResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private static final Logger log = LoggerFactory.getLogger(TokenService.class);
    private static final long CACHE_TTL = 0x6DDD00L;
    private AppConfig appConfig;
    @Autowired
    private AccessTokenService accessTokenService;
    @Autowired
    private DingTalkSuiteService dingTalkSuiteService;

    @Autowired
    public TokenService(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public String getTokenFromCache() {
        return this.getFromCache("accessToken", "access_token");
    }

    public ResponseData getCorpAccessToken() {
        OapiServiceGetCorpTokenResponse response;
        String accessToken = this.getFromCache("accessToken", "access_token");
        if (accessToken != null) {
            return ResponseData.makeResponseData((Object)accessToken);
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/service/get_corp_token");
        OapiServiceGetCorpTokenRequest request = new OapiServiceGetCorpTokenRequest();
        request.setAuthCorpid(this.appConfig.getCorpId());
        String suiteTicket = "94t717KmkkijItbs3fgik2UWYwHcBcO1pafJtgAkNQeqRuD4r8rxaNS6odLvA0nl6SMzQ2j7b6vpPRnRKCBKcF";
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("suiteid", "1");
        DingTalkSuite dingTalkSuite = this.dingTalkSuiteService.getDingTalkSuiteByProperty(paramsMap);
        if (null != dingTalkSuite) {
            suiteTicket = dingTalkSuite.getSuitTicket();
        }
        try {
            response = (OapiServiceGetCorpTokenResponse)client.execute((TaobaoRequest)request, this.appConfig.getAppKey(), this.appConfig.getAppSecret(), suiteTicket, this.appConfig.getCorpId());
        }
        catch (ApiException e) {
            log.error("getAccessToken failed", (Throwable)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)e.getErrMsg());
        }
        accessToken = response.getAccessToken();
        this.saveTokenTodb(this.appConfig.getAppKey(), accessToken, response.getExpiresIn());
        return ResponseData.makeResponseData((Object)accessToken);
    }

    public ResponseData getAccessToken() {
        OapiGettokenResponse response;
        String accessToken = this.getFromDb(this.appConfig.getAppKey());
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            return ResponseData.makeResponseData((Object)accessToken);
        }
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
        OapiGettokenRequest request = new OapiGettokenRequest();
        request.setAppkey(this.appConfig.getAppKey());
        request.setAppsecret(this.appConfig.getAppSecret());
        request.setHttpMethod("GET");
        try {
            response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
        }
        catch (ApiException e) {
            log.error("getAccessToken failed", (Throwable)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)e.getErrMsg());
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        accessToken = response.getAccessToken();
        this.saveTokenTodb(this.appConfig.getAppKey(), accessToken, response.getExpiresIn());
        return ResponseData.makeResponseData((Object)accessToken);
    }

    private String getFromCache(String section, String field) {
        JSONObject o = (JSONObject)FileUtil.getValue(section, this.appConfig.getAppKey());
        if (o != null && System.currentTimeMillis() - o.getLong("begin_time") <= 0x6DDD00L) {
            return o.getString(field);
        }
        return null;
    }

    private void putToCache(String section, String field, String value) {
        JSONObject fieldObj = new JSONObject(2);
        fieldObj.put((Object)field, (Object)value);
        fieldObj.put((Object)"begin_time", (Object)System.currentTimeMillis());
        JSONObject wrapperObj = new JSONObject(1);
        wrapperObj.put((Object)this.appConfig.getAppKey(), (Object)fieldObj);
        FileUtil.write2File(wrapperObj, section);
    }

    public String getFromDb(String section) {
        AccessToken accessToken = this.accessTokenService.getObjectById(section);
        if (null != accessToken) {
            long createTime = accessToken.getCreateTime().getTime();
            if (System.currentTimeMillis() - createTime <= 0x6DDD00L) {
                return accessToken.getAccessToken();
            }
        }
        return null;
    }

    private void saveTokenTodb(String section, String value, Long expiresIn) {
        AccessToken accessToken = new AccessToken();
        accessToken.setAppId(section);
        accessToken.setAccessToken(value);
        accessToken.setExpireIn(expiresIn);
        accessToken.setExpireTime(new Date(System.currentTimeMillis() + expiresIn * 1000L));
        this.accessTokenService.saveAccessToke(accessToken);
    }

    public ResponseData getJsTicket() {
        OapiGetJsapiTicketResponse response;
        String ticket = this.getFromDb("jsticket");
        if (StringUtils.isNotBlank((CharSequence)ticket)) {
            return ResponseData.makeResponseData((Object)ticket);
        }
        ResponseData tokenSr = this.getAccessToken();
        if (tokenSr.getCode() != 0) {
            return ResponseData.makeErrorMessage((int)tokenSr.getCode(), (String)tokenSr.getMessage());
        }
        String accessToken = tokenSr.getData().toString();
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/get_jsapi_ticket");
        OapiGetJsapiTicketRequest request = new OapiGetJsapiTicketRequest();
        request.setHttpMethod("GET");
        try {
            response = (OapiGetJsapiTicketResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            log.error("getAccessToken failed", (Throwable)e);
            return ResponseData.makeErrorMessage((int)Integer.valueOf(e.getErrCode()), (String)e.getErrMsg());
        }
        if (!response.isSuccess()) {
            return ResponseData.makeErrorMessage((int)Integer.valueOf(response.getErrorCode()), (String)response.getErrmsg());
        }
        ticket = response.getTicket();
        this.saveTokenTodb("jsticket", ticket, response.getExpiresIn());
        return ResponseData.makeResponseData((Object)ticket);
    }
}

