/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.service.impl;

import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.po.AccessToken;
import com.centit.framework.users.po.AuthCallback;
import com.centit.framework.users.service.AuthSource;
import com.centit.framework.users.service.LoginService;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.network.UrlOptUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthDefaultRequest
implements LoginService {
    private Logger logger = LoggerFactory.getLogger(AuthDefaultRequest.class);
    protected AppConfig config;
    protected AuthSource source;

    public AuthDefaultRequest(AppConfig config, AuthSource source) {
        this.config = config;
        this.source = source;
    }

    protected abstract AccessToken getAccessToken(AuthCallback var1);

    protected abstract UserInfo getUserInfo(AccessToken var1);

    @Override
    public ResponseData login(AuthCallback authCallback) {
        try {
            AccessToken accessToken = this.getAccessToken(authCallback);
            UserInfo user = this.getUserInfo(accessToken);
            return ResponseSingleData.makeResponseData((Object)user);
        }
        catch (Exception e) {
            this.logger.error("Failed to login with oauth authorization.", (Throwable)e);
            return ResponseSingleData.errorResponse;
        }
    }

    @Override
    public String authorize(String state) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("response_type", "code");
        queryParam.put("appid", this.config.getAppKey());
        queryParam.put("scope", "snsapi_login");
        queryParam.put("state", this.getRealState(state));
        queryParam.put("redirect_uri", this.config.getRedirectUri());
        return UrlOptUtils.appendParamsToUrl((String)this.source.authorize(), queryParam);
    }

    protected String accessTokenUrl(String code) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("appkey", this.config.getAppKey());
        queryParam.put("appsecret", this.config.getAppSecret());
        return UrlOptUtils.appendParamsToUrl((String)this.source.accessToken(), queryParam);
    }

    protected String refreshTokenUrl(String refreshToken) {
        return UrlOptUtils.appendParamsToUrl((String)this.source.refresh(), null);
    }

    protected String userInfoUrl(AccessToken accessToken) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("access_token", accessToken.getAccessToken());
        return UrlOptUtils.appendParamsToUrl((String)this.source.userInfo(), queryParam);
    }

    protected String revokeUrl(AccessToken accessToken) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        queryParam.put("access_token", accessToken.getAccessToken());
        return UrlOptUtils.appendParamsToUrl((String)this.source.revoke(), queryParam);
    }

    protected String getRealState(String state) {
        if (StringUtils.isEmpty((CharSequence)state)) {
            state = UuidOpt.getUuidAsString22();
        }
        return state;
    }
}

