/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.users.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.system.dao.UnitInfoDao;
import com.centit.framework.users.config.AppConfig;
import com.centit.framework.users.dto.DingUnitDTO;
import com.centit.framework.users.dto.DingUserDTO;
import com.centit.framework.users.po.SocialDeptAuth;
import com.centit.framework.users.service.DingTalkLoginService;
import com.centit.framework.users.service.SocialDeptAuthService;
import com.centit.framework.users.service.TokenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/ddlogin"})
@Api(value="\u9489\u9489\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"\u9489\u9489\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class DingTalkLogin
extends BaseController {
    @Autowired
    private AppConfig appConfig;
    @Autowired
    private TokenService tokenService;
    @Autowired
    private DingTalkLoginService dingTalkLoginService;
    @Autowired
    private SocialDeptAuthService socialDeptAuthService;
    @Autowired
    private UnitInfoDao unitInfoDao;

    @ApiOperation(value="\u9489\u9489\u4e8c\u7ef4\u7801\u767b\u5f55", notes="\u9489\u9489\u4e8c\u7ef4\u7801\u767b\u5f55\u3002")
    @GetMapping(value={"/qrconnect"})
    public void qrConnect(HttpServletResponse response) throws IOException {
        String authorizeUrl = "https://oapi.dingtalk.com/connect/qrconnect?appid=" + this.appConfig.getAppKey() + "&response_type=code&scope=snsapi_login&redirect_uri=" + this.appConfig.getRedirectUri();
        response.sendRedirect(authorizeUrl);
    }

    @ApiOperation(value="\u9489\u9489\u8d26\u53f7\u767b\u5f55", notes="\u9489\u9489\u8d26\u53f7\u767b\u5f55\u3002")
    @GetMapping(value={"/snsauthorize"})
    public void snsAuthorize(HttpServletResponse response) throws IOException {
        String authorizeUrl = "https://oapi.dingtalk.com/connect/oauth2/sns_authorize?appid=" + this.appConfig.getAppKey() + "&response_type=code&scope=snsapi_login&redirect_uri=" + this.appConfig.getRedirectUri();
        response.sendRedirect(authorizeUrl);
    }

    private String getAccessToken() {
        String accessToken = "";
        ResponseData accessTokenData = this.tokenService.getAccessToken();
        if (accessTokenData.getCode() != 0) {
            return "";
        }
        accessToken = accessTokenData.getData().toString();
        return accessToken;
    }

    @ApiOperation(value="\u540c\u6b65\u9489\u9489\u521b\u5efa\u7528\u6237", notes="\u540c\u6b65\u9489\u9489\u521b\u5efa\u7528\u6237\u3002")
    @PostMapping(value={"/usercreate"})
    @WrapUpResponseBody
    public ResponseData userCreate(DingUserDTO userInfo, HttpServletRequest request) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        String unitCode = userInfo.getPrimaryUnit();
        SocialDeptAuth socialDeptAuth = this.socialDeptAuthService.getObjectById(unitCode);
        if (null == socialDeptAuth) {
            UnitInfo unitInfo = this.unitInfoDao.getObjectById(unitCode);
            DingUnitDTO dingUnitDTO = new DingUnitDTO();
            dingUnitDTO.setUnitCode(unitCode);
            dingUnitDTO.setParentUnit(unitInfo.getParentUnit());
            dingUnitDTO.setUnitName(unitInfo.getUnitName());
            this.dingTalkLoginService.unitCreate(accessToken, dingUnitDTO);
        }
        return this.dingTalkLoginService.userCreate(accessToken, userInfo);
    }

    @ApiOperation(value="\u540c\u6b65\u9489\u9489\u521b\u5efa\u673a\u6784\u90e8\u95e8", notes="\u540c\u6b65\u9489\u9489\u521b\u5efa\u673a\u6784\u90e8\u95e8\u3002")
    @PostMapping(value={"/unitcreate"})
    @WrapUpResponseBody
    public ResponseData unitCreate(DingUnitDTO unitInfo, HttpServletRequest request) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        return this.dingTalkLoginService.unitCreate(accessToken, unitInfo);
    }

    @ApiOperation(value="\u6839\u636e\u90e8\u95e8deptId\u83b7\u53d6\u9489\u9489\u90e8\u95e8\u8be6\u60c5", notes="\u6839\u636e\u90e8\u95e8deptId\u83b7\u53d6\u9489\u9489\u90e8\u95e8\u8be6\u60c5\u3002")
    @GetMapping(value={"/{deptId}"})
    @WrapUpResponseBody
    public ResponseData getUnitInfo(@PathVariable String deptId, HttpServletResponse response) {
        String accessToken = this.getAccessToken();
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return ResponseData.makeErrorMessage((String)"\u83b7\u53d6\u9489\u9489access_token\u5931\u8d25");
        }
        return this.dingTalkLoginService.getUnitInfo(accessToken, deptId);
    }
}

