/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jdbc.service;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.jdbc.service.BaseEntityManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseEntityManagerImpl<T extends Serializable, PK extends Serializable, D extends BaseDaoImpl<T, PK>>
implements BaseEntityManager<T, PK> {
    protected D baseDao = null;
    protected Logger logger = LoggerFactory.getLogger(BaseEntityManagerImpl.class);

    protected void setBaseDao(D baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    @Transactional
    public List<T> listObjects() {
        return ((BaseDaoImpl)this.baseDao).listObjects();
    }

    @Override
    @Transactional
    @Deprecated
    public List<T> listObjectsByProperties(Map<String, Object> filterMap, PageDesc pageDesc) {
        return ((BaseDaoImpl)this.baseDao).listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public List<T> listObjectsByProperty(String propertyName, Object propertyValue) {
        return ((BaseDaoImpl)this.baseDao).listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
    }

    @Override
    @Transactional
    public List<T> listObjectsByProperties(Map<String, Object> filterMap) {
        return ((BaseDaoImpl)this.baseDao).listObjectsByProperties(filterMap);
    }

    @Override
    @Transactional
    public T getObjectById(PK id) {
        return ((BaseDaoImpl)this.baseDao).getObjectById(id);
    }

    @Override
    @Transactional
    public void saveNewObject(T o) {
        ((BaseDaoImpl)this.baseDao).saveNewObject(o);
    }

    @Override
    @Transactional
    public void updateObject(T o) {
        ((BaseDaoImpl)this.baseDao).updateObject(o);
    }

    @Override
    @Transactional
    public void mergeObject(T o) {
        ((BaseDaoImpl)this.baseDao).mergeObject(o);
    }

    @Override
    @Transactional
    public void deleteObject(T o) {
        ((BaseDaoImpl)this.baseDao).deleteObject(o);
    }

    @Override
    @Transactional
    public void deleteObjectById(PK id) {
        ((BaseDaoImpl)this.baseDao).deleteObjectById(id);
    }

    @Override
    @Transactional
    public T getObjectByProperty(String propertyName, Object propertyValue) {
        return ((BaseDaoImpl)this.baseDao).getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
    }

    @Override
    @Transactional
    public T getObjectByProperties(Map<String, Object> properties) {
        return ((BaseDaoImpl)this.baseDao).getObjectByProperties(properties);
    }

    @Override
    @Transactional
    public JSONArray listObjectsAsJson(Map<String, Object> filterMap, PageDesc pageDesc) {
        return ((BaseDaoImpl)this.baseDao).listObjectsByPropertiesAsJson(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public JSONArray listObjectsBySqlAsJson(String querySql, Map<String, Object> filterMap, PageDesc pageDesc) {
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson(this.baseDao, querySql, filterMap, pageDesc);
    }
}

