/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseSingleData;
import com.centit.framework.common.WebOptUtils;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public class AjaxAccessDeniedHandlerImpl
implements AccessDeniedHandler {
    protected static final Log logger = LogFactory.getLog(AjaxAccessDeniedHandlerImpl.class);
    private String errorPage;

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (!WebOptUtils.isAjax((HttpServletRequest)request) && StringUtils.isNotBlank((CharSequence)this.errorPage)) {
            request.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
            response.setStatus(403);
            RequestDispatcher dispatcher = request.getRequestDispatcher(this.errorPage);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        } else if (WebOptUtils.exceptionNotAsHttpError) {
            ResponseSingleData responseData = new ResponseSingleData(401, "\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
            responseData.setData((Object)"\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
            JsonResultUtils.writeResponseDataAsJson((ResponseData)responseData, (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeHttpErrorMessage((int)401, (String)"\u65e0\u6743\u9650\u8bbf\u95ee\uff01", (HttpServletResponse)response);
        }
    }

    public void setErrorPage(String errorPage) {
        if (errorPage != null && !errorPage.startsWith("/")) {
            throw new IllegalArgumentException("errorPage must begin with '/'");
        }
        this.errorPage = errorPage;
    }
}

