/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.security;

import com.centit.framework.security.SecurityContextUtils;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;

public class DaoAccessDecisionManager
implements AccessDecisionManager {
    private static final Logger logger = LoggerFactory.getLogger(DaoAccessDecisionManager.class);

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        if (configAttributes.contains(new SecurityConfig(SecurityContextUtils.FORBIDDEN_ROLE_CODE))) {
            String sErrMsg = "Accessing resource is forbidden, because it is bound with forbidden-role.";
            logger.error(sErrMsg);
            throw new AccessDeniedException(sErrMsg);
        }
        if (configAttributes.contains(new SecurityConfig(SecurityContextUtils.SPRING_ANONYMOUS_ROLE_CODE))) {
            return;
        }
        Collection userRoles = authentication.getAuthorities();
        if (userRoles != null) {
            Iterator userRolesItr = userRoles.iterator();
            Iterator<ConfigAttribute> needRolesItr = configAttributes.iterator();
            String needRole = needRolesItr.next().getAttribute();
            String userRole = ((GrantedAuthority)userRolesItr.next()).getAuthority();
            while (true) {
                int n;
                if ((n = needRole.compareTo(userRole)) == 0) {
                    return;
                }
                if (n < 0) {
                    if (!needRolesItr.hasNext()) break;
                    needRole = needRolesItr.next().getAttribute();
                    continue;
                }
                if (!userRolesItr.hasNext()) break;
                userRole = ((GrantedAuthority)userRolesItr.next()).getAuthority();
            }
        }
        FilterInvocation fi = (FilterInvocation)object;
        String requestUrl = fi.getRequestUrl();
        StringBuilder errorMsgBuilder = new StringBuilder("no auth: ").append(requestUrl).append("; user role: ");
        boolean firstRole = true;
        for (GrantedAuthority ur : userRoles) {
            if (firstRole) {
                firstRole = false;
            } else {
                errorMsgBuilder.append(", ");
            }
            errorMsgBuilder.append(ur.getAuthority().substring(2));
        }
        errorMsgBuilder.append("; need role: ");
        firstRole = true;
        for (ConfigAttribute ca : configAttributes) {
            if (firstRole) {
                firstRole = false;
            } else {
                errorMsgBuilder.append(", ");
            }
            errorMsgBuilder.append(ca.getAttribute().substring(2));
        }
        errorMsgBuilder.append(".");
        String sErrMsg = errorMsgBuilder.toString();
        fi.getResponse().setHeader("CENTIT_SYSTEM_ERROR_MSG", sErrMsg);
        logger.error(sErrMsg);
        throw new AccessDeniedException(sErrMsg);
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

