/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.session.redis;

import com.centit.framework.session.CentitSessionRepo;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.session.Session;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;

public class CentitSessionRedisRepo
implements CentitSessionRepo {
    private RedisIndexedSessionRepository sessionRepository;

    public CentitSessionRedisRepo(RedisIndexedSessionRepository sessionRepository) {
        this.sessionRepository = sessionRepository;
    }

    public void kickSessionByName(String loginName, String escapeSessionId) {
        Map mapSession = this.sessionRepository.findByPrincipalName(loginName);
        if (mapSession != null) {
            for (Map.Entry ent : mapSession.entrySet()) {
                if (StringUtils.equals((CharSequence)escapeSessionId, (CharSequence)((Session)ent.getValue()).getId())) continue;
                this.sessionRepository.deleteById(((Session)ent.getValue()).getId());
            }
        }
    }

    public void kickSessionByName(String loginName) {
        Map mapSession = this.sessionRepository.findByPrincipalName(loginName);
        if (mapSession != null) {
            for (Map.Entry ent : mapSession.entrySet()) {
                this.sessionRepository.deleteById(((Session)ent.getValue()).getId());
            }
        }
    }

    public void kickSessionByPrincipal(String principalName) {
        this.kickSessionByName(principalName);
    }

    public Session findById(String id) {
        return this.sessionRepository.findById(id);
    }
}

