/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.system.controller;

import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.basedata.Platform;
import com.centit.framework.operationlog.RecordOperationLog;
import com.centit.framework.system.service.PlatformService;
import com.centit.framework.system.service.UserPlatService;
import com.centit.support.common.ParamName;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/plat"})
@Api(value="\u767b\u5f55\u5e73\u53f0\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3", tags={"\u767b\u5f55\u5e73\u53f0\u7ba1\u7406\u64cd\u4f5c\u63a5\u53e3"})
public class PlatformController
extends BaseController {
    @Autowired
    private PlatformService platformService;
    @Autowired
    private UserPlatService userPlatService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e73\u53f0\u4fe1\u606f", notes="\u5206\u9875\u67e5\u8be2\u5e73\u53f0\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="pageDesc", value="json\u683c\u5f0f\u7684\u5206\u9875\u4fe1\u606f", paramType="body", dataTypeClass=PageDesc.class)
    @GetMapping(value={"/list"})
    @WrapUpResponseBody
    public PageQueryResult<Platform> list(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List listObjects = this.platformService.listObjects(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5e73\u53f0\u4fe1\u606f", notes="\u6839\u636e\u5e73\u53f0D\u67e5\u8be2\u5355\u4e2a\u5e73\u53f0\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="platId", value="\u5e73\u53f0ID", paramType="query", dataType="String")
    @GetMapping(value={"/{platId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public Platform getPlatform(@PathVariable String platId) {
        return this.platformService.getObjectById(platId);
    }

    @ApiOperation(value="\u5220\u9664\u5e73\u53f0\u4fe1\u606f", notes="\u6839\u636e\u5e73\u53f0ID\u5220\u9664\u5e73\u53f0\u4fe1\u606f\u3002")
    @ApiImplicitParam(name="platId", value="\u5e73\u53f0ID", paramType="query", dataType="String")
    @DeleteMapping(value={"/{platId}"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u5220\u9664\u5e73\u53f0", tag="{platId}")
    @WrapUpResponseBody
    public ResponseData delete(@ParamName(value="platId") @PathVariable String platId, HttpServletRequest request) {
        Platform platform = this.platformService.getObjectById(platId);
        if (platform == null) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.object_not_found", request, new Object[]{"Platform", platId}));
        }
        List userPlats = this.userPlatService.listPlatUsersByPlatId(platId);
        if (!CollectionUtils.isEmpty((Collection)userPlats)) {
            return ResponseData.makeErrorMessage((int)610, (String)this.getI18nMessage("error.610.cannot_delete_parent", request, new Object[]{"PlatUser-" + platId}));
        }
        this.platformService.deletePlatform(platform);
        return ResponseData.successResponse;
    }

    @ApiOperation(value="\u65b0\u5efa\u5e73\u53f0", notes="\u65b0\u5efa\u4e00\u4e2a\u5e73\u53f0\u3002")
    @ApiImplicitParam(name="platform", value="json\u683c\u5f0f\uff0c\u5e73\u53f0\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=Platform.class)
    @PostMapping
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u65b0\u589e\u5e73\u53f0", tag="{pf.platId}:{pf.platSourceCode}")
    @WrapUpResponseBody
    public ResponseData create(@ParamName(value="pf") @Valid Platform pf, HttpServletRequest request) {
        if (this.platformService.hasSamePlat(pf)) {
            return ResponseData.makeErrorMessage((int)702, (String)this.getI18nMessage("error.702.duplicate_primary_key", request, new Object[]{"Platform", pf.getPlatSourceCode()}));
        }
        this.platformService.savePlatform(pf);
        return ResponseData.makeResponseData((Object)pf);
    }

    @ApiOperation(value="\u66f4\u65b0\u5e73\u53f0\u4fe1\u606f", notes="\u66f4\u65b0\u5e73\u53f0\u4fe1\u606f\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="platId", value="\u5e73\u53f0id", paramType="path", dataType="String"), @ApiImplicitParam(name="platform", value="json\u683c\u5f0f\uff0c\u5e73\u53f0\u4fe1\u606f\u5bf9\u8c61", paramType="body", dataTypeClass=Platform.class)})
    @PutMapping(value={"/{platId}"})
    @RecordOperationLog(content="\u64cd\u4f5cIP\u5730\u5740:{loginIp},\u7528\u6237{loginUser.userName}\u66f4\u65b0\u5e73\u53f0", tag="{platId}")
    @WrapUpResponseBody
    public ResponseData edit(@ParamName(value="platId") @PathVariable String platId, @Valid Platform platform, HttpServletRequest request) {
        Platform dbPlatform = this.platformService.getObjectById(platId);
        if (null == dbPlatform) {
            return ResponseData.makeErrorMessage((int)604, (String)this.getI18nMessage("error.604.object_not_found", request, new Object[]{"Platform", platId}));
        }
        if (!dbPlatform.getPlatSourceCode().equals(platform.getPlatSourceCode()) && this.platformService.hasSamePlat(platform)) {
            return ResponseData.makeErrorMessage((int)702, (String)this.getI18nMessage("error.702.duplicate_primary_key", request, new Object[]{"Platform", platform.getPlatSourceCode()}));
        }
        this.platformService.updatePlatform(platform);
        return ResponseData.makeResponseData((Object)platform);
    }
}

