/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jtt.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.jtt.config.JsmotSyncConfig;
import com.centit.framework.jtt.config.UniteConfig;
import com.centit.framework.jtt.service.JttAccessTokenService;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitPasswordEncoder;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.framework.system.po.UserInfo;
import com.centit.framework.system.service.SysUserManager;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import com.newland.bi3.security.SM4Utils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jtt"})
@Api(value="\u7b2c\u4e09\u65b9\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"\u7b2c\u4e09\u65b9\u5e73\u53f0\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class JttLogin
extends BaseController {
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private JttAccessTokenService jttAccessTokenService;
    @Autowired
    private UniteConfig uniteConfig;
    @Autowired
    private CentitPasswordEncoder passwordEncoder;
    @Autowired
    private SysUserManager sysUserManager;
    @Autowired
    private JsmotSyncConfig jsmotSyncConfig;

    @ApiOperation(value="\u7edf\u4e00\u95e8\u6237\u5355\u70b9\u767b\u9646", notes="\u7edf\u4e00\u95e8\u6237\u5355\u70b9\u767b\u9646")
    @GetMapping(value={"/unitelogin"})
    public String uniteLogin(HttpServletRequest request) {
        Map filterMap = JttLogin.collectRequestParameters((HttpServletRequest)request);
        this.logger.info("\u7edf\u4e00\u95e8\u6237\u5355\u70b9\u767b\u9646,\u53c2\u6570\uff1a{}", (Object)filterMap);
        String token = String.valueOf(filterMap.get("token"));
        String returnUrl = String.valueOf(filterMap.get("returnUrl"));
        this.logger.info("returnUrl\u503c:{}", (Object)returnUrl);
        token = token.replace(" ", "+");
        String errorMsg = "";
        String accessToken = "";
        try {
            this.logger.info("token\u503c\uff1a{}", (Object)token);
            JSONObject params = new JSONObject();
            params.put("appId", (Object)this.uniteConfig.getAppId());
            params.put("token", (Object)URLEncoder.encode(token, "utf-8"));
            if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)token)) {
                String tokenResult = HttpExecutor.jsonPost((HttpExecutorContext)HttpExecutorContext.create(), (String)this.uniteConfig.getLoginCheckUrl(), (Object)params.toJSONString());
                this.logger.info("\u8c03\u7528\u9a8c\u8bc1token:{},\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)params, (Object)tokenResult);
                if (StringUtils.isNotEmpty((CharSequence)tokenResult)) {
                    JSONObject tokenJson = JSON.parseObject((String)tokenResult);
                    if (null != tokenJson && 200 == tokenJson.getInteger("status")) {
                        String loginCheckExtend = HttpExecutor.jsonPost((HttpExecutorContext)HttpExecutorContext.create(), (String)this.uniteConfig.getLoginCheckExtendUrl(), (Object)params.toJSONString());
                        this.logger.info("\u8c03\u7528\u6269\u5c55\u9a8c\u8bc1:{},\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)params, (Object)loginCheckExtend);
                        JSONObject loginExtendJson = JSON.parseObject((String)loginCheckExtend);
                        if (null != loginExtendJson) {
                            JSONObject userInfo = loginExtendJson.getJSONObject("data").getJSONObject("userInfo");
                            String loginName = userInfo.getString("loginName");
                            this.logger.info("loginName:{}", (Object)loginName);
                            CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(loginName);
                            if (null != ud) {
                                SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
                                accessToken = request.getSession().getId();
                                this.logger.info("\u7528\u6237\u540d\uff1a{}\u767b\u5f55\u6210\u529f", (Object)loginName);
                            } else {
                                errorMsg = "\u767b\u5f55\u540d" + loginName + "\u4e0d\u5b58\u5728\uff01";
                            }
                        } else {
                            errorMsg = "\u7edf\u4e00\u95e8\u6237\u6269\u5c55\u9a8c\u8bc1\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01";
                        }
                    } else {
                        errorMsg = null != tokenJson ? tokenJson.getString("msg") : "\u7edf\u4e00\u95e8\u6237token\u9a8c\u8bc1\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01";
                    }
                }
            } else {
                errorMsg = "\u7edf\u4e00\u95e8\u6237token\u4e3a\u7a7a\uff01";
            }
        }
        catch (Exception e) {
            this.logger.error("\u7edf\u4e00\u95e8\u6237\u5355\u70b9\u767b\u5f55\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            errorMsg = "\u7edf\u4e00\u95e8\u6237\u5355\u70b9\u767b\u5f55\u5f02\u5e38:" + e.getMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("URLEncoder\u5f02\u5e38", (Throwable)e);
            }
            return errorUrl;
        }
        if (StringUtils.isNotBlank((CharSequence)(returnUrl = StringUtils.isNotBlank((CharSequence)returnUrl) && returnUrl.contains("?") ? returnUrl + "&accessToken=" + accessToken : returnUrl + "?accessToken=" + accessToken)) && returnUrl.indexOf("/A/") > -1) {
            returnUrl = returnUrl.replace("/A/", "/#/");
        }
        return "redirect:" + returnUrl;
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u5355\u70b9\u767b\u9646", notes="\u79fb\u52a8\u7aef\u5355\u70b9\u767b\u9646")
    @GetMapping(value={"/applogin"})
    public String appLogin(HttpServletRequest request) {
        Map filterMap = JttLogin.collectRequestParameters((HttpServletRequest)request);
        this.logger.info("\u79fb\u52a8\u7aef\u5355\u70b9\u767b\u9646,\u53c2\u6570\uff1a{}", (Object)filterMap);
        String tmpAuthCode = String.valueOf(filterMap.get("tmp_auth_code"));
        String returnUrl = String.valueOf(filterMap.get("returnUrl"));
        this.logger.info("returnUrl\u503c:{}", (Object)returnUrl);
        if (StringUtils.isBlank((CharSequence)returnUrl)) {
            returnUrl = this.jsmotSyncConfig.getAppReturnUrl();
        }
        String errorMsg = "";
        String accessToken = "";
        try {
            this.logger.info("\u4e34\u65f6\u6388\u6743\u7801code\u503c\uff1a{}", (Object)tmpAuthCode);
            if (StringUtils.isNotBlank((CharSequence)tmpAuthCode)) {
                String token = this.getAccessToken();
                if (StringUtils.isBlank((CharSequence)token)) {
                    errorMsg = "\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u5931\u8d25";
                }
                if (StringUtils.isBlank((CharSequence)errorMsg)) {
                    String uri = this.jsmotSyncConfig.getJsmotHost() + "/authorize/tla/getuserinfo_bycode" + "/" + tmpAuthCode + "?accessToken=" + token;
                    String userResult = HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create(), (String)uri);
                    this.logger.info("\u8c03\u7528\u83b7\u53d6\u7528\u6237\u7684\u8be6\u7ec6\u4fe1\u606ftoken:{},\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)token, (Object)userResult);
                    if (StringUtils.isNotEmpty((CharSequence)userResult)) {
                        JSONObject userJson = JSON.parseObject((String)userResult);
                        if (null != userJson) {
                            long retCode = userJson.getLong("retCode");
                            String retMsg = userJson.getString("retMsg");
                            if (retCode == 0L) {
                                String loginName = userJson.getJSONObject("bizData").getString("loginName");
                                this.logger.info("loginName:{}", (Object)loginName);
                                CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(loginName);
                                if (null != ud) {
                                    SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
                                    accessToken = request.getSession().getId();
                                    this.logger.info("\u7528\u6237\u540d\uff1a{}\u767b\u5f55\u6210\u529f", (Object)loginName);
                                } else {
                                    errorMsg = "\u767b\u5f55\u540d" + loginName + "\u4e0d\u5b58\u5728\uff01";
                                }
                            } else {
                                errorMsg = retMsg;
                            }
                        } else {
                            errorMsg = "\u79fb\u52a8\u7aef\u83b7\u53d6\u7528\u6237\u7684\u8be6\u7ec6\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01";
                        }
                    } else {
                        errorMsg = "\u79fb\u52a8\u7aef\u83b7\u53d6\u7528\u6237\u7684\u8be6\u7ec6\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01";
                    }
                }
            } else {
                errorMsg = "\u4e34\u65f6\u6388\u6743\u7801\u4e3a\u7a7a\uff01";
            }
        }
        catch (Exception e) {
            this.logger.error("\u79fb\u52a8\u7aef\u5355\u70b9\u767b\u5f55\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            errorMsg = "\u79fb\u52a8\u7aef\u5355\u70b9\u767b\u5f55\u5f02\u5e38:" + e.getMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("URLEncoder\u5f02\u5e38", (Throwable)e);
            }
            return errorUrl;
        }
        if (StringUtils.isNotBlank((CharSequence)(returnUrl = StringUtils.isNotBlank((CharSequence)returnUrl) && returnUrl.contains("?") ? returnUrl + "&accessToken=" + accessToken : returnUrl + "?accessToken=" + accessToken)) && returnUrl.indexOf("/A/") > -1) {
            returnUrl = returnUrl.replace("/A/", "/#/");
        }
        return "redirect:" + returnUrl;
    }

    @GetMapping(value={"/redirecterror"})
    @WrapUpResponseBody
    public String redirectError(HttpServletRequest request) {
        String errorMsg = request.getParameter("msg");
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = "error";
        }
        return errorMsg;
    }

    @ApiOperation(value="\u7edf\u4e00\u95e8\u6237\u8d26\u53f7\u9a8c\u8bc1", notes="\u7edf\u4e00\u95e8\u6237\u8d26\u53f7\u9a8c\u8bc1")
    @ResponseBody
    @PostMapping(value={"/checkAppUserValid"})
    public Map<String, Object> checkAppUserValid(@RequestBody String userInfo, HttpServletRequest request) {
        this.logger.info("\u7edf\u4e00\u95e8\u6237\u8d26\u53f7\u9a8c\u8bc1\uff1b{}", (Object)userInfo);
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        JSONObject userInfoJson = JSON.parseObject((String)userInfo);
        if (null != userInfoJson) {
            String password = JttLogin.sm4dDecrypt(userInfoJson.getString("userPwd"), this.uniteConfig.getUniteAppSecret());
            UserInfo user = this.sysUserManager.loadUserByLoginname(userInfoJson.getString("userAccount"));
            if (null != user && this.passwordEncoder.isPasswordValid(user.getUserPin(), password, (Object)user.getUserCode())) {
                resMap.put("status", 200);
                resMap.put("msg", "OK");
            } else {
                resMap.put("status", 601);
                resMap.put("msg", "\u767b\u5f55\u540d\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef\uff01");
            }
        } else {
            resMap.put("status", 500);
            resMap.put("msg", "\u767b\u5165\u8d26\u53f7\u548c\u5bc6\u7801\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        return resMap;
    }

    private static String sm4dDecrypt(String encryptData, String key) {
        String decryptData = null;
        try {
            SM4Utils sm4 = new SM4Utils();
            sm4.secretKey = key;
            decryptData = sm4.decryptData_ECB(encryptData);
        }
        catch (Exception e) {
            return null;
        }
        return decryptData;
    }

    private String getAccessToken() {
        String accessToken = "";
        ResponseData accessTokenData = this.jttAccessTokenService.getJsmotAccessToken();
        if (accessTokenData.getCode() != 0) {
            return "";
        }
        accessToken = accessTokenData.getData().toString();
        return accessToken;
    }
}

