/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jtt.service;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.jtt.config.JsmotSyncConfig;
import com.centit.framework.jtt.po.JttToken;
import com.centit.framework.jtt.service.JttTokenService;
import com.centit.framework.jtt.utils.HttpUtil;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JttAccessTokenService {
    private static final Logger log = LoggerFactory.getLogger(JttAccessTokenService.class);
    private static final long CACHE_TTL = 3600000L;
    @Autowired
    private JttTokenService jttTokenService;
    @Autowired
    private JsmotSyncConfig jsmotSyncConfig;

    public String getFromDb(String section) {
        JttToken accessToken = this.jttTokenService.getObjectById(section);
        if (null != accessToken) {
            long createTime = accessToken.getCreateTime().getTime();
            if (System.currentTimeMillis() - createTime <= accessToken.getExpireIn() * 1000L) {
                return accessToken.getAccessToken();
            }
        }
        return null;
    }

    private void saveTokenTodb(String section, String value, Long expiresIn) {
        JttToken accessToken = new JttToken();
        accessToken.setAppId(section);
        accessToken.setAccessToken(value);
        accessToken.setExpireIn(expiresIn);
        accessToken.setExpireTime(new Date(System.currentTimeMillis() + expiresIn * 1000L));
        this.jttTokenService.saveAccessToke(accessToken);
    }

    public ResponseData getJsmotAccessToken() {
        String accessToken = this.getFromDb(this.jsmotSyncConfig.getCustomKey());
        long expiresIn = 0L;
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            return ResponseData.makeResponseData((Object)accessToken);
        }
        String retMsg = "";
        long retCode = 1L;
        try {
            String uri = this.jsmotSyncConfig.getJsmotHost() + "/authorize/apiLic/getAccessToken" + "?customKey=" + this.jsmotSyncConfig.getCustomKey() + "&customSecret=" + this.jsmotSyncConfig.getCustomSecret();
            String jsonStr = HttpExecutor.simpleGet((HttpExecutorContext)HttpExecutorContext.create(), (String)uri);
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            if (null != jsonObject) {
                retCode = jsonObject.getLong("retCode");
                retMsg = jsonObject.getString("retMsg");
                if (retCode != 0L) {
                    return ResponseData.makeErrorMessage((int)Integer.valueOf(String.valueOf(retCode)), (String)retMsg);
                }
            } else {
                return ResponseData.makeErrorMessage((int)1, (String)"\u8c03\u7528\u83b7\u53d6\u4ea4\u901a\u4e91accessToken\u6388\u6743\u7801\u8fd4\u56de\u4e3a\u7a7a");
            }
            accessToken = jsonObject.getJSONObject("bizData").getString("accessToken");
            expiresIn = jsonObject.getJSONObject("bizData").getLong("validperiod");
        }
        catch (Exception e) {
            log.error("getJsmotAccessToken failed", (Throwable)e);
            return ResponseData.makeErrorMessage((int)1, (String)e.getMessage());
        }
        this.saveTokenTodb(this.jsmotSyncConfig.getCustomKey(), accessToken, expiresIn);
        return ResponseData.makeResponseData((Object)accessToken);
    }

    public ResponseData getSmsAccessToken() {
        String accessToken = this.getFromDb(this.jsmotSyncConfig.getSmsUser());
        long expiresIn = 0L;
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            return ResponseData.makeResponseData((Object)accessToken);
        }
        String retMsg = "";
        long retCode = 1L;
        try {
            String uri = this.jsmotSyncConfig.getSmsHost() + "/gettoken";
            String param = "username=" + this.jsmotSyncConfig.getSmsUser() + "&password=" + this.jsmotSyncConfig.getSmsPwd();
            String jsonStr = HttpUtil.httpPostRequest(uri, "form", "", param);
            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
            if (null != jsonObject) {
                retCode = jsonObject.getLong("code");
                retMsg = jsonObject.getString("msg");
                if (retCode != 200L) {
                    return ResponseData.makeErrorMessage((int)Integer.valueOf(String.valueOf(retCode)), (String)retMsg);
                }
            } else {
                return ResponseData.makeErrorMessage((int)1, (String)"\u8c03\u7528\u83b7\u53d6\u77ed\u4fe1\u5e73\u53f0accessToken\u6388\u6743\u7801\u8fd4\u56de\u4e3a\u7a7a");
            }
            accessToken = jsonObject.getJSONObject("data").getString("token");
            expiresIn = jsonObject.getJSONObject("data").getLong("expiresIn");
        }
        catch (Exception e) {
            log.error("getSmsAccessToken failed", (Throwable)e);
            return ResponseData.makeErrorMessage((int)1, (String)e.getMessage());
        }
        this.saveTokenTodb(this.jsmotSyncConfig.getSmsUser(), accessToken, expiresIn);
        return ResponseData.makeResponseData((Object)accessToken);
    }
}

