/*
 * Decompiled with CFR 0.152.
 */
package com.centit.framework.jtt.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.framework.common.ResponseData;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.jtt.config.NtzwConfig;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.security.model.CentitUserDetails;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/ntzw"})
@Api(value="\u5357\u901a\u653f\u52a1\u767b\u5f55\u76f8\u5173\u63a5\u53e3", tags={"\u5357\u901a\u653f\u52a1\u767b\u5f55\u76f8\u5173\u63a5\u53e3"})
public class NtzwLogin
extends BaseController {
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private NtzwConfig ntzwConfig;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiOperation(value="\u5357\u901a\u653f\u52a1\u5355\u70b9\u767b\u9646", notes="\u5357\u901a\u653f\u52a1\u5355\u70b9\u767b\u9646")
    @GetMapping(value={"/login"})
    public ResponseData login(HttpServletRequest request) {
        String accessToken;
        String errorMsg;
        String returnUrl;
        HashMap<String, Object> result;
        block14: {
            result = new HashMap<String, Object>();
            Map filterMap = NtzwLogin.collectRequestParameters((HttpServletRequest)request);
            this.logger.info("\u5357\u901a\u653f\u52a1\u5355\u70b9\u767b\u9646,\u53c2\u6570\uff1a{}", (Object)filterMap);
            String ticket = request.getParameter("ticket");
            returnUrl = request.getParameter("returnUrl");
            if (StringUtils.isBlank((CharSequence)returnUrl)) {
                returnUrl = this.ntzwConfig.getNtReturnUrl();
            }
            this.logger.info("returnUrl\u503c:{}", (Object)returnUrl);
            errorMsg = "";
            accessToken = "";
            try {
                this.logger.info("ticket\u503c\uff1a{}", (Object)ticket);
                JSONObject params = new JSONObject();
                params.put((Object)"appid", (Object)this.ntzwConfig.getNtAppId());
                params.put((Object)"ticket", (Object)ticket);
                if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)ticket)) {
                    Boolean useSSL = BooleanBaseOpt.castObjectToBoolean((Object)this.ntzwConfig.getNtSSL(), (Boolean)false);
                    HttpClientContext context = HttpClientContext.create();
                    CloseableHttpClient httpClient = null;
                    httpClient = useSSL != false ? HttpExecutor.createKeepSessionHttpsClient() : HttpExecutor.createKeepSessionHttpClient();
                    HttpExecutorContext executorContext = HttpExecutorContext.create((CloseableHttpClient)httpClient).context((HttpContext)context);
                    String ticketResult = HttpExecutor.jsonPost((HttpExecutorContext)executorContext, (String)this.ntzwConfig.getTicketUrl(), (Object)params.toJSONString(new JSONWriter.Feature[0]));
                    this.logger.info("\u8c03\u7528\u9a8c\u8bc1ticket:{},\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)params, (Object)ticketResult);
                    if (StringUtils.isNotEmpty((CharSequence)ticketResult)) {
                        JSONObject ticketJson = JSON.parseObject((String)ticketResult);
                        if (null != ticketJson) {
                            String tocken = ticketJson.getString("tocken");
                            params.remove((Object)"ticket");
                            params.put((Object)"token", (Object)tocken);
                            String loginUser = HttpExecutor.jsonPost((HttpExecutorContext)executorContext, (String)this.ntzwConfig.getFindUserUrl(), (Object)params.toJSONString(new JSONWriter.Feature[0]));
                            this.logger.info("\u8c03\u7528\u83b7\u53d6\u7528\u6237:{},\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)params, (Object)loginUser);
                            JSONObject loginUserJson = JSON.parseObject((String)loginUser);
                            if (null != loginUserJson && StringUtils.isBlank((CharSequence)loginUserJson.getString("errormsg"))) {
                                String loginName = loginUserJson.getString("loginname");
                                String mobile = loginUserJson.getString("mobile");
                                this.logger.info("loginName:{},mobile:{}", (Object)loginName, (Object)mobile);
                                CentitUserDetails ud = this.platformEnvironment.loadUserDetailsByLoginName(loginName);
                                if (null == ud) {
                                    ud = this.platformEnvironment.loadUserDetailsByRegCellPhone(mobile);
                                }
                                if (null == ud) {
                                    String corpJsonStr = HttpExecutor.jsonPost((HttpExecutorContext)executorContext, (String)this.ntzwConfig.getFindCorpUrl(), (Object)params.toJSONString(new JSONWriter.Feature[0]));
                                    JSONObject corpJson = JSON.parseObject((String)corpJsonStr);
                                    result.put("userInfo", loginUserJson);
                                    result.put("unitInfo", corpJson);
                                    return ResponseData.makeResponseData(result);
                                }
                                SecurityContextHolder.getContext().setAuthentication((Authentication)ud);
                                accessToken = request.getSession().getId();
                                this.logger.info("\u7528\u6237\u540d\uff1a{}\u767b\u5f55\u6210\u529f", (Object)loginName);
                                break block14;
                            } else {
                                errorMsg = null != loginUserJson ? ticketJson.getString("errormsg") : "\u83b7\u53d6\u7528\u6237\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01";
                            }
                            break block14;
                        }
                        errorMsg = null != ticketJson ? ticketJson.getString("errormsg") : "\u5357\u901a\u653f\u52a1ticket\u9a8c\u8bc1\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01";
                        break block14;
                    }
                    errorMsg = "\u5357\u901a\u653f\u52a1ticket\u9a8c\u8bc1\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff01";
                    break block14;
                }
                errorMsg = "\u5357\u901a\u653f\u52a1ticket\u4e3a\u7a7a\uff01";
            }
            catch (Exception e) {
                this.logger.error("\u5357\u901a\u653f\u52a1\u5355\u70b9\u767b\u5f55\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                errorMsg = "\u5357\u901a\u653f\u52a1\u5355\u70b9\u767b\u5f55\u5f02\u5e38:" + e.getMessage();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            String errorUrl = "redirect:redirecterror";
            try {
                errorUrl = errorUrl + "?msg=" + URLEncoder.encode(errorMsg, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error("URLEncoder\u5f02\u5e38", (Throwable)e);
            }
            result.put("url", errorUrl);
            return ResponseData.makeResponseData(result);
        }
        if (StringUtils.isNotBlank((CharSequence)(returnUrl = StringUtils.isNotBlank((CharSequence)returnUrl) && returnUrl.contains("?") ? returnUrl + "&accessToken=" + accessToken : returnUrl + "?accessToken=" + accessToken)) && returnUrl.indexOf("/A/") > -1) {
            returnUrl = returnUrl.replace("/A/", "/#/");
        }
        result.put("url", returnUrl);
        return ResponseData.makeResponseData(result);
    }

    @GetMapping(value={"/redirecterror"})
    @WrapUpResponseBody
    public String redirectError(HttpServletRequest request) {
        String errorMsg = request.getParameter("msg");
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = "error";
        }
        return errorMsg;
    }
}

