/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.adapter.po.DataPacket;
import com.centit.dde.services.DataPacketService;
import com.centit.dde.utils.LoginUserPermissionCheck;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5df2\u53d1\u5e03API\u7f51\u5173\u63a5\u53e3\u7ba1\u7406", tags={"\u5df2\u53d1\u5e03API\u7f51\u5173\u63a5\u53e3\u7ba1\u7406"})
@RestController
@RequestMapping(value={"packet"})
public class DataPacketController
extends BaseController {
    private final DataPacketService dataPacketService;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    public DataPacketController(DataPacketService dataPacketService) {
        this.dataPacketService = dataPacketService;
    }

    @ApiOperation(value="\u67e5\u8be2API\u7f51\u5173")
    @GetMapping
    @WrapUpResponseBody
    public PageQueryResult<DataPacket> listDataPacket(HttpServletRequest request, PageDesc pageDesc) {
        List list = this.dataPacketService.listDataPacket(BaseController.collectRequestParameters((HttpServletRequest)request), pageDesc);
        return PageQueryResult.createResult((Collection)list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u67e5\u8be2API\u7f51\u5173")
    @GetMapping(value={"/workflow/{optId}"})
    @WrapUpResponseBody
    public List<Map<String, String>> listDataPacket(@PathVariable String optId, HttpServletRequest request) {
        return this.dataPacketService.listDataPacket(optId, WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2aAPI\u7f51\u5173")
    @GetMapping(value={"/{packetId}"})
    @WrapUpResponseBody
    public DataPacket getDataPacket(@PathVariable String packetId) {
        return this.dataPacketService.getDataPacket(packetId);
    }

    @ApiOperation(value="\u66f4\u6539api\u65e5\u5fd7\u6a21\u5f0f")
    @ApiImplicitParam(name="jsonObject", value="\u66f4\u6539api\u65e5\u5fd7\u7ea7\u522b\u53c2\u6570\uff1a{logLevel:\"logLevel\", packetIds:[\"packetId\"],osId:\"osId\"};")
    @PutMapping(value={"/chgLogLevel"})
    @WrapUpResponseBody
    public void chgLogLevel(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        JSONArray packetIds = jsonObject.getJSONArray("packetIds");
        String osId = jsonObject.getString("osId");
        LoginUserPermissionCheck.loginUserPermissionCheck(this, this.platformEnvironment, osId, request);
        String logLevel = jsonObject.getString("logLevel");
        int lv = DataPacket.mapLogLevel((String)logLevel);
        if (lv < 1) {
            throw new ObjectException(611, "\u65e5\u5fd7\u7b49\u7ea7\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        List apis = StringBaseOpt.objectToStringList((Object)packetIds);
        this.dataPacketService.updatePackedLogLevel(lv, apis);
    }

    @ApiOperation(value="\u66f4\u6539\u5e94\u7528\u6240\u6709api\u65e5\u5fd7\u6a21\u5f0f")
    @ApiImplicitParam(name="jsonObject", value="\u66f4\u6539\u5e94\u7528\u6240\u6709\u65e5\u5fd7\u7ea7\u522b\u53c2\u6570\uff1a{logLevel:\"logLevel\", osId:\"osId\"}")
    @PutMapping(value={"/chgOSLogLevel"})
    @WrapUpResponseBody
    public void chgOSLogLevel(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        String osId = jsonObject.getString("osId");
        String logLevel = jsonObject.getString("logLevel");
        LoginUserPermissionCheck.loginUserPermissionCheck(this, this.platformEnvironment, osId, request);
        int lv = DataPacket.mapLogLevel((String)logLevel);
        if (lv < 1) {
            throw new ObjectException(611, "\u65e5\u5fd7\u7b49\u7ea7\u53c2\u6570\u4e0d\u6b63\u786e\uff01");
        }
        this.dataPacketService.updateApplicationLogLevel(lv, osId);
    }
}

