/*
 * Decompiled with CFR 0.152.
 */
package com.centit.dde.bizopt;

import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.core.BizModel;
import com.centit.dde.core.BizOperation;
import com.centit.dde.core.DataOptContext;
import com.centit.dde.core.DataSet;
import com.centit.dde.utils.BizModelJSONTransform;
import com.centit.framework.common.ResponseData;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.msgpusher.plugins.EMailMsgPusher;
import com.centit.msgpusher.plugins.IUserEmailSupport;
import com.centit.msgpusher.plugins.SystemUserEmailSupport;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.SourceInfoMetadata;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.json.JSONTransformDataSupport;
import com.centit.support.json.JSONTransformer;
import com.centit.support.security.SecurityOptUtils;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;

public class MailBizOperation
implements BizOperation {
    private static final String SEND_TYPE_MAIL = "M";
    private SourceInfoMetadata sourceInfoMetadata;

    public MailBizOperation(SourceInfoMetadata sourceInfoMetadata) {
        this.sourceInfoMetadata = sourceInfoMetadata;
    }

    public ResponseData runOpt(BizModel bizModel, JSONObject bizOptJson, DataOptContext dataOptContext) throws Exception {
        String sendType = bizOptJson.getString("sendType");
        String id = bizOptJson.getString("id");
        BizModelJSONTransform jsonTransform = new BizModelJSONTransform(bizModel);
        HashSet optUsers = CollectionsOpt.createHashSet((Object[])new String[]{StringBaseOpt.castObjectToString((Object)JSONTransformer.transformer((Object)bizOptJson.getString("optUsers"), (JSONTransformDataSupport)jsonTransform))});
        String subject = StringBaseOpt.castObjectToString((Object)JSONTransformer.transformer((Object)bizOptJson.getString("subject"), (JSONTransformDataSupport)jsonTransform));
        String content = StringBaseOpt.castObjectToString((Object)JSONTransformer.transformer((Object)bizOptJson.getString("content"), (JSONTransformDataSupport)jsonTransform));
        if (SEND_TYPE_MAIL.equals(sendType)) {
            SourceInfo sourceInfo = this.sourceInfoMetadata.fetchSourceInfo(bizOptJson.getString("mailServer"));
            EMailMsgPusher messageManager = new EMailMsgPusher();
            messageManager.setEmailServerHost(sourceInfo.getDatabaseUrl());
            messageManager.setEmailServerUser(sourceInfo.getUsername());
            messageManager.setEmailServerPwd(SecurityOptUtils.decodeSecurityString((String)sourceInfo.getPassword()));
            String topUnit = dataOptContext.getTopUnit();
            if (StringUtils.isBlank((CharSequence)topUnit)) {
                topUnit = bizModel.fetchTopUnit();
            }
            messageManager.setTopUnit(topUnit);
            messageManager.setUserEmailSupport((IUserEmailSupport)new SystemUserEmailSupport());
            ResponseData responseData = messageManager.sendMessage("system", (Collection)optUsers, NoticeMessage.create().topUnit(topUnit).operation(dataOptContext.getOsId()).method(dataOptContext.getOptId()).subject(subject).content(content));
            bizModel.putDataSet(id, new DataSet((Object)responseData));
            return responseData;
        }
        return ResponseData.makeErrorMessage((int)500, (String)"IM \u53d1\u9001\u6ca1\u6709\u5b9e\u73b0");
    }
}

