/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.product.metadata.dao.SourceInfoDao;
import com.centit.product.metadata.po.SourceInfo;
import com.centit.product.metadata.service.SourceInfoManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="databaseInfoManager")
@Transactional
public class SourceInfoManagerImpl
implements SourceInfoManager {
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private SourceInfoDao sourceInfoDao;

    @Override
    public SourceInfo getObjectById(String databaseCode) {
        return this.sourceInfoDao.getDatabaseInfoById(databaseCode);
    }

    @Override
    public int deleteObjectById(String databaseCode) {
        return this.sourceInfoDao.deleteObjectById((Object)databaseCode);
    }

    @Override
    public List<SourceInfo> listDatabase() {
        return this.sourceInfoDao.listDatabase();
    }

    @Override
    public void saveNewObject(SourceInfo sourceInfo) {
        this.checkDatabaseNumberLimit(sourceInfo);
        this.sourceInfoDao.saveNewObject(sourceInfo);
    }

    @Override
    public void mergeObject(SourceInfo sourceInfo) {
        this.sourceInfoDao.mergeObject(sourceInfo);
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, SourceInfo> listDatabaseToDBRepo() {
        List dbList = this.sourceInfoDao.listObjects();
        HashMap<String, SourceInfo> dbmap = new HashMap<String, SourceInfo>();
        if (dbList != null) {
            for (SourceInfo db : dbList) {
                dbmap.put(db.getDatabaseCode(), db);
            }
        }
        return dbmap;
    }

    @Override
    public List<SourceInfo> listObjects(Map<String, Object> map) {
        return this.sourceInfoDao.listObjectsByProperties(map);
    }

    @Override
    public JSONArray listDatabaseAsJson(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.sourceInfoDao.listObjectsByPropertiesAsJson(filterMap, pageDesc);
    }

    @Override
    @Transactional
    public void appendRelativeOsInfo(JSONArray sourceInfoList) {
        if (sourceInfoList == null || sourceInfoList.size() == 0) {
            return;
        }
        for (Object obj : sourceInfoList) {
            JSONObject jsonObject;
            String databaseCode;
            JSONArray osList;
            if (!(obj instanceof JSONObject) || (osList = this.sourceInfoDao.listRelativeOsInfo(databaseCode = (jsonObject = (JSONObject)obj).getString("databaseCode"))) == null) continue;
            jsonObject.put((Object)"relativeOs", (Object)osList);
        }
    }

    @Override
    public JSONArray queryDatabaseAsJson(String databaseName, PageDesc pageDesc) {
        return this.sourceInfoDao.queryDatabaseAsJson(databaseName, pageDesc);
    }

    @Override
    @Transactional
    public List<SourceInfo> listDatabaseByOsId(String osId) {
        return this.sourceInfoDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"osId", osId}));
    }

    private void checkDatabaseNumberLimit(SourceInfo sourceInfo) {
        JSONObject tenantInfo = this.platformEnvironment.getTenantInfoByTopUnit(sourceInfo.getTopUnit());
        if (null == tenantInfo) {
            throw new ObjectException("\u79df\u6237\u4fe1\u606f\u6709\u8bef!");
        }
        int countDataBase = this.countDataBase(sourceInfo.getTopUnit(), null);
        if (countDataBase >= tenantInfo.getIntValue("databaseNumberLimit")) {
            throw new ObjectException("\u6570\u636e\u5e93\u8d44\u6e90\u8d85\u8fc7\u4e86\u9650\u5236!");
        }
    }

    private int countDataBase(String topUnit, String sourceType) {
        Map params = CollectionsOpt.createHashMap((Object[])new Object[]{"topUnit", topUnit});
        if (StringUtils.isNotBlank((CharSequence)sourceType)) {
            params.put("sourceType", sourceType);
        }
        return this.sourceInfoDao.countDataBase(params);
    }
}

