/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.service.impl;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.dao.FileStoreInfoDao;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.jdbc.service.BaseEntityManagerImpl;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="fileStoreInfoManager")
@Transactional
public class FileStoreInfoManagerImpl
extends BaseEntityManagerImpl<FileStoreInfo, String, FileStoreInfoDao>
implements FileStoreInfoManager {
    @Autowired
    private FileStore fileStore;

    @Autowired
    @NotNull
    protected void setBaseDao(FileStoreInfoDao baseDao) {
        this.baseDao = baseDao;
    }

    @Override
    public boolean saveTempFileInfo(FileInfo fileInfo, String tempFilePath, long size) {
        String fileStoreUrl;
        boolean isExist;
        FileStoreInfo fileStoreInfo = (FileStoreInfo)((FileStoreInfoDao)this.baseDao).getObjectById(fileInfo.getFileMd5());
        if (fileStoreInfo != null) {
            if ("E".equals(fileStoreInfo.getIsTemp())) {
                ((FileStoreInfoDao)this.baseDao).deleteObjectById(fileStoreInfo.getFileMd5());
            } else {
                this.increaseFileReference(fileStoreInfo);
                return false;
            }
        }
        if (isExist = this.fileStore.checkFile(fileStoreUrl = this.fileStore.matchFileStoreUrl((FileBaseInfo)fileInfo, size))) {
            tempFilePath = fileStoreUrl;
        }
        fileStoreInfo = new FileStoreInfo(fileInfo.getFileMd5(), size, tempFilePath, 1L, !isExist);
        ((FileStoreInfoDao)this.baseDao).saveNewObject(fileStoreInfo);
        return !isExist;
    }

    @Override
    public void increaseFileReference(FileStoreInfo fileStoreInfo) {
        fileStoreInfo.setFileReferenceCount(fileStoreInfo.getFileReferenceCount() + 1L);
        ((FileStoreInfoDao)this.baseDao).updateObject(fileStoreInfo);
    }

    @Override
    public void decreaseFileReference(String fileMd5) {
        if (StringUtils.isBlank((CharSequence)fileMd5)) {
            return;
        }
        FileStoreInfo fileStoreInfo = (FileStoreInfo)((FileStoreInfoDao)this.baseDao).getObjectById(fileMd5);
        if (fileStoreInfo == null) {
            return;
        }
        Long currentFileReferenceCount = fileStoreInfo.getFileReferenceCount() - 1L;
        fileStoreInfo.setFileReferenceCount(currentFileReferenceCount);
        ((FileStoreInfoDao)this.baseDao).updateObject(fileStoreInfo);
    }

    @Override
    public List<FileStoreInfo> listTempFile(int limit) {
        return ((FileStoreInfoDao)this.baseDao).listTempFile(limit);
    }

    @Override
    public void markStoreErrorTag(FileStoreInfo fileStoreInfo) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.baseDao, (String)"update FILE_STORE_INFO set IS_TEMP = 'E' where FILE_MD5 = ? and IS_TEMP='T'", (Object[])new Object[]{fileStoreInfo.getFileMd5()});
    }
}

