/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task;

import com.centit.fileserver.common.FileBaseInfo;
import com.centit.fileserver.common.FileStore;
import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskOpeator;
import com.centit.fileserver.po.FileInfo;
import com.centit.fileserver.po.FileStoreInfo;
import com.centit.fileserver.pretreat.FilePretreatUtils;
import com.centit.fileserver.service.FileInfoManager;
import com.centit.fileserver.service.FileStoreInfoManager;
import com.centit.fileserver.utils.SystemTempFileUtils;
import com.centit.search.document.ESDocument;
import com.centit.search.document.FileDocument;
import com.centit.search.service.ESServerConfig;
import com.centit.search.service.Impl.ESIndexer;
import com.centit.search.service.IndexerSearcherFactory;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DocumentIndexOpt
implements FileTaskOpeator {
    private static final Logger logger = LoggerFactory.getLogger(DocumentIndexOpt.class);
    @Autowired
    private FileInfoManager fileInfoManager;
    @Autowired(required=false)
    private ESServerConfig esServerConfig = null;
    @Autowired
    protected FileStore fileStore;
    @Autowired
    private FileStoreInfoManager fileStoreInfoManager;

    public ESIndexer fetchDocumentIndexer() {
        if (this.esServerConfig == null) {
            return null;
        }
        return IndexerSearcherFactory.obtainIndexer((ESServerConfig)this.esServerConfig, FileDocument.class);
    }

    public String getOpeatorName() {
        return "index";
    }

    private static boolean canIndex(String fileType) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)fileType, (CharSequence[])new CharSequence[]{"txt", "csv", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "pdf", "html", "xml"});
    }

    public FileTaskInfo attachTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (BooleanBaseOpt.castObjectToBoolean((Object)pretreatInfo.get("index"), (Boolean)false).booleanValue() && DocumentIndexOpt.canIndex(fileInfo.getFileType())) {
            FileTaskInfo indexTaskInfo = new FileTaskInfo(this.getOpeatorName());
            indexTaskInfo.copy((FileBaseInfo)fileInfo);
            indexTaskInfo.setFileSize(Long.valueOf(fileSize));
            return indexTaskInfo;
        }
        return null;
    }

    public void doFileIndex(FileInfo fileInfo, long fileSize) {
        try {
            FileDocument fileDoc;
            String originalTempFilePath = SystemTempFileUtils.getTempFilePath((String)fileInfo.getFileMd5(), (long)fileSize);
            if (FileSystemOpt.existFile((String)originalTempFilePath)) {
                fileDoc = FilePretreatUtils.index(fileInfo, new File(originalTempFilePath));
            } else {
                FileStoreInfo fileStoreInfo = (FileStoreInfo)this.fileStoreInfoManager.getObjectById((Serializable)((Object)fileInfo.getFileMd5()));
                fileDoc = FilePretreatUtils.index(fileInfo, this.fileStore.getFile(fileStoreInfo.getFileStorePath()));
            }
            this.fetchDocumentIndexer().mergeDocument((ESDocument)fileDoc);
            logger.info("\u6587\u4ef6\u5df2\u52a0\u5165\u5168\u6587\u68c0\u7d22");
            this.fileInfoManager.updateObject((Serializable)fileInfo);
        }
        catch (Exception e) {
            logger.error("\u627e\u4e0d\u5230\u88ab\u7d22\u5f15\u7684\u6587\u4ef6\uff0c" + e.getMessage(), (Throwable)e);
        }
    }

    public int runTaskInfo(FileInfo fileInfo, long fileSize, Map<String, Object> pretreatInfo) {
        if (this.esServerConfig == null) {
            return 0;
        }
        if (BooleanBaseOpt.castObjectToBoolean((Object)pretreatInfo.get("index"), (Boolean)false).booleanValue() && DocumentIndexOpt.canIndex(fileInfo.getFileType())) {
            this.doFileIndex(fileInfo, fileSize);
            return 1;
        }
        return 0;
    }

    public void doFileTask(FileTaskInfo fileOptTaskInfo) {
        if (this.esServerConfig == null) {
            return;
        }
        String fileId = fileOptTaskInfo.getFileId();
        long fileSize = fileOptTaskInfo.getFileSize();
        FileInfo fileInfo = (FileInfo)this.fileInfoManager.getObjectById((Serializable)((Object)fileId));
        if (null == fileInfo) {
            return;
        }
        this.doFileIndex(fileInfo, fileSize);
    }
}

