/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.orm;

import com.centit.support.common.LeftRightPair;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.orm.ValueGenerator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TableMapInfo
extends SimpleTableInfo {
    private List<SimpleTableField> lazyColumns = null;
    private List<LeftRightPair<String, ValueGenerator>> valueGenerators;

    public List<LeftRightPair<String, ValueGenerator>> getValueGenerators() {
        return this.valueGenerators;
    }

    public TableMapInfo addValueGenerator(String fieldName, ValueGenerator generator) {
        if (this.valueGenerators == null) {
            this.valueGenerators = new ArrayList<LeftRightPair<String, ValueGenerator>>(5);
        }
        this.valueGenerators.add((LeftRightPair<String, ValueGenerator>)new LeftRightPair((Object)fieldName, (Object)generator));
        return this;
    }

    public List<SimpleTableField> getLazyColumns() {
        if (this.lazyColumns == null) {
            this.lazyColumns = new ArrayList<SimpleTableField>(20);
        }
        return this.lazyColumns;
    }

    public void addLazyColumn(SimpleTableField column) {
        this.getLazyColumns().add(column);
    }

    @Override
    public SimpleTableField findFieldByName(String name) {
        for (SimpleTableField col : this.getColumns()) {
            if (!col.getPropertyName().equals(name)) continue;
            return col;
        }
        if (this.lazyColumns != null) {
            for (SimpleTableField col : this.lazyColumns) {
                if (!col.getPropertyName().equals(name)) continue;
                return col;
            }
        }
        for (SimpleTableField col : this.getColumns()) {
            if (!col.getColumnName().equalsIgnoreCase(name)) continue;
            return col;
        }
        if (this.lazyColumns != null) {
            for (SimpleTableField col : this.lazyColumns) {
                if (!col.getColumnName().equalsIgnoreCase(name)) continue;
                return col;
            }
        }
        return null;
    }

    @Override
    public SimpleTableField findFieldByColumn(String name) {
        for (SimpleTableField col : this.getColumns()) {
            if (!col.getColumnName().equalsIgnoreCase(name)) continue;
            return col;
        }
        if (this.lazyColumns != null) {
            for (SimpleTableField col : this.lazyColumns) {
                if (!col.getColumnName().equalsIgnoreCase(name)) continue;
                return col;
            }
        }
        for (SimpleTableField col : this.getColumns()) {
            if (!col.getPropertyName().equals(name)) continue;
            return col;
        }
        if (this.lazyColumns != null) {
            for (SimpleTableField col : this.lazyColumns) {
                if (!col.getPropertyName().equals(name)) continue;
                return col;
            }
        }
        return null;
    }

    public String buildFieldIncludeLazySql(String alias) {
        StringBuilder sBuilder = new StringBuilder();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : this.getColumns()) {
            if (i > 0) {
                sBuilder.append(", ");
            } else {
                sBuilder.append(" ");
            }
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
            ++i;
        }
        if (this.lazyColumns != null) {
            for (TableField tableField : this.lazyColumns) {
                sBuilder.append(", ");
                if (addAlias) {
                    sBuilder.append(alias).append('.');
                }
                sBuilder.append(tableField.getColumnName());
            }
        }
        return sBuilder.toString();
    }

    public String buildLazyFieldSql(String alias) {
        if (this.lazyColumns == null || this.lazyColumns.size() < 1) {
            return null;
        }
        StringBuilder sBuilder = new StringBuilder();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : this.lazyColumns) {
            if (i > 0) {
                sBuilder.append(", ");
            } else {
                sBuilder.append(" ");
            }
            ++i;
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
        }
        return sBuilder.toString();
    }

    public void appendOrderBy(SimpleTableField column, String orderBy) {
        String orderBySql = StringUtils.isBlank((CharSequence)orderBy) || "ASC".equalsIgnoreCase(orderBy) ? column.getColumnName() : ("DESC".equalsIgnoreCase(orderBy) ? column.getColumnName() + " DESC" : orderBy);
        if (StringUtils.isBlank((CharSequence)this.getOrderBy())) {
            super.setOrderBy(orderBySql);
        } else {
            super.setOrderBy(super.getOrderBy() + ", " + orderBySql);
        }
    }
}

