/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.jsonmaptable;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.jsonmaptable.DB2JsonObjectDao;
import com.centit.support.database.jsonmaptable.H2JsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.jsonmaptable.MySqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.OracleJsonObjectDao;
import com.centit.support.database.jsonmaptable.PostgreSqlJsonObjectDao;
import com.centit.support.database.jsonmaptable.SqlSvrJsonObjectDao;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class GeneralJsonObjectDao
implements JsonObjectDao {
    public static final String SELF_ORDER_BY = "ORDER_BY";
    public static final String TABLE_SORT_FIELD = "sort";
    public static final String TABLE_SORT_ORDER = "order";
    private Connection conn;
    private TableInfo tableInfo;

    public GeneralJsonObjectDao() {
    }

    public static Map<String, Object> mapObjectProperties(TableInfo tableInfo, Map<String, Object> properties) {
        for (TableField tableField : tableInfo.getColumns()) {
            if (!properties.containsKey(tableField.getColumnName()) || properties.containsKey(tableField.getPropertyName())) continue;
            properties.put(tableField.getPropertyName(), properties.get(tableField.getColumnName()));
        }
        return properties;
    }

    public Map<String, Object> mapObjectProperties(Map<String, Object> properties) {
        return GeneralJsonObjectDao.mapObjectProperties(this.tableInfo, properties);
    }

    public static GeneralJsonObjectDao createJsonObjectDao(Connection conn, TableInfo tableInfo) throws SQLException {
        DBType dbtype = DBType.mapDBType(conn.getMetaData().getURL());
        switch (dbtype) {
            case Oracle: 
            case DM: 
            case KingBase: 
            case GBase: 
            case ShenTong: {
                return new OracleJsonObjectDao(conn, tableInfo);
            }
            case DB2: {
                return new DB2JsonObjectDao(conn, tableInfo);
            }
            case SqlServer: {
                return new SqlSvrJsonObjectDao(conn, tableInfo);
            }
            case MySql: {
                return new MySqlJsonObjectDao(conn, tableInfo);
            }
            case H2: {
                return new H2JsonObjectDao(conn, tableInfo);
            }
            case PostgreSql: {
                return new PostgreSqlJsonObjectDao(conn, tableInfo);
            }
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype.toString());
    }

    public static GeneralJsonObjectDao createJsonObjectDao(DBType dbtype, Connection conn) throws SQLException {
        switch (dbtype) {
            case Oracle: 
            case DM: 
            case KingBase: 
            case GBase: 
            case ShenTong: {
                return new OracleJsonObjectDao(conn);
            }
            case DB2: {
                return new DB2JsonObjectDao(conn);
            }
            case SqlServer: {
                return new SqlSvrJsonObjectDao(conn);
            }
            case MySql: {
                return new MySqlJsonObjectDao(conn);
            }
            case H2: {
                return new H2JsonObjectDao(conn);
            }
            case PostgreSql: {
                return new PostgreSqlJsonObjectDao(conn);
            }
        }
        throw new SQLException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbtype.toString());
    }

    public static GeneralJsonObjectDao createJsonObjectDao(Connection conn) throws SQLException {
        DBType dbtype = DBType.mapDBType(conn.getMetaData().getURL());
        return GeneralJsonObjectDao.createJsonObjectDao(dbtype, conn);
    }

    public GeneralJsonObjectDao(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public GeneralJsonObjectDao(Connection conn) {
        this.conn = conn;
    }

    public GeneralJsonObjectDao(Connection conn, TableInfo tableInfo) {
        this.conn = conn;
        this.tableInfo = tableInfo;
    }

    public void setConnect(Connection conn) {
        this.conn = conn;
    }

    public Connection getConnect() {
        return this.conn;
    }

    public void setTableInfo(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    @Override
    public TableInfo getTableInfo() {
        return this.tableInfo;
    }

    public static String buildFieldSql(TableInfo ti, String alias, int builderType) {
        StringBuilder sBuilder = new StringBuilder();
        List<? extends TableField> columns = ti.getColumns();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : columns) {
            if (builderType != 3 && (builderType != 1 || tableField.isLazyFetch()) && (builderType != 2 || !tableField.isLazyFetch())) continue;
            sBuilder.append(i > 0 ? ", " : " ");
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static String buildPartFieldSql(TableInfo ti, Collection<String> fields, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        String aliasName = alias + ".";
        int i = 0;
        for (String colName : fields) {
            TableField col = ti.findFieldByName(colName);
            if (col == null) continue;
            sBuilder.append(i > 0 ? ", " : " ");
            if (addAlias) {
                sBuilder.append(aliasName);
            }
            sBuilder.append(col.getColumnName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static Pair<String, String[]> buildFieldSqlWithFieldName(TableInfo ti, String alias, boolean excludeLazy) {
        StringBuilder sBuilder = new StringBuilder();
        List<? extends TableField> columns = ti.getColumns();
        String[] fieldNames = new String[columns.size()];
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        int i = 0;
        for (TableField tableField : columns) {
            if (excludeLazy && tableField.isLazyFetch()) continue;
            if (i > 0) {
                sBuilder.append(", ");
            } else {
                sBuilder.append(" ");
            }
            fieldNames[i] = tableField.getPropertyName();
            ++i;
            if (addAlias) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(tableField.getColumnName());
        }
        return new ImmutablePair((Object)sBuilder.toString(), (Object)fieldNames);
    }

    public static Pair<String, String[]> buildPartFieldSqlWithFieldName(TableInfo ti, Collection<String> fields, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        String aliasName = alias + ".";
        String[] fieldNames = new String[fields.size()];
        int i = 0;
        for (String colName : fields) {
            TableField col = ti.findFieldByName(colName);
            if (col == null) continue;
            sBuilder.append(i > 0 ? ", " : " ");
            if (addAlias) {
                sBuilder.append(aliasName);
            }
            sBuilder.append(col.getColumnName());
            fieldNames[i] = col.getPropertyName();
            ++i;
        }
        return new ImmutablePair((Object)sBuilder.toString(), (Object)fieldNames);
    }

    public static boolean checkHasAllPkColumns(TableInfo tableInfo, Map<String, Object> properties) {
        for (String pkc : tableInfo.getPkColumns()) {
            TableField field = tableInfo.findFieldByColumn(pkc);
            if (field == null || properties.get(field.getPropertyName()) != null || properties.get(field.getColumnName()) != null) continue;
            return false;
        }
        return true;
    }

    public boolean checkHasAllPkColumns(Map<String, Object> properties) {
        return GeneralJsonObjectDao.checkHasAllPkColumns(this.tableInfo, properties);
    }

    public static String mapFieldToColumnPiece(String querySql, String fieldName) {
        List<Pair<String, String>> fields = QueryUtils.getSqlFieldNamePieceMap(querySql);
        for (Pair<String, String> field : fields) {
            if (!fieldName.equalsIgnoreCase((String)field.getLeft()) && !fieldName.equals(DatabaseAccess.mapColumnNameToField((String)field.getLeft())) && !fieldName.equalsIgnoreCase((String)field.getRight())) continue;
            return (String)field.getRight();
        }
        return null;
    }

    public static String fetchSelfOrderSql(String querySql, Map<String, Object> filterMap) {
        String selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get(SELF_ORDER_BY));
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            Lexer lexer = new Lexer(selfOrderBy, 2);
            StringBuilder orderBuilder = new StringBuilder();
            String aWord = lexer.getAWord();
            while (StringUtils.isNotBlank((CharSequence)aWord)) {
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "(", ")", TABLE_SORT_ORDER, "by", "desc", "asc", "nulls", "first", "last"})) {
                    orderBuilder.append(aWord);
                } else {
                    String orderField = GeneralJsonObjectDao.mapFieldToColumnPiece(querySql, aWord);
                    if (orderField != null) {
                        orderBuilder.append(orderField);
                    } else {
                        orderBuilder.append(aWord);
                    }
                }
                orderBuilder.append(" ");
                aWord = lexer.getAWord();
            }
            return orderBuilder.toString();
        }
        String sortField = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_FIELD));
        if (StringUtils.isNotBlank((CharSequence)sortField) && (sortField = GeneralJsonObjectDao.mapFieldToColumnPiece(querySql, sortField)) != null) {
            String sOrder = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_ORDER));
            selfOrderBy = "desc".equalsIgnoreCase(sOrder) ? sortField + " desc" : sortField;
        }
        return selfOrderBy;
    }

    public static String fetchSelfOrderSql(TableInfo ti, Map<String, Object> filterMap) {
        TableField field;
        String selfOrderBy = StringBaseOpt.objectToString((Object)filterMap.get(SELF_ORDER_BY));
        if (StringUtils.isNotBlank((CharSequence)selfOrderBy)) {
            Lexer lexer = new Lexer(selfOrderBy, 2);
            StringBuilder orderBuilder = new StringBuilder();
            String aWord = lexer.getAWord();
            while (StringUtils.isNotBlank((CharSequence)aWord)) {
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)aWord, (CharSequence[])new CharSequence[]{",", "(", ")", TABLE_SORT_ORDER, "by", "desc", "asc", "nulls", "first", "last"})) {
                    orderBuilder.append(aWord);
                } else {
                    TableField field2 = ti.findFieldByName(aWord);
                    if (field2 != null) {
                        orderBuilder.append(field2.getColumnName());
                    } else {
                        orderBuilder.append(aWord);
                    }
                }
                orderBuilder.append(" ");
                aWord = lexer.getAWord();
            }
            return orderBuilder.toString();
        }
        String sortField = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_FIELD));
        if (StringUtils.isNotBlank((CharSequence)sortField) && (field = ti.findFieldByName(sortField)) != null) {
            String sOrder = StringBaseOpt.objectToString((Object)filterMap.get(TABLE_SORT_ORDER));
            selfOrderBy = "desc".equalsIgnoreCase(sOrder) ? field.getColumnName() + " desc" : field.getColumnName();
            return selfOrderBy;
        }
        return ti.getOrderBy();
    }

    public static String buildFilterSqlByPk(TableInfo ti, String alias) {
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        List<String> pkColumns = ti.getPkColumns();
        if (pkColumns == null || pkColumns.size() == 0) {
            throw new RuntimeException("\u8868\u6216\u8005\u89c6\u56fe " + ti.getTableName() + " \u7f3a\u5c11\u5bf9\u5e94\u4e3b\u952e\u3002");
        }
        for (String plCol : pkColumns) {
            if (i > 0) {
                sBuilder.append(" and ");
            }
            TableField col = ti.findFieldByColumn(plCol);
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(col.getColumnName()).append(" = :").append(col.getPropertyName());
            ++i;
        }
        return sBuilder.toString();
    }

    public static String buildFilterSql(TableInfo ti, String alias, Collection<String> properties) {
        StringBuilder sBuilder = new StringBuilder();
        int i = 0;
        for (String plCol : properties) {
            int opt = 0;
            TableField col = ti.findFieldByName(plCol);
            if (col == null && plCol.length() > 3 && (col = ti.findFieldByName(plCol.substring(0, plCol.length() - 3))) != null) {
                String lowPlCol = plCol.toLowerCase();
                if (lowPlCol.endsWith("_gt")) {
                    opt = 1;
                } else if (lowPlCol.endsWith("_ge")) {
                    opt = 2;
                } else if (lowPlCol.endsWith("_lt")) {
                    opt = 3;
                } else if (lowPlCol.endsWith("_le")) {
                    opt = 4;
                } else if (lowPlCol.endsWith("_lk")) {
                    opt = 5;
                } else if (lowPlCol.endsWith("_in")) {
                    opt = 6;
                } else if (lowPlCol.endsWith("_ne")) {
                    opt = 7;
                } else if (lowPlCol.charAt(lowPlCol.length() - 3) != '_') {
                    col = null;
                }
            }
            if (col == null) continue;
            if (i > 0) {
                sBuilder.append(" and ");
            }
            if (StringUtils.isNotBlank((CharSequence)alias)) {
                sBuilder.append(alias).append('.');
            }
            sBuilder.append(col.getColumnName());
            switch (opt) {
                case 1: {
                    sBuilder.append(" > :").append(plCol);
                    break;
                }
                case 2: {
                    sBuilder.append(" >= :").append(plCol);
                    break;
                }
                case 3: {
                    sBuilder.append(" < :").append(plCol);
                    break;
                }
                case 4: {
                    sBuilder.append(" <= :").append(plCol);
                    break;
                }
                case 5: {
                    sBuilder.append(" like :").append(plCol);
                    break;
                }
                case 6: {
                    sBuilder.append(" in (:").append(plCol).append(")");
                    break;
                }
                case 7: {
                    sBuilder.append(" <> :").append(plCol);
                    break;
                }
                default: {
                    sBuilder.append(" = :").append(plCol);
                }
            }
            ++i;
        }
        return sBuilder.toString();
    }

    public static Pair<String, String[]> buildGetObjectSqlByPk(TableInfo ti, boolean excludeLazy) {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(ti, null, excludeLazy);
        return new ImmutablePair((Object)("select " + (String)q.getLeft() + " from " + ti.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(ti, null)), q.getRight());
    }

    public Map<String, Object> makePkFieldMap(Object keyValue) throws SQLException {
        if (keyValue instanceof Map) {
            Map objectValues = (Map)keyValue;
            HashMap<String, Object> pkMap = new HashMap<String, Object>(4);
            for (String pkCol : this.tableInfo.getPkColumns()) {
                TableField field = this.tableInfo.findFieldByColumn(pkCol);
                Object pkValue = objectValues.get(field.getPropertyName());
                if (pkValue == null) {
                    pkValue = objectValues.get(field.getColumnName());
                }
                if (pkValue == null) {
                    throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027, \u8868\uff1a" + this.tableInfo.getTableName() + " ,\u53c2\u6570\uff1a" + JSON.toJSONString((Object)keyValue));
                }
                pkMap.put(field.getPropertyName(), pkValue);
            }
            return pkMap;
        }
        if (this.tableInfo.countPkColumn() != 1) {
            throw new SQLException("\u8868" + this.tableInfo.getTableName() + "\u4e0d\u662f\u5355\u4e3b\u952e\u8868\uff0c\u8fd9\u4e2a\u65b9\u6cd5\u4e0d\u9002\u7528\u3002");
        }
        return CollectionsOpt.createHashMap((Object[])new Object[]{this.tableInfo.getPkColumns().get(0), keyValue});
    }

    @Override
    public JSONObject getObjectById(Object keyValue) throws SQLException, IOException {
        Map<String, Object> keyValues = this.makePkFieldMap(keyValue);
        Pair<String, String[]> q = GeneralJsonObjectDao.buildGetObjectSqlByPk(this.tableInfo, false);
        JSONArray ja = DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, (String)q.getLeft(), keyValues, (String[])q.getRight());
        if (ja.size() < 1) {
            return null;
        }
        return (JSONObject)ja.get(0);
    }

    @Override
    public JSONObject getObjectByProperties(Map<String, Object> properties) throws SQLException, IOException {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(this.tableInfo, null, false);
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        JSONArray ja = DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, "select " + (String)q.getLeft() + " from " + this.tableInfo.getTableName() + " where " + filter, properties, (String[])q.getRight());
        if (ja.size() < 1) {
            return null;
        }
        return (JSONObject)ja.get(0);
    }

    public static String buildCountSqlByProperties(TableInfo tableInfo, Map<String, Object> properties) {
        String filter = GeneralJsonObjectDao.buildFilterSql(tableInfo, null, properties.keySet());
        String sql = "select count(*) as row_sum from " + tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        return sql;
    }

    public static Pair<String, String[]> buildQuerySqlByProperties(TableInfo tableInfo, Map<String, Object> properties) {
        String orderBySql;
        Pair<String, String[]> q = GeneralJsonObjectDao.buildFieldSqlWithFieldName(tableInfo, null, true);
        String filter = GeneralJsonObjectDao.buildFilterSql(tableInfo, null, properties.keySet());
        String sql = "select " + (String)q.getLeft() + " from " + tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        if (StringUtils.isNotBlank((CharSequence)(orderBySql = GeneralJsonObjectDao.fetchSelfOrderSql(tableInfo, properties)))) {
            sql = sql + " order by " + orderBySql;
        }
        return new ImmutablePair((Object)sql, q.getRight());
    }

    @Override
    public JSONArray listObjectsByProperties(Map<String, Object> properties) throws SQLException, IOException {
        Pair<String, String[]> q = GeneralJsonObjectDao.buildQuerySqlByProperties(this.tableInfo, properties);
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, (String)q.getLeft(), properties, (String[])q.getRight());
    }

    @Override
    public Long fetchObjectsCount(Map<String, Object> properties) throws SQLException, IOException {
        String filter = GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        String sql = "select count(*) as rs from " + this.tableInfo.getTableName();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            sql = sql + " where " + filter;
        }
        Object object = DatabaseAccess.getScalarObjectQuery(this.conn, sql, properties);
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    public static String buildInsertSql(TableInfo ti, Collection<String> fields) {
        StringBuilder sbInsert = new StringBuilder("insert into ");
        sbInsert.append(ti.getTableName()).append(" ( ");
        StringBuilder sbValues = new StringBuilder(" ) values ( ");
        int i = 0;
        for (String f : fields) {
            TableField col = ti.findFieldByName(f);
            if (col == null) continue;
            if (i > 0) {
                sbInsert.append(", ");
                sbValues.append(", ");
            }
            sbInsert.append(col.getColumnName());
            sbValues.append(":").append(f);
            ++i;
        }
        return sbInsert.append((CharSequence)sbValues).append(")").toString();
    }

    @Override
    public int saveNewObject(Map<String, Object> object) throws SQLException {
        String sql = GeneralJsonObjectDao.buildInsertSql(this.tableInfo, object.keySet());
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, object);
    }

    public static String buildUpdateSql(TableInfo ti, Collection<String> fields, boolean exceptPk) {
        StringBuilder sbUpdate = new StringBuilder("update ");
        sbUpdate.append(ti.getTableName()).append(" set ");
        int i = 0;
        for (String f : fields) {
            TableField col;
            if (exceptPk && ti.isParmaryKey(f) || (col = ti.findFieldByName(f)) == null) continue;
            if (i > 0) {
                sbUpdate.append(", ");
            }
            sbUpdate.append(col.getColumnName());
            sbUpdate.append(" = :").append(f);
            ++i;
        }
        return sbUpdate.toString();
    }

    @Override
    public int updateObject(Collection<String> fields, Map<String, Object> object) throws SQLException {
        if (!this.checkHasAllPkColumns(object)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = GeneralJsonObjectDao.buildUpdateSql(this.tableInfo, fields, true) + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, object);
    }

    @Override
    public int updateObject(Map<String, Object> object) throws SQLException {
        return this.updateObject(object.keySet(), object);
    }

    @Override
    public int mergeObject(Collection<String> fields, Map<String, Object> object) throws SQLException, IOException {
        if (!this.checkHasAllPkColumns(object)) {
            throw new SQLException("\u7f3a\u5c11\u4e3b\u952e\u5bf9\u5e94\u7684\u5c5e\u6027\u3002");
        }
        String sql = "select count(*) as checkExists from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        Long checkExists = NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.getScalarObjectQuery(this.conn, sql, object));
        if (checkExists == null || checkExists.intValue() == 0) {
            return this.saveNewObject(object);
        }
        if (checkExists.intValue() == 1) {
            return this.updateObject(fields, object);
        }
        throw new SQLException("\u4e3b\u952e\u5c5e\u6027\u6709\u8bef\uff0c\u8fd4\u56de\u591a\u4e2a\u6761\u8bb0\u5f55\u3002");
    }

    @Override
    public int mergeObject(Map<String, Object> object) throws SQLException, IOException {
        return this.mergeObject(object.keySet(), object);
    }

    @Override
    public int updateObjectsByProperties(Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        String sql = GeneralJsonObjectDao.buildUpdateSql(this.tableInfo, fields, true) + " where " + GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(fieldValues);
        paramMap.putAll(properties);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, paramMap);
    }

    @Override
    public int updateObjectsByProperties(Map<String, Object> fieldValues, Map<String, Object> properties) throws SQLException {
        return this.updateObjectsByProperties(fieldValues.keySet(), fieldValues, properties);
    }

    @Override
    public int deleteObjectById(Object keyValue) throws SQLException {
        Map<String, Object> keyValues = this.makePkFieldMap(keyValue);
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSqlByPk(this.tableInfo, null);
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, keyValues);
    }

    @Override
    public int deleteObjectsByProperties(Map<String, Object> properties) throws SQLException {
        String sql = "delete from " + this.tableInfo.getTableName() + " where " + GeneralJsonObjectDao.buildFilterSql(this.tableInfo, null, properties.keySet());
        return DatabaseAccess.doExecuteNamedSql(this.conn, sql, properties);
    }

    @Override
    public int insertObjectsAsTabulation(List<Map<String, Object>> objects) throws SQLException {
        int resN = 0;
        for (Map<String, Object> object : objects) {
            resN += this.saveNewObject(object);
        }
        return resN;
    }

    @Override
    public int deleteObjects(List<Object> objects) throws SQLException {
        int resN = 0;
        for (Object object : objects) {
            resN += this.deleteObjectById(object);
        }
        return resN;
    }

    @Override
    public int deleteObjectsAsTabulation(String propertyName, Object propertyValue) throws SQLException {
        return this.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
    }

    @Override
    public int deleteObjectsAsTabulation(Map<String, Object> properties) throws SQLException {
        return this.deleteObjectsByProperties(properties);
    }

    @Override
    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, List<Map<String, Object>> dbObjects) throws SQLException {
        Triple comRes = CollectionsOpt.compareTwoList(dbObjects, newObjects, (Comparator)new JSONObjectComparator(this.tableInfo));
        int resN = 0;
        if (comRes.getLeft() != null) {
            for (Object obj : (List)comRes.getLeft()) {
                resN += this.saveNewObject((Map<String, Object>)((JSONObject)obj));
            }
        }
        if (comRes.getRight() != null) {
            for (Object obj : (List)comRes.getRight()) {
                resN += this.deleteObjectById((JSONObject)obj);
            }
        }
        if (comRes.getMiddle() != null) {
            for (Pair pobj : (List)comRes.getMiddle()) {
                resN += this.updateObject((Map)pobj.getRight());
            }
        }
        return resN;
    }

    @Override
    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, String propertyName, Object propertyValue) throws SQLException, IOException {
        JSONArray dbObjects = this.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{propertyName, propertyValue}));
        return this.replaceObjectsAsTabulation(newObjects, (List<Map<String, Object>>)dbObjects);
    }

    @Override
    public int replaceObjectsAsTabulation(List<Map<String, Object>> newObjects, Map<String, Object> properties) throws SQLException, IOException {
        JSONArray dbObjects = this.listObjectsByProperties(properties);
        return this.replaceObjectsAsTabulation(newObjects, (List<Map<String, Object>>)dbObjects);
    }

    public Long getSimulateSequenceNextValue(String sequenceName) throws SQLException, IOException {
        Object object = DatabaseAccess.getScalarObjectQuery(this.conn, "SELECT count(*) hasValue from simulate_sequence  where seqname = ?", new Object[]{sequenceName});
        Long l = NumberBaseOpt.castObjectToLong((Object)object);
        if (l == 0L) {
            DatabaseAccess.doExecuteSql(this.conn, "insert into simulate_sequence(seqname,currvalue,increment) values(?,?,1)", new Object[]{sequenceName, 1});
            return 1L;
        }
        DatabaseAccess.doExecuteSql(this.conn, "update simulate_sequence set currvalue = currvalue + increment where seqname= ?", new Object[]{sequenceName});
        object = DatabaseAccess.getScalarObjectQuery(this.conn, "SELECT currvalue from simulate_sequence  where seqname = ?", new Object[]{sequenceName});
        return NumberBaseOpt.castObjectToLong((Object)object);
    }

    @Override
    public List<Object[]> findObjectsBySql(String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsBySql(this.conn, sSql, values);
    }

    @Override
    public List<Object[]> findObjectsByNamedSql(String sSql, Map<String, Object> values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsByNamedSql(this.conn, sSql, values);
    }

    @Override
    public JSONArray findObjectsAsJSON(String sSql, Object[] values, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(this.conn, sSql, values, fieldnames);
    }

    @Override
    public JSONArray findObjectsByNamedSqlAsJSON(String sSql, Map<String, Object> values, String[] fieldnames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsByNamedSqlAsJSON(this.conn, sSql, values, fieldnames);
    }

    @Override
    public boolean doExecuteSql(String sSql) throws SQLException {
        return DatabaseAccess.doExecuteSql(this.conn, sSql);
    }

    @Override
    public int doExecuteSql(String sSql, Object[] values) throws SQLException {
        return DatabaseAccess.doExecuteSql(this.conn, sSql, values);
    }

    @Override
    public int doExecuteNamedSql(String sSql, Map<String, Object> values) throws SQLException {
        return DatabaseAccess.doExecuteNamedSql(this.conn, sSql, values);
    }

    public class JSONObjectComparator
    implements Comparator<Map<String, Object>> {
        private TableInfo tableInfo;

        public JSONObjectComparator(TableInfo tableInfo) {
            this.tableInfo = tableInfo;
        }

        @Override
        public int compare(Map<String, Object> o1, Map<String, Object> o2) {
            for (String pkc : this.tableInfo.getPkColumns()) {
                String s2;
                TableField field = this.tableInfo.findFieldByColumn(pkc);
                Object f1 = o1.get(field.getPropertyName());
                Object f2 = o2.get(field.getPropertyName());
                if (f1 == null) {
                    if (f2 == null) continue;
                    return -1;
                }
                if (f2 == null) {
                    return 1;
                }
                if (ReflectionOpt.isNumberType(f1.getClass()) && ReflectionOpt.isNumberType(f2.getClass())) {
                    double db2;
                    double db1 = ((Number)f1).doubleValue();
                    if (db1 > (db2 = ((Number)f2).doubleValue())) {
                        return 1;
                    }
                    if (!(db1 < db2)) continue;
                    return -1;
                }
                String s1 = StringBaseOpt.objectToString((Object)f1);
                int nc = s1.compareTo(s2 = StringBaseOpt.objectToString((Object)f2));
                if (nc == 0) continue;
                return nc;
            }
            return 0;
        }
    }
}

