/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.database.utils.FieldType;
import com.centit.support.xml.IgnoreDTDEntityResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class HibernateMapInfo {
    private String className;
    private String tableName;
    private String tableLabelName;
    private String tableComment;
    private List<SimpleTableField> keyProperties;
    private List<SimpleTableField> properties;
    private boolean isMainTable = true;
    private boolean complexId = false;
    private String idType;
    private String idName;
    private List<HibernateMapInfo> one2manys;
    private List<SimpleTableReference> references;
    protected static final Logger logger = LoggerFactory.getLogger(ReflectionOpt.class);

    public boolean isReferenceColumn(int refPos, String sCol) {
        if (this.references == null || this.references.size() == 0) {
            return false;
        }
        int n = this.references.size();
        if (refPos < 0 || n <= 0 || refPos >= n) {
            return false;
        }
        return this.references.get(refPos).containColumn(sCol);
    }

    public boolean isComplexId() {
        return this.complexId;
    }

    public void setComplexId(boolean hasID) {
        this.complexId = hasID;
    }

    public String getIdType() {
        return this.idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdName() {
        return this.idName;
    }

    public void setIdName(String idName) {
        this.idName = idName;
    }

    public boolean isMainTable() {
        return this.isMainTable;
    }

    public void setClassName(String sClassName) {
        this.className = sClassName;
    }

    public void setTableName(String sTableName) {
        this.tableName = sTableName;
    }

    public String getTableLabelName() {
        return this.tableLabelName;
    }

    public void setTableLabelName(String sTableDesc) {
        this.tableLabelName = sTableDesc;
    }

    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String sTableComment) {
        this.tableComment = sTableComment;
    }

    public void setKeyProperties(List<SimpleTableField> keyProperties) {
        this.keyProperties = keyProperties;
    }

    public void setProperties(List<SimpleTableField> properties) {
        this.properties = properties;
    }

    public void setOne2manys(List<HibernateMapInfo> one2manys) {
        this.one2manys = one2manys;
    }

    public void setReferences(List<SimpleTableReference> references) {
        this.references = references;
    }

    public void setMainTable(boolean isMT) {
        this.isMainTable = isMT;
    }

    public static String trimToSimpleClassName(String className) {
        String sClassSimpleName = className;
        int p = className.lastIndexOf(46);
        if (p > 0) {
            sClassSimpleName = className.substring(p + 1);
        }
        return sClassSimpleName;
    }

    public String getClassSimpleName() {
        return HibernateMapInfo.trimToSimpleClassName(this.className);
    }

    private SimpleTableField loadField(Element fieldNode) {
        Element columnNode;
        SimpleTableField field = new SimpleTableField();
        field.setPropertyName(fieldNode.attribute("name").getValue());
        String sType = "";
        Attribute atType = fieldNode.attribute("type");
        if (atType != null) {
            sType = atType.getValue();
        } else {
            atType = fieldNode.attribute("class");
            if (atType != null) {
                sType = atType.getValue();
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sType)) {
            try {
                field.setFieldType(FieldType.mapToFieldType(Class.forName(sType)));
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
            }
        }
        if ((columnNode = fieldNode.element("column")) != null) {
            field.setColumnName(columnNode.attribute("name").getValue());
            Attribute attr = columnNode.attribute("length");
            if (attr != null) {
                field.setMaxLength(Integer.valueOf(attr.getValue()));
            }
            if ((attr = columnNode.attribute("not-null")) != null) {
                field.setMandatory(attr.getValue());
            }
            if ((attr = columnNode.attribute("precision")) != null) {
                field.setPrecision(Integer.valueOf(attr.getValue()));
            }
            if ((attr = columnNode.attribute("scale")) != null) {
                field.setScale(Integer.valueOf(attr.getValue()));
            }
        }
        return field;
    }

    public void loadHibernateMetadata(String sPath, String sHbmFile) {
        this.keyProperties = new ArrayList<SimpleTableField>();
        this.properties = new ArrayList<SimpleTableField>();
        this.one2manys = null;
        this.references = null;
        try (FileInputStream is = new FileInputStream(new File(sPath + sHbmFile));){
            List setElements;
            Element idNode;
            SAXReader builder = new SAXReader(false);
            builder.setValidation(false);
            builder.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
            Document doc = builder.read((InputStream)is);
            Element classNode = doc.getRootElement().element("class");
            this.className = classNode.attribute("name").getValue();
            Attribute attr = classNode.attribute("table");
            if (attr != null) {
                this.tableName = attr.getValue();
            }
            if ((idNode = classNode.element("id")) != null) {
                SimpleTableField tf = this.loadField(idNode);
                this.complexId = false;
                this.idType = FieldType.trimType(tf.getJavaType().getName());
                this.idName = tf.getPropertyName();
                this.keyProperties.add(tf);
            } else {
                idNode = classNode.element("composite-id");
                this.complexId = true;
                this.idType = idNode.attributeValue("class");
                this.idName = idNode.attributeValue("name");
                this.idType = FieldType.trimType(this.idType);
                List keyNodes = idNode.elements("key-property");
                for (Element key : keyNodes) {
                    this.keyProperties.add(this.loadField(key));
                }
            }
            List propNodes = classNode.elements("property");
            for (Element prop : propNodes) {
                this.properties.add(this.loadField(prop));
            }
            if (this.isMainTable && (setElements = classNode.elements("set")) != null && setElements.size() > 0) {
                this.one2manys = new ArrayList<HibernateMapInfo>();
                this.references = new ArrayList<SimpleTableReference>();
                for (Element setElement : setElements) {
                    Element one2manyNode = setElement.element("one-to-many");
                    String sSubClassName = one2manyNode.attributeValue("class");
                    int p = sSubClassName.lastIndexOf(46);
                    if (p > 0) {
                        sSubClassName = sSubClassName.substring(p + 1);
                    }
                    HibernateMapInfo one2many = new HibernateMapInfo();
                    one2many.setMainTable(false);
                    one2many.loadHibernateMetadata(sPath, sSubClassName + ".hbm.xml");
                    this.one2manys.add(one2many);
                    SimpleTableReference ref = new SimpleTableReference();
                    ref.setParentTableName(this.tableName);
                    ref.setReferenceCode(setElement.attributeValue("name"));
                    Element keyElt = setElement.element("key");
                    List colElements = keyElt.elements("column");
                    for (Element colElt : colElements) {
                        SimpleTableField field = new SimpleTableField();
                        field.setColumnName(colElt.attributeValue("name"));
                        field.mapToMetadata();
                        ref.addFkColumn(field);
                    }
                    this.references.add(ref);
                }
            }
        }
        catch (DocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<SimpleTableField> getKeyProperties() {
        if (this.keyProperties == null) {
            this.keyProperties = new ArrayList<SimpleTableField>();
        }
        return this.keyProperties;
    }

    public List<SimpleTableField> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<SimpleTableField>();
        }
        return this.properties;
    }

    public SimpleTableField getProperty(int indx) {
        int n = this.getProperties().size();
        if (n < 1 || indx < 0 || indx >= n) {
            return new SimpleTableField();
        }
        return this.properties.get(indx);
    }

    public SimpleTableField getKeyProperty(int indx) {
        int n = this.getKeyProperties().size();
        if (n < 1 || indx < 0 || indx >= n) {
            return new SimpleTableField();
        }
        return this.keyProperties.get(indx);
    }

    public List<HibernateMapInfo> getOne2manys() {
        if (this.one2manys == null) {
            this.one2manys = new ArrayList<HibernateMapInfo>();
        }
        return this.one2manys;
    }

    public List<SimpleTableReference> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<SimpleTableReference>();
        }
        return this.references;
    }
}

