/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.FieldType;
import com.centit.support.file.FileSystemOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTableInfo
implements TableInfo {
    protected static final Logger logger = LoggerFactory.getLogger(SimpleTableInfo.class);
    private List<SimpleTableField> columns = null;
    private String schema;
    private String tableName;
    private String tableType = "T";
    private String tableLabelName;
    private String tableComment;
    private String pkName;
    private String packageName;
    private String orderBy;
    private List<SimpleTableReference> references = null;

    public SimpleTableInfo() {
    }

    public SimpleTableInfo(String tabname) {
        this.setTableName(tabname);
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tabName) {
        this.tableName = tabName;
    }

    @Override
    public String getTableLabelName() {
        return this.tableLabelName;
    }

    public void setTableLabelName(String tabDesc) {
        this.tableLabelName = tabDesc;
    }

    @Override
    public String getTableComment() {
        return this.tableComment;
    }

    public void setTableComment(String tabComment) {
        this.tableComment = tabComment;
    }

    @Override
    public String getPkName() {
        return this.pkName;
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    protected static void writerXMLFile(Document doc, String xmlFile) {
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(new File(xmlFile)));
            output.write(doc);
            output.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public SimpleTableField findField(String colname) {
        for (SimpleTableField col : this.columns) {
            if (!col.getColumnName().equals(colname)) continue;
            return col;
        }
        return null;
    }

    @Override
    public SimpleTableField findFieldByName(String name) {
        for (SimpleTableField col : this.columns) {
            if (!col.getPropertyName().equals(name)) continue;
            return col;
        }
        for (SimpleTableField col : this.columns) {
            if (!col.getColumnName().equalsIgnoreCase(name)) continue;
            return col;
        }
        return null;
    }

    @Override
    public SimpleTableField findFieldByColumn(String name) {
        for (SimpleTableField col : this.columns) {
            if (!col.getColumnName().equalsIgnoreCase(name)) continue;
            return col;
        }
        for (SimpleTableField col : this.columns) {
            if (!col.getPropertyName().equals(name)) continue;
            return col;
        }
        return null;
    }

    private void saveProperty(SimpleTableField field, Element propElt, boolean keyProp) {
        propElt.addAttribute("name", field.getPropertyName());
        propElt.addAttribute("type", field.getJavaType().getName());
        Element colElt = propElt.addElement("column");
        this.saveColumn(field, colElt, keyProp);
    }

    private void saveColumn(SimpleTableField field, Element colElt, boolean keyProp) {
        colElt.addAttribute("name", field.getColumnName().toUpperCase());
        if ("long".equals(field.getFieldType()) || "double".equals(field.getFieldType()) || "integer".equals(field.getFieldType()) || "float".equals(field.getFieldType())) {
            colElt.addAttribute("precision", String.valueOf(field.getPrecision()));
            colElt.addAttribute("scale", String.valueOf(field.getScale()));
        } else if (field.getMaxLength() > 0) {
            colElt.addAttribute("length", String.valueOf(field.getMaxLength()));
        }
        if (!keyProp && field.isMandatory()) {
            colElt.addAttribute("not-null", "true");
        }
    }

    private void setAppPropertiesValue(Properties prop, String key, String value) {
        String sKey = FieldType.mapPropName(this.tableName) + '.' + key;
        if (!prop.containsKey(sKey)) {
            prop.setProperty(sKey, value);
        }
    }

    public void addResource(String filename) {
        FileOutputStream outputFile;
        Iterator<SimpleTableField> fis;
        Properties prop;
        try {
            prop = new Properties();
            if (FileSystemOpt.existFile((String)(filename + "_zh_CN.properties"))) {
                fis = new FileInputStream(filename + "_zh_CN.properties");
                Throwable throwable = null;
                try {
                    prop.load((InputStream)((Object)fis));
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)((Object)fis)).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((FileInputStream)((Object)fis)).close();
                        }
                    }
                }
            }
            this.setAppPropertiesValue(prop, "list.title", this.tableLabelName + "\u5217\u8868");
            this.setAppPropertiesValue(prop, "edit.title", "\u7f16\u8f91" + this.tableLabelName);
            this.setAppPropertiesValue(prop, "view.title", "\u67e5\u770b" + this.tableLabelName);
            for (SimpleTableField simpleTableField : this.columns) {
                this.setAppPropertiesValue(prop, FieldType.mapPropName(simpleTableField.getColumnName()), simpleTableField.getFieldLabelName());
            }
            outputFile = new FileOutputStream(filename + "_zh_CN.properties");
            Throwable throwable = null;
            try {
                prop.store(outputFile, "create by centit B/S framework!");
            }
            catch (Throwable throwable5) {
                Throwable throwable6 = throwable5;
                throw throwable5;
            }
            finally {
                if (outputFile != null) {
                    if (throwable != null) {
                        try {
                            outputFile.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        outputFile.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            prop = new Properties();
            if (FileSystemOpt.existFile((String)(filename + ".properties"))) {
                fis = new FileInputStream(filename + ".properties");
                Throwable throwable = null;
                try {
                    prop.load((InputStream)((Object)fis));
                }
                catch (Throwable throwable8) {
                    Throwable throwable9 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (fis != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)((Object)fis)).close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                        } else {
                            ((FileInputStream)((Object)fis)).close();
                        }
                    }
                }
            }
            this.setAppPropertiesValue(prop, "list.title", FieldType.mapPropName(this.tableName) + " list");
            this.setAppPropertiesValue(prop, "edit.title", "new or edit " + FieldType.mapPropName(this.tableName) + " piece");
            this.setAppPropertiesValue(prop, "view.title", "view " + FieldType.mapPropName(this.tableName) + " piece");
            for (SimpleTableField simpleTableField : this.columns) {
                this.setAppPropertiesValue(prop, FieldType.mapPropName(simpleTableField.getColumnName()), simpleTableField.getPropertyName());
            }
            outputFile = new FileOutputStream(filename + ".properties");
            Throwable throwable = null;
            try {
                prop.store(outputFile, "create by centit B/S framework!");
            }
            catch (Throwable throwable11) {
                Throwable throwable12 = throwable11;
                throw throwable11;
            }
            finally {
                if (outputFile != null) {
                    if (throwable != null) {
                        try {
                            outputFile.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        outputFile.close();
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void saveHibernateMappingFile(String filename) {
        Element idElt;
        Document doc = null;
        if (FileSystemOpt.existFile((String)filename)) {
            System.out.println("\u6587\u4ef6\uff1a" + filename + " \u5df2\u5b58\u5728\uff01");
            return;
        }
        doc = DocumentHelper.createDocument();
        doc.addDocType("hibernate-mapping", "-//Hibernate/Hibernate Mapping DTD 3.0//EN", "http://www.hibernate.org/dtd/hibernate-mapping-3.0.dtd");
        doc.addComment("Mapping file autogenerated by codefan@centit.com");
        Element root = doc.addElement("hibernate-mapping");
        Element classElt = root.addElement("class");
        classElt.addAttribute("name", this.packageName + '.' + this.getClassName());
        classElt.addAttribute("table", this.tableName.toUpperCase());
        classElt.addAttribute("schema", this.schema);
        List<String> pkColumns = this.getPkColumns();
        if (pkColumns.size() > 1) {
            idElt = classElt.addElement("composite-id");
            idElt.addAttribute("name", "cid");
            idElt.addAttribute("class", this.packageName + '.' + this.getClassName() + "Id");
            for (String pkcol : pkColumns) {
                SimpleTableField field = this.findField(pkcol);
                if (field == null) continue;
                Element keyElt = idElt.addElement("key-property");
                this.saveProperty(field, keyElt, true);
            }
        } else if (pkColumns.size() == 1) {
            idElt = classElt.addElement("id");
            SimpleTableField field = this.findField(pkColumns.get(0));
            this.saveProperty(field, idElt, true);
            Element genElt = idElt.addElement("generator");
            genElt.addAttribute("class", "assigned");
        }
        if (this.columns != null) {
            for (SimpleTableField col : this.columns) {
                if (this.isParmaryKey(col.getColumnName())) continue;
                Element propElt = classElt.addElement("property");
                this.saveProperty(col, propElt, false);
            }
        }
        if (this.references != null) {
            for (SimpleTableReference ref : this.references) {
                Element setElt = classElt.addElement("set");
                setElt.addAttribute("name", FieldType.mapPropName(ref.getTableName()) + 's');
                setElt.addAttribute("cascade", "all-delete-orphan");
                setElt.addAttribute("inverse", "true");
                Element keyElt = setElt.addElement("key");
                for (SimpleTableField col : ref.getFkColumns()) {
                    Element colElt = keyElt.addElement("column");
                    this.saveColumn(col, colElt, false);
                }
                Element maptypeElt = setElt.addElement("one-to-many");
                maptypeElt.addAttribute("class", this.packageName + '.' + ref.getClassName());
            }
        }
        SimpleTableInfo.writerXMLFile(doc, filename);
    }

    public List<SimpleTableField> getColumns() {
        if (this.columns == null) {
            this.columns = new ArrayList<SimpleTableField>(20);
        }
        return this.columns;
    }

    public void addColumn(SimpleTableField column) {
        if (this.columns == null) {
            this.columns = new ArrayList<SimpleTableField>(20);
        }
        this.columns.add(column);
    }

    public void setColumns(List<SimpleTableField> columns) {
        this.columns = columns;
    }

    public String getClassName() {
        String sClassName = FieldType.mapPropName(this.tableName);
        return sClassName.substring(0, 1).toUpperCase() + sClassName.substring(1);
    }

    public List<SimpleTableReference> getReferences() {
        if (this.references == null) {
            this.references = new ArrayList<SimpleTableReference>(4);
        }
        return this.references;
    }

    public boolean hasReferences() {
        return this.references != null && this.references.size() > 0;
    }

    public void addReference(SimpleTableReference reference) {
        if (this.references == null) {
            this.references = new ArrayList<SimpleTableReference>(4);
        }
        this.references.add(reference);
    }

    public SimpleTableReference findReference(String reference) {
        if (this.references == null) {
            return null;
        }
        for (SimpleTableReference ref : this.references) {
            if (!ref.getReferenceName().equals(reference)) continue;
            return ref;
        }
        return null;
    }

    public void setReferences(List<SimpleTableReference> references) {
        this.references = references;
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setColumnAsPrimaryKey(String colname) {
        SimpleTableField field = this.findFieldByName(colname);
        if (field != null) {
            field.setPrimaryKey(true);
        }
    }
}

