/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.common.JavaBeanField;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.TableReference;
import com.centit.support.database.utils.FieldType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SimpleTableReference
implements TableReference {
    private String parentTableName;
    private String tableName;
    private String referenceName;
    private String referenceCode;
    private Class<?> referenceType;
    private Class<?> targetEntityType;
    private List<SimpleTableField> fkColumns;
    private Map<String, String> referenceColumns;
    private int nObjectId;
    private JavaBeanField beanField;

    public int getObjectId() {
        return this.nObjectId;
    }

    public void setObjectId(int objectId) {
        this.nObjectId = objectId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    @Override
    public String getReferenceCode() {
        return this.referenceCode;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public List<SimpleTableField> getFkColumns() {
        if (this.fkColumns == null) {
            this.fkColumns = new ArrayList<SimpleTableField>();
        }
        return this.fkColumns;
    }

    public void setFkColumns(List<SimpleTableField> fkcolumns) {
        this.fkColumns = fkcolumns;
    }

    public void addFkColumn(SimpleTableField fkcolumn) {
        if (this.fkColumns == null) {
            this.fkColumns = new ArrayList<SimpleTableField>();
        }
        this.fkColumns.add(fkcolumn);
    }

    @Override
    public boolean containColumn(String sCol) {
        if (sCol == null || this.fkColumns == null || this.fkColumns.size() == 0) {
            return false;
        }
        for (SimpleTableField tf : this.fkColumns) {
            if (!sCol.equalsIgnoreCase(tf.getColumnName())) continue;
            return true;
        }
        return false;
    }

    public String getClassName() {
        if (this.tableName == null) {
            return null;
        }
        String sClassName = FieldType.mapPropName(this.tableName);
        return sClassName.substring(0, 1).toUpperCase() + sClassName.substring(1);
    }

    @Override
    public Map<String, String> getReferenceColumns() {
        if (this.referenceColumns == null) {
            this.referenceColumns = new HashMap<String, String>(6);
        }
        return this.referenceColumns;
    }

    @Override
    public String getParentTableName() {
        return this.parentTableName;
    }

    public void setParentTableName(String parentTableName) {
        this.parentTableName = parentTableName;
    }

    public void setReferenceColumns(Map<String, String> referenceColumns) {
        this.referenceColumns = referenceColumns;
    }

    public void addReferenceColumn(String column, String referencedColumn) {
        if (this.referenceColumns == null) {
            this.referenceColumns = new HashMap<String, String>(6);
        }
        this.referenceColumns.put(column, StringUtils.isBlank((CharSequence)referencedColumn) ? column : referencedColumn);
    }

    public Class<?> getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(Class<?> referenceType) {
        this.referenceType = referenceType;
    }

    public Class<?> getTargetEntityType() {
        return this.targetEntityType;
    }

    public void setTargetEntityType(Class<?> targetEntityType) {
        this.targetEntityType = targetEntityType;
    }

    public void setObjectField(Field objectField) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setObjectField(objectField);
    }

    public void setObjectSetFieldValueFunc(Method objectSetFieldValueFunc) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setSetFieldValueFunc(objectSetFieldValueFunc);
    }

    public void setObjectGetFieldValueFunc(Method objectGetFieldValueFunc) {
        if (this.beanField == null) {
            this.beanField = new JavaBeanField();
        }
        this.beanField.setGetFieldValueFunc(objectGetFieldValueFunc);
    }

    public void setObjectFieldValue(Object obj, Object fieldValue) {
        this.beanField.setObjectFieldValue(obj, fieldValue);
    }

    public Object getObjectFieldValue(Object obj) {
        return this.beanField.getObjectFieldValue(obj);
    }
}

