/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.orm;

import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.compiler.Lexer;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableReference;
import com.centit.support.database.orm.TableMapInfo;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.database.utils.FieldType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JpaMetadata {
    private static final Logger logger = LoggerFactory.getLogger(JpaMetadata.class);
    private static final ConcurrentHashMap<String, TableMapInfo> ORM_JPA_METADATA_CLASSPATH = new ConcurrentHashMap(100);
    private static final ConcurrentHashMap<String, TableMapInfo> ORM_JPA_METADATA_CLASSNAME = new ConcurrentHashMap(100);
    private static final ConcurrentHashMap<String, TableMapInfo> ORM_JPA_METADATA_TABLENAME = new ConcurrentHashMap(100);

    private JpaMetadata() {
        throw new IllegalAccessError("Utility class");
    }

    public static TableMapInfo fetchTableMapInfo(Class<?> type) {
        String className = type.getName();
        TableMapInfo mapInfo = ORM_JPA_METADATA_CLASSPATH.get(className);
        if (mapInfo == null && (mapInfo = JpaMetadata.obtainMapInfoFromClass(type)) != null) {
            ORM_JPA_METADATA_CLASSPATH.put(className, mapInfo);
            ORM_JPA_METADATA_TABLENAME.put(mapInfo.getTableName(), mapInfo);
            ORM_JPA_METADATA_CLASSNAME.put(className.substring(className.lastIndexOf(".") + 1), mapInfo);
        }
        return mapInfo;
    }

    public static String translatePropertyNameToColumnName(Class<?> type, String propertyName) {
        TableMapInfo mapInfo = JpaMetadata.fetchTableMapInfo(type);
        if (mapInfo == null) {
            return propertyName;
        }
        SimpleTableField field = mapInfo.findFieldByName(propertyName);
        return field == null ? propertyName : field.getColumnName();
    }

    public static String translatePropertyNameToColumnName(String propertyName, String tableAlias) {
        int n = propertyName.indexOf(46);
        if (n < 0) {
            return propertyName;
        }
        String tableName = propertyName.substring(0, n);
        String fieldName = propertyName.substring(n + 1);
        TableMapInfo mapInfo = ORM_JPA_METADATA_CLASSNAME.get(tableName);
        if (mapInfo == null) {
            mapInfo = ORM_JPA_METADATA_TABLENAME.get(tableName);
        }
        if (mapInfo == null) {
            return propertyName;
        }
        tableName = mapInfo.getTableName();
        SimpleTableField field = mapInfo.findFieldByName(propertyName);
        if (field != null) {
            fieldName = field.getColumnName();
        }
        if (StringUtils.isNotBlank((CharSequence)tableAlias)) {
            return tableAlias + "." + fieldName;
        }
        return tableName + "." + fieldName;
    }

    public static String translatePropertyNameToColumnName(String propertyName) {
        return JpaMetadata.translatePropertyNameToColumnName(propertyName, null);
    }

    private static SimpleTableField obtainColumnFromField(Class<?> objType, Field field) {
        SimpleTableField column = new SimpleTableField();
        Column colInfo = field.getAnnotation(Column.class);
        column.setColumnName(colInfo.name());
        column.setFieldType(FieldType.mapToFieldType(field.getType()));
        column.setPropertyName(field.getName());
        column.setMaxLength(colInfo.length());
        column.setScale(colInfo.scale());
        column.setPrecision(colInfo.precision());
        column.setObjectField(field);
        column.setObjectGetFieldValueFunc(ReflectionOpt.getGetterMethod(objType, field.getType(), (String)field.getName()));
        column.setObjectSetFieldValueFunc(ReflectionOpt.getSetterMethod(objType, field.getType(), (String)field.getName()));
        return column;
    }

    public static TableMapInfo obtainMapInfoFromClass(Class<?> objType) {
        Field[] objFields;
        if (!objType.isAnnotationPresent(Table.class)) {
            return null;
        }
        Table tableInfo = objType.getAnnotation(Table.class);
        TableMapInfo mapInfo = new TableMapInfo();
        mapInfo.setTableName(tableInfo.name());
        mapInfo.setSchema(tableInfo.schema());
        for (Field field : objFields = objType.getDeclaredFields()) {
            Type t;
            ManyToMany manyToMany;
            if (field.isAnnotationPresent(Column.class)) {
                SimpleTableField column = JpaMetadata.obtainColumnFromField(objType, field);
                boolean isPK = field.isAnnotationPresent(Id.class);
                column.setPrimaryKey(isPK);
                boolean isLazy = false;
                if (!isPK && field.isAnnotationPresent(Basic.class)) {
                    Basic colBasic = field.getAnnotation(Basic.class);
                    isLazy = colBasic.fetch() == FetchType.LAZY;
                }
                column.setLazyFetch(isLazy);
                mapInfo.addColumn(column);
                if (field.isAnnotationPresent(ValueGenerator.class)) {
                    ValueGenerator valueGenerator = field.getAnnotation(ValueGenerator.class);
                    mapInfo.addValueGenerator(column.getPropertyName(), valueGenerator);
                }
                if (!field.isAnnotationPresent(OrderBy.class)) continue;
                OrderBy orderBy = field.getAnnotation(OrderBy.class);
                mapInfo.appendOrderBy(column, orderBy.value());
                continue;
            }
            if (field.isAnnotationPresent(EmbeddedId.class)) {
                EmbeddedId embeddedId = field.getAnnotation(EmbeddedId.class);
                mapInfo.setPkName(field.getName());
                for (Field field2 : field.getType().getDeclaredFields()) {
                    if (!field2.isAnnotationPresent(Column.class)) continue;
                    SimpleTableField column = JpaMetadata.obtainColumnFromField(objType, field2);
                    column.setPrimaryKey(true);
                    mapInfo.addColumn(column);
                    if (field2.isAnnotationPresent(ValueGenerator.class)) {
                        ValueGenerator valueGenerator = field2.getAnnotation(ValueGenerator.class);
                        mapInfo.addValueGenerator(column.getPropertyName(), valueGenerator);
                    }
                    if (!field2.isAnnotationPresent(OrderBy.class)) continue;
                    OrderBy orderBy = field2.getAnnotation(OrderBy.class);
                    mapInfo.appendOrderBy(column, orderBy.value());
                }
                continue;
            }
            Class targetClass = null;
            if (field.isAnnotationPresent(OneToOne.class)) {
                OneToOne oneToOne = field.getAnnotation(OneToOne.class);
                targetClass = oneToOne.targetEntity();
                if (targetClass.equals(Void.TYPE)) {
                    targetClass = field.getType();
                }
            } else if (field.isAnnotationPresent(ManyToOne.class)) {
                ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
                targetClass = manyToOne.targetEntity();
                if (targetClass.equals(Void.TYPE)) {
                    targetClass = field.getType();
                }
            } else if (field.isAnnotationPresent(OneToMany.class)) {
                Type t2;
                OneToMany oneToMany = field.getAnnotation(OneToMany.class);
                targetClass = oneToMany.targetEntity();
                if (targetClass.equals(Void.TYPE) && (t2 = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                    targetClass = (Class)t2;
                }
            } else if (field.isAnnotationPresent(ManyToMany.class) && (targetClass = (manyToMany = field.getAnnotation(ManyToMany.class)).targetEntity()).equals(Void.TYPE) && (t = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
                targetClass = (Class)t;
            }
            if (targetClass == null || targetClass.equals(Void.TYPE)) continue;
            SimpleTableReference reference = new SimpleTableReference();
            reference.setTargetEntityType(targetClass);
            boolean haveJoinColumns = false;
            if (field.isAnnotationPresent(JoinColumn.class)) {
                JoinColumn joinColumn = field.getAnnotation(JoinColumn.class);
                reference.setReferenceName(field.getName());
                reference.setReferenceType(field.getType());
                reference.addReferenceColumn(joinColumn.name(), joinColumn.referencedColumnName());
                haveJoinColumns = true;
            } else if (field.isAnnotationPresent(JoinColumns.class)) {
                JoinColumns joinColumns = field.getAnnotation(JoinColumns.class);
                reference.setReferenceName(field.getName());
                reference.setReferenceType(field.getType());
                for (JoinColumn joinColumn : joinColumns.value()) {
                    reference.addReferenceColumn(joinColumn.name(), joinColumn.referencedColumnName());
                }
                haveJoinColumns = true;
            }
            if (!haveJoinColumns) continue;
            reference.setObjectField(field);
            reference.setObjectGetFieldValueFunc(ReflectionOpt.getGetterMethod(objType, field.getType(), (String)field.getName()));
            reference.setObjectSetFieldValueFunc(ReflectionOpt.getSetterMethod(objType, field.getType(), (String)field.getName()));
            mapInfo.addReference(reference);
        }
        ORM_JPA_METADATA_CLASSPATH.put(objType.getName(), mapInfo);
        if (mapInfo.getReferences() != null && mapInfo.getReferences().size() > 0) {
            HashSet<SimpleTableReference> errorRef = new HashSet<SimpleTableReference>(mapInfo.getReferences().size());
            block3: for (SimpleTableReference reference : mapInfo.getReferences()) {
                TableMapInfo refTalbeInfo = JpaMetadata.fetchTableMapInfo(reference.getTargetEntityType());
                if (refTalbeInfo == null) {
                    errorRef.add(reference);
                    continue;
                }
                HashSet<String> keySet = new HashSet<String>(reference.getReferenceColumns().keySet());
                for (String keyName : keySet) {
                    SimpleTableField field = mapInfo.findFieldByName(keyName);
                    SimpleTableField simpleTableField = refTalbeInfo.findFieldByName(reference.getReferenceColumns().get(keyName));
                    if (field == null || simpleTableField == null) {
                        errorRef.add(reference);
                        continue block3;
                    }
                    if (!keyName.equals(field.getPropertyName())) {
                        reference.getReferenceColumns().remove(keyName);
                    }
                    reference.addReferenceColumn(field.getPropertyName(), simpleTableField.getPropertyName());
                }
            }
            if (errorRef.size() > 0) {
                mapInfo.getReferences().removeAll(errorRef);
            }
        }
        return mapInfo;
    }

    public static String translateSqlPropertyToColumn(TableMapInfo mapInfo, String sql, String alias) {
        StringBuilder sqlb = new StringBuilder();
        Lexer lex = new Lexer(sql, 2);
        boolean needTranslate = true;
        int prePos = 0;
        int preWordPos = 0;
        String aWord = lex.getAWord();
        boolean addAlias = StringUtils.isNotBlank((CharSequence)alias);
        if ("[".equals(aWord)) {
            aWord = lex.getAWord();
            while (aWord != null && !"".equals(aWord) && !"|".equals(aWord)) {
                if ("(".equals(aWord)) {
                    lex.seekToRightBracket();
                }
                aWord = lex.getAWord();
            }
        }
        while (aWord != null && !"".equals(aWord)) {
            SimpleTableField col;
            if ("select".equalsIgnoreCase(aWord) || "from".equalsIgnoreCase(aWord)) {
                needTranslate = false;
            } else if ("where".equalsIgnoreCase(aWord)) {
                needTranslate = true;
            }
            if (!needTranslate) {
                preWordPos = lex.getCurrPos();
                aWord = lex.getAWord();
                continue;
            }
            if (":".equals(aWord)) {
                lex.getAWord();
                preWordPos = lex.getCurrPos();
                aWord = lex.getAWord();
            }
            if (Lexer.isLabel((CharSequence)aWord) && (col = mapInfo.findFieldByName(aWord)) != null) {
                if (preWordPos > prePos) {
                    sqlb.append(sql.substring(prePos, preWordPos));
                }
                sqlb.append(addAlias ? " " + alias + "." : " ").append(col.getColumnName());
                prePos = lex.getCurrPos();
            }
            preWordPos = lex.getCurrPos();
            aWord = lex.getAWord();
        }
        sqlb.append(sql.substring(prePos));
        return sqlb.toString();
    }
}

