/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.alibaba.fastjson.JSON;
import com.centit.support.database.utils.DBType;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class FieldType {
    public static final String STRING = "string";
    public static final String INTEGER = "integer";
    public static final String FLOAT = "float";
    public static final String MONEY = "money";
    public static final String DOUBLE = "double";
    public static final String LONG = "long";
    public static final String BOOLEAN = "boolean";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String TIMESTAMP = "timestamp";
    public static final String TEXT = "text";
    public static final String FILE_ID = "fileId";
    public static final String BYTE_ARRAY = "bytes";
    public static final String JSON_OBJECT = "object";

    public static String trimType(String st) {
        int p = st.lastIndexOf(46);
        if (p > 0) {
            return st.substring(p + 1);
        }
        return st;
    }

    public static String mapToHumpName(String columnName, boolean firstUpCase) {
        String sTempName = columnName.toLowerCase();
        int nl = columnName.length();
        StringBuilder sClassName = new StringBuilder();
        boolean upCase = firstUpCase;
        for (int i = 0; i < nl; ++i) {
            if (sTempName.charAt(i) == '_') {
                if (sClassName.length() == 1) {
                    sClassName.delete(0, 1);
                    upCase = firstUpCase;
                    continue;
                }
                upCase = true;
                continue;
            }
            if (upCase) {
                sClassName.append((char)(sTempName.charAt(i) - 32));
                upCase = false;
                continue;
            }
            sClassName.append(sTempName.charAt(i));
        }
        return sClassName.toString();
    }

    public static String mapClassName(String columnName) {
        return FieldType.mapToHumpName(columnName, true);
    }

    public static String mapPropName(String columnName) {
        return FieldType.mapToHumpName(columnName, false);
    }

    public static String mapToOracleColumnType(String ft) {
        switch (ft) {
            case "string": {
                return "varchar2";
            }
            case "integer": 
            case "long": {
                return "number";
            }
            case "float": 
            case "double": {
                return "number";
            }
            case "money": {
                return "number(30,4)";
            }
            case "boolean": {
                return "varchar2(1)";
            }
            case "date": 
            case "datetime": {
                return "Date";
            }
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return "clob";
            }
            case "bytes": {
                return "blob";
            }
            case "fileId": {
                return "varchar2(64)";
            }
        }
        return ft;
    }

    public static String mapToGBaseColumnType(String ft) {
        switch (ft) {
            case "string": {
                return "lvarchar";
            }
            case "integer": 
            case "long": {
                return "int";
            }
            case "float": 
            case "double": {
                return "decimal";
            }
            case "money": {
                return "decimal(30,4)";
            }
            case "boolean": {
                return "varchar(1)";
            }
            case "date": {
                return "Date";
            }
            case "datetime": 
            case "timestamp": {
                return "datatime";
            }
            case "text": 
            case "object": {
                return "clob";
            }
            case "bytes": {
                return "blob";
            }
            case "fileId": {
                return "varchar(64)";
            }
        }
        return ft;
    }

    public static String mapToSqlServerColumnType(String ft) {
        switch (ft) {
            case "string": {
                return "varchar";
            }
            case "integer": 
            case "long": {
                return "decimal";
            }
            case "double": 
            case "float": {
                return "decimal";
            }
            case "money": {
                return "decimal(30,4)";
            }
            case "boolean": {
                return "varchar(1)";
            }
            case "date": 
            case "datetime": {
                return DATETIME;
            }
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return TEXT;
            }
            case "bytes": {
                return "VarBinary(MAX)";
            }
            case "fileId": {
                return "varchar(64)";
            }
        }
        return ft;
    }

    public static String mapToDB2ColumnType(String ft) {
        switch (ft) {
            case "string": {
                return "varchar";
            }
            case "integer": 
            case "long": {
                return "INTEGER";
            }
            case "double": 
            case "float": {
                return "DECIMAL";
            }
            case "money": {
                return "DECIMAL(30,4)";
            }
            case "boolean": {
                return "varchar(1)";
            }
            case "date": 
            case "datetime": {
                return "Date";
            }
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return "clob(52428800)";
            }
            case "bytes": {
                return "BLOB";
            }
            case "fileId": {
                return "varchar(64)";
            }
        }
        return ft;
    }

    public static String mapToMySqlColumnType(String ft) {
        switch (ft) {
            case "string": {
                return "varchar";
            }
            case "integer": {
                return "INT";
            }
            case "long": {
                return "BIG INT";
            }
            case "money": {
                return "DECIMAL(30,4)";
            }
            case "float": {
                return "FLOAT";
            }
            case "double": {
                return "DOUBLE";
            }
            case "boolean": {
                return "varchar(1)";
            }
            case "date": {
                return "Date";
            }
            case "datetime": {
                return "DATETIME";
            }
            case "timestamp": {
                return "TimeStamp";
            }
            case "text": 
            case "object": {
                return "LONGTEXT";
            }
            case "fileId": {
                return "varchar(64)";
            }
            case "bytes": {
                return "VARBINARY";
            }
        }
        return ft;
    }

    public static String mapToH2ColumnType(String ft) {
        return FieldType.mapToMySqlColumnType(ft);
    }

    public static String mapToPostgreSqlColumnType(String ft) {
        return FieldType.mapToMySqlColumnType(ft);
    }

    public static String mapToDatabaseType(String ft, DBType dt) {
        if (dt == null) {
            return ft;
        }
        switch (dt) {
            case SqlServer: {
                return FieldType.mapToSqlServerColumnType(ft);
            }
            case Oracle: 
            case DM: 
            case KingBase: 
            case ShenTong: {
                return FieldType.mapToOracleColumnType(ft);
            }
            case DB2: {
                return FieldType.mapToDB2ColumnType(ft);
            }
            case MySql: {
                return FieldType.mapToMySqlColumnType(ft);
            }
            case H2: {
                return FieldType.mapToH2ColumnType(ft);
            }
            case PostgreSql: {
                return FieldType.mapToPostgreSqlColumnType(ft);
            }
            case GBase: {
                return FieldType.mapToGBaseColumnType(ft);
            }
        }
        return FieldType.mapToOracleColumnType(ft);
    }

    public static Map<String, String> getAllTypeMap() {
        HashMap<String, String> fts = new HashMap<String, String>();
        fts.put(STRING, "\u5b57\u7b26\u4e32");
        fts.put(INTEGER, "\u6574\u578b");
        fts.put(FLOAT, "\u6d6e\u70b9\u578b");
        fts.put(MONEY, "\u91d1\u989d");
        fts.put(DOUBLE, "\u53cc\u7cbe\u5ea6\u6d6e\u70b9\u578b");
        fts.put(LONG, "\u957f\u6574\u578b");
        fts.put(BOOLEAN, "\u5e03\u5c14\u578b");
        fts.put(DATE, "\u65e5\u671f\u578b");
        fts.put(DATETIME, "\u65e5\u671f\u65f6\u95f4\u578b");
        fts.put(TIMESTAMP, "\u65f6\u95f4\u6233");
        fts.put(TEXT, "\u5927\u6587\u672c");
        fts.put(FILE_ID, "\u6587\u4ef6ID");
        fts.put(BYTE_ARRAY, "\u5927\u5b57\u6bb5");
        fts.put(JSON_OBJECT, "JSON\u5bf9\u8c61");
        return fts;
    }

    public static Class<?> mapToJavaType(String columnType, int scale) {
        if ("NUMBER".equalsIgnoreCase(columnType) || "DECIMAL".equalsIgnoreCase(columnType)) {
            if (scale > 0) {
                return Double.class;
            }
            return Long.class;
        }
        if ("CHAR".equalsIgnoreCase(columnType) || "VARCHAR".equalsIgnoreCase(columnType) || "VARCHAR2".equalsIgnoreCase(columnType) || STRING.equalsIgnoreCase(columnType) || FILE_ID.equalsIgnoreCase(columnType) || BOOLEAN.equalsIgnoreCase(columnType)) {
            return String.class;
        }
        if ("DATE".equalsIgnoreCase(columnType) || "TIME".equalsIgnoreCase(columnType) || "DATETIME".equalsIgnoreCase(columnType) || "SQLDATE".equalsIgnoreCase(columnType)) {
            return java.sql.Date.class;
        }
        if ("TIMESTAMP".equalsIgnoreCase(columnType) || "SQLTIMESTAMP".equalsIgnoreCase(columnType)) {
            return Timestamp.class;
        }
        if ("CLOB".equalsIgnoreCase(columnType) || "TEXT".equalsIgnoreCase(columnType)) {
            return String.class;
        }
        if ("BLOB".equalsIgnoreCase(columnType) || "VARBINARY".equalsIgnoreCase(columnType) || BYTE_ARRAY.equalsIgnoreCase(columnType)) {
            return byte[].class;
        }
        if (MONEY.equalsIgnoreCase(columnType)) {
            return BigDecimal.class;
        }
        if (FLOAT.equalsIgnoreCase(columnType)) {
            return Float.class;
        }
        if ("Int".equalsIgnoreCase(columnType) || INTEGER.equalsIgnoreCase(columnType)) {
            return Integer.class;
        }
        if (DOUBLE.equalsIgnoreCase(columnType)) {
            return Double.class;
        }
        if ("BIG INT".equalsIgnoreCase(columnType) || LONG.equalsIgnoreCase(columnType)) {
            return Long.class;
        }
        if (JSON_OBJECT.equalsIgnoreCase(columnType)) {
            return JSON.class;
        }
        return String.class;
    }

    public static Class<?> mapToJavaType(String columnType) {
        return FieldType.mapToJavaType(columnType, 0);
    }

    public static Class<?> mapToJavaType(int dbType) {
        switch (dbType) {
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case 6: 
            case 7: {
                return Float.class;
            }
            case 8: {
                return Double.class;
            }
            case 3: {
                return Long.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 91: 
            case 92: {
                return java.sql.Date.class;
            }
            case 93: 
            case 2013: 
            case 2014: {
                return Timestamp.class;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return byte[].class;
            }
        }
        return String.class;
    }

    public static String mapToFieldType(int dbType) {
        switch (dbType) {
            case -6: 
            case -5: 
            case 2: 
            case 4: 
            case 5: {
                return INTEGER;
            }
            case 6: 
            case 7: {
                return FLOAT;
            }
            case 8: {
                return DOUBLE;
            }
            case 3: {
                return LONG;
            }
            case -1: 
            case 1: 
            case 12: {
                return STRING;
            }
            case 91: {
                return DATE;
            }
            case 92: {
                return DATETIME;
            }
            case 93: 
            case 2013: 
            case 2014: {
                return TIMESTAMP;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return BYTE_ARRAY;
            }
            case 2005: {
                return TEXT;
            }
            case 16: {
                return BOOLEAN;
            }
        }
        return STRING;
    }

    public static String mapToFieldType(String columnType, int scale) {
        if ("NUMBER".equalsIgnoreCase(columnType) || "INTEGER".equalsIgnoreCase(columnType) || "DECIMAL".equalsIgnoreCase(columnType)) {
            if (scale > 0) {
                return DOUBLE;
            }
            return LONG;
        }
        if ("CHAR".equalsIgnoreCase(columnType) || "VARCHAR".equalsIgnoreCase(columnType) || "VARCHAR2".equalsIgnoreCase(columnType)) {
            return STRING;
        }
        if ("DATE".equalsIgnoreCase(columnType) || "SQLDATE".equalsIgnoreCase(columnType) || "TIME".equalsIgnoreCase(columnType) || "DATETIME".equalsIgnoreCase(columnType)) {
            return DATETIME;
        }
        if ("TIMESTAMP".equalsIgnoreCase(columnType) || "SQLTIMESTAMP".equalsIgnoreCase(columnType)) {
            return TIMESTAMP;
        }
        if ("CLOB".equalsIgnoreCase(columnType) || "TEXT".equalsIgnoreCase(columnType)) {
            return TEXT;
        }
        if ("BLOB".equalsIgnoreCase(columnType) || "VARBINARY".equalsIgnoreCase(columnType)) {
            return BYTE_ARRAY;
        }
        if ("FLOAT".equalsIgnoreCase(columnType)) {
            return FLOAT;
        }
        if ("DOUBLE".equalsIgnoreCase(columnType)) {
            return DOUBLE;
        }
        if ("BIG INT".equalsIgnoreCase(columnType)) {
            return LONG;
        }
        if ("INT".equalsIgnoreCase(columnType)) {
            return INTEGER;
        }
        return columnType;
    }

    public static String mapToFieldType(String columnType) {
        return FieldType.mapToFieldType(columnType, 0);
    }

    public static String mapToFieldType(Class<?> javaType) {
        if (javaType.equals(BigDecimal.class)) {
            return MONEY;
        }
        if (javaType.equals(Integer.class) || Integer.TYPE == javaType) {
            return INTEGER;
        }
        if (javaType.equals(Float.class) || Float.TYPE == javaType) {
            return FLOAT;
        }
        if (javaType.equals(Double.class) || Double.TYPE == javaType) {
            return DOUBLE;
        }
        if (javaType.equals(Long.class) || Long.TYPE == javaType) {
            return LONG;
        }
        if (String.class.isAssignableFrom(javaType)) {
            return STRING;
        }
        if (Boolean.class.isAssignableFrom(javaType) || Boolean.TYPE == javaType) {
            return BOOLEAN;
        }
        if (Timestamp.class.isAssignableFrom(javaType)) {
            return TIMESTAMP;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return DATE;
        }
        if (byte[].class == javaType) {
            return BYTE_ARRAY;
        }
        return JSON_OBJECT;
    }
}

