/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

public class PageDesc {
    private int totalRows;
    private int pageSize;
    private int pageNo;

    public static PageDesc createNotPaging() {
        return new PageDesc(-1, -1, -1);
    }

    public PageDesc() {
        this.totalRows = 0;
        this.pageSize = 20;
        this.pageNo = 1;
    }

    public PageDesc(int pn, int ps) {
        this.totalRows = 0;
        this.pageSize = ps;
        this.pageNo = pn;
    }

    public PageDesc(int pn, int ps, int tr) {
        this.totalRows = tr;
        this.pageSize = ps;
        this.pageNo = pn;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(Integer totalRows) {
        this.totalRows = totalRows == null ? 0 : totalRows;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRows(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public void setPage(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getRowStart() {
        return (this.pageNo > 1 ? this.pageNo - 1 : 0) * this.pageSize;
    }

    public int getRowEnd() {
        return (this.pageNo > 1 ? this.pageNo : 1) * this.pageSize;
    }

    public void noPaging(int totalRows) {
        this.totalRows = totalRows;
        this.pageSize = totalRows;
        this.pageNo = 1;
    }

    public void copy(PageDesc other) {
        if (other != null) {
            this.totalRows = other.getTotalRows();
            this.pageSize = other.getPageSize();
            this.pageNo = other.getPageNo();
        }
    }
}

