/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.centit.support.database.metadata.DatabaseMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.metadata.SimpleTableReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleMetadata
implements DatabaseMetadata {
    protected static final Logger logger = LoggerFactory.getLogger(OracleMetadata.class);
    private static final String sqlGetTabColumns = "select a.COLUMN_NAME,a.DATA_TYPE, a.DATA_LENGTH,nvl(a.DATA_PRECISION,a.DATA_LENGTH) as DATA_PRECISION,NVL(a.DATA_SCALE,0) as DATA_SCALE,a.NULLABLE from user_tab_columns a where a.TABLE_NAME=?";
    private static final String sqlPKName = "select CONSTRAINT_NAME from user_constraints where TABLE_NAME=? and CONSTRAINT_TYPE='P'";
    private static final String sqlPKColumns = "select a.COLUMN_NAME from USER_CONS_COLUMNS a join user_tab_columns b on (a.table_name=b.table_name and a.COLUMN_NAME=b.COLUMN_NAME) where /*a.OWNER=? and*/ CONSTRAINT_NAME=? order by POSITION";
    private static final String sqlFKNames = "select TABLE_NAME,CONSTRAINT_NAME from user_constraints where /*a.OWNER=? and*/ R_CONSTRAINT_NAME=? and CONSTRAINT_TYPE='R'";
    private static final String sqlFKColumns = "select a.COLUMN_NAME,b.DATA_TYPE,b.DATA_LENGTH,nvl(b.DATA_PRECISION,b.DATA_LENGTH) as DATA_PRECISION,NVL(b.DATA_SCALE,0) as DATA_SCALE,b.NULLABLE from USER_CONS_COLUMNS a join user_tab_columns b on (a.table_name=b.table_name and a.COLUMN_NAME=b.COLUMN_NAME) where /*a.OWNER=? and*/ CONSTRAINT_NAME=? order by POSITION";
    private String sDBSchema;
    private Connection dbc;

    @Override
    public void setDBConfig(Connection dbc) {
        this.dbc = dbc;
    }

    @Override
    public String getDBSchema() {
        return this.sDBSchema;
    }

    @Override
    public void setDBSchema(String schema) {
        this.sDBSchema = schema;
    }

    @Override
    public SimpleTableInfo getTableMetadata(String tabName) {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        PreparedStatement pStmt;
        SimpleTableInfo tab = new SimpleTableInfo(tabName);
        try {
            pStmt = this.dbc.prepareStatement(sqlGetTabColumns);
            throwable2 = null;
            try {
                tab.setSchema(this.dbc.getSchema().toUpperCase());
                pStmt.setString(1, tabName);
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        SimpleTableField field = new SimpleTableField();
                        field.setColumnName(rs2.getString("COLUMN_NAME"));
                        field.setColumnType(rs2.getString("DATA_TYPE"));
                        int l = rs2.getInt("DATA_LENGTH");
                        int p = rs2.getInt("DATA_PRECISION");
                        field.setMaxLength(p > 0 ? p : l);
                        field.setScale(rs2.getInt("DATA_SCALE"));
                        field.setNullEnable(rs2.getString("NULLABLE"));
                        field.mapToMetadata();
                        tab.addColumn(field);
                    }
                }
                catch (Throwable field) {
                    throwable = field;
                    throw field;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable field) {
                                throwable.addSuppressed(field);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs2) {
                            throwable2.addSuppressed(rs2);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        if (tab.getColumns().size() == 0) {
            return null;
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKName);
            throwable2 = null;
            try {
                pStmt.setString(1, tabName);
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    if (rs2.next()) {
                        tab.setPkName(rs2.getString("CONSTRAINT_NAME"));
                    }
                }
                catch (Throwable field) {
                    throwable = field;
                    throw field;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable field) {
                                throwable.addSuppressed(field);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs3) {
                throwable2 = rs3;
                throw rs3;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs3) {
                            throwable2.addSuppressed(rs3);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlPKColumns);
            throwable2 = null;
            try {
                pStmt.setString(1, tab.getPkName());
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        tab.setColumnAsPrimaryKey(rs2.getString("COLUMN_NAME"));
                    }
                }
                catch (Throwable field) {
                    throwable = field;
                    throw field;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable field) {
                                throwable.addSuppressed(field);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs4) {
                throwable2 = rs4;
                throw rs4;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs4) {
                            throwable2.addSuppressed(rs4);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            pStmt = this.dbc.prepareStatement(sqlFKNames);
            throwable2 = null;
            try {
                pStmt.setString(1, tab.getPkName());
                rs2 = pStmt.executeQuery();
                throwable = null;
                try {
                    while (rs2.next()) {
                        SimpleTableReference ref = new SimpleTableReference();
                        ref.setParentTableName(tabName);
                        ref.setTableName(rs2.getString("TABLE_NAME"));
                        ref.setReferenceCode(rs2.getString("CONSTRAINT_NAME"));
                        tab.addReference(ref);
                    }
                }
                catch (Throwable ref) {
                    throwable = ref;
                    throw ref;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable ref) {
                                throwable.addSuppressed(ref);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs5) {
                throwable2 = rs5;
                throw rs5;
            }
            finally {
                if (pStmt != null) {
                    if (throwable2 != null) {
                        try {
                            pStmt.close();
                        }
                        catch (Throwable rs5) {
                            throwable2.addSuppressed(rs5);
                        }
                    } else {
                        pStmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        for (SimpleTableReference ref : tab.getReferences()) {
            try {
                PreparedStatement pStmt2 = this.dbc.prepareStatement(sqlFKColumns);
                throwable = null;
                try {
                    pStmt2.setString(1, ref.getReferenceCode());
                    ResultSet rs6 = pStmt2.executeQuery();
                    Throwable throwable3 = null;
                    try {
                        while (rs6.next()) {
                            String columnName = rs6.getString("COLUMN_NAME");
                            ref.addReferenceColumn(columnName, columnName);
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs6 == null) continue;
                        if (throwable3 != null) {
                            try {
                                rs6.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        rs6.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (pStmt2 == null) continue;
                    if (throwable != null) {
                        try {
                            pStmt2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    pStmt2.close();
                }
            }
            catch (SQLException e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return tab;
    }
}

