/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DBType {
    Unknown,
    SqlServer,
    Oracle,
    DB2,
    Access,
    MySql,
    H2,
    PostgreSql,
    DM,
    KingBase,
    GBase,
    Oscar,
    Sqlite,
    ClickHouse;

    protected static final Logger logger;
    private static HashMap<DBType, String> dbDrivers;

    public String toString() {
        return DBType.getDBTypeName(this);
    }

    public boolean isMadeInChina() {
        return DM.equals((Object)this) || KingBase.equals((Object)this) || GBase.equals((Object)this) || Oscar.equals((Object)this);
    }

    public static DBType valueOf(int ordinal) {
        switch (ordinal) {
            case 1: {
                return SqlServer;
            }
            case 2: {
                return Oracle;
            }
            case 3: {
                return DB2;
            }
            case 4: {
                return Access;
            }
            case 5: {
                return MySql;
            }
            case 6: {
                return H2;
            }
            case 7: {
                return PostgreSql;
            }
            case 8: {
                return DM;
            }
            case 9: {
                return KingBase;
            }
            case 10: {
                return GBase;
            }
            case 11: {
                return Oscar;
            }
            case 12: {
                return Sqlite;
            }
            case 13: {
                return ClickHouse;
            }
        }
        return Unknown;
    }

    public static DBType mapDBType(String connurl) {
        if (StringUtils.isBlank((CharSequence)connurl)) {
            return Unknown;
        }
        if (connurl.startsWith("jdbc:oracle") || "oracle".equalsIgnoreCase(connurl)) {
            return Oracle;
        }
        if (connurl.startsWith("jdbc:db2") || "db2".equalsIgnoreCase(connurl)) {
            return DB2;
        }
        if (connurl.startsWith("jdbc:sqlserver") || "sqlserver".equalsIgnoreCase(connurl)) {
            return SqlServer;
        }
        if (connurl.startsWith("jdbc:h2") || "h2".equalsIgnoreCase(connurl)) {
            return H2;
        }
        if (connurl.startsWith("jdbc:sqlite") || "sqlite".equalsIgnoreCase(connurl)) {
            return Sqlite;
        }
        if (connurl.startsWith("jdbc:mysql") || "mysql".equalsIgnoreCase(connurl)) {
            return MySql;
        }
        if (connurl.startsWith("jdbc:ucanaccess") || "access".equalsIgnoreCase(connurl)) {
            return Access;
        }
        if (connurl.startsWith("jdbc:postgresql") || "postgresql".equalsIgnoreCase(connurl)) {
            return PostgreSql;
        }
        if (connurl.startsWith("jdbc:dm") || "dm".equalsIgnoreCase(connurl)) {
            return DM;
        }
        if (connurl.startsWith("jdbc:kingbase") || "kingbase".equalsIgnoreCase(connurl)) {
            return KingBase;
        }
        if (connurl.startsWith("jdbc:gbasedbt-sqli") || "gbase".equalsIgnoreCase(connurl)) {
            return GBase;
        }
        if (connurl.startsWith("jdbc:oscar") || "oscar".equalsIgnoreCase(connurl)) {
            return Oscar;
        }
        if (connurl.startsWith("jdbc:clickhouse") || "clickhouse".equalsIgnoreCase(connurl)) {
            return ClickHouse;
        }
        return Unknown;
    }

    public static DBType mapDBType(String connurl, DBType defaultType) {
        DBType dbType = DBType.mapDBType(connurl);
        return dbType == Unknown ? defaultType : dbType;
    }

    public static DBType mapDBType(Connection conn) {
        try {
            return DBType.mapDBType(conn.getMetaData().getURL());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Unknown;
        }
    }

    public static DBType mapDialectToDBType(String dialectName) {
        if (dialectName == null) {
            return Unknown;
        }
        if (dialectName.contains("Oracle")) {
            return Oracle;
        }
        if (dialectName.contains("DB2")) {
            return DB2;
        }
        if (dialectName.contains("SQLServer")) {
            return SqlServer;
        }
        if (dialectName.contains("MySQL")) {
            return MySql;
        }
        if (dialectName.contains("Access")) {
            return Access;
        }
        if (dialectName.contains("H2")) {
            return H2;
        }
        if (dialectName.contains("Sqlite")) {
            return Sqlite;
        }
        if (dialectName.contains("PostgreSQL")) {
            return PostgreSql;
        }
        if (dialectName.contains("Dm")) {
            return DM;
        }
        if (dialectName.contains("KingBase")) {
            return KingBase;
        }
        if (dialectName.contains("GBase")) {
            return GBase;
        }
        if (dialectName.contains("Oscar")) {
            return Oscar;
        }
        if (dialectName.contains("ClickHouse")) {
            return ClickHouse;
        }
        return Unknown;
    }

    public static Set<DBType> allValues() {
        HashSet<DBType> dbtypes = new HashSet<DBType>();
        dbtypes.add(Oracle);
        dbtypes.add(DB2);
        dbtypes.add(SqlServer);
        dbtypes.add(MySql);
        dbtypes.add(Access);
        dbtypes.add(H2);
        dbtypes.add(PostgreSql);
        dbtypes.add(DM);
        dbtypes.add(KingBase);
        dbtypes.add(GBase);
        dbtypes.add(Oscar);
        dbtypes.add(Sqlite);
        dbtypes.add(ClickHouse);
        return dbtypes;
    }

    public static String getDbDriver(DBType dt) {
        return dbDrivers.get((Object)dt);
    }

    public static void setDbDriver(DBType dt, String driverClassName) {
        dbDrivers.put(dt, driverClassName);
    }

    public static String getDBTypeName(DBType type) {
        switch (type) {
            case Oracle: {
                return "oracle";
            }
            case DB2: {
                return "db2";
            }
            case SqlServer: {
                return "sqlserver";
            }
            case Access: {
                return "access";
            }
            case MySql: {
                return "mysql";
            }
            case H2: {
                return "h2";
            }
            case Sqlite: {
                return "sqlite";
            }
            case PostgreSql: {
                return "postgresql";
            }
            case DM: {
                return "dm";
            }
            case KingBase: {
                return "kingbase";
            }
            case GBase: {
                return "gbase";
            }
            case Oscar: {
                return "shentong";
            }
            case ClickHouse: {
                return "clickhouse";
            }
        }
        return "unknown";
    }

    public static String getDBValidationQuery(DBType type) {
        switch (type) {
            case Oracle: 
            case DM: 
            case KingBase: 
            case GBase: 
            case Oscar: {
                return "select 1 from dual";
            }
            case DB2: {
                return "select 1 from SYSIBM.SYSDUMMY1";
            }
            case SqlServer: 
            case MySql: 
            case H2: 
            case Sqlite: 
            case ClickHouse: {
                return "select 1";
            }
            case PostgreSql: {
                return "select version()";
            }
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(DBType.class);
        dbDrivers = new HashMap<DBType, String>(){
            {
                this.put(Oracle, "oracle.jdbc.driver.OracleDriver");
                this.put(DB2, "com.ibm.db2.jcc.DB2Driver");
                this.put(SqlServer, "com.microsoft.sqlserver.jdbc.SQLServerDriver");
                this.put(Access, "net.ucanaccess.jdbc.UcanaccessDriver");
                this.put(MySql, "com.mysql.cj.jdbc.Driver");
                this.put(H2, "org.h2.Driver");
                this.put(PostgreSql, "org.postgresql.Driver");
                this.put(DM, "dm.jdbc.driver.DmDriver");
                this.put(KingBase, "com.kingbase8.Driver");
                this.put(GBase, "com.gbasedbt.jdbc.IfxDriver");
                this.put(Oscar, "com.oscar.Driver");
                this.put(ClickHouse, "com.clickhouse.jdbc.ClickHouseDriver");
                this.put(Sqlite, "org.sqlite.JDBC");
            }
        };
    }
}

