/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.database.ddl.DDLOperations;
import com.centit.support.database.ddl.GeneralDDLOperations;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DBType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class DDLUtils {
    public static List<String> makeAlterTableSqlList(TableInfo newTable, TableInfo oldTable, DBType dbType, DDLOperations ddlOpt) {
        if (ddlOpt == null) {
            ddlOpt = GeneralDDLOperations.createDDLOperations(dbType);
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        if (oldTable == null) {
            sqlList.add(ddlOpt.makeCreateTableSql(newTable));
        } else {
            for (TableField tableField : newTable.getColumns()) {
                TableField ocol = oldTable.findFieldByColumn(tableField.getColumnName());
                if (ocol == null) {
                    sqlList.add(ddlOpt.makeAddColumnSql(newTable.getTableName(), tableField));
                    continue;
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)tableField.getFieldType(), (CharSequence[])new CharSequence[]{ocol.getFieldType()})) {
                    boolean exits = !GeneralAlgorithm.equals((Object)tableField.getMaxLength(), (Object)ocol.getMaxLength()) || !GeneralAlgorithm.equals((Object)tableField.getScale(), (Object)ocol.getScale()) || !GeneralAlgorithm.equals((Object)BooleanBaseOpt.castObjectToBoolean((Object)tableField.isMandatory(), (Boolean)false), (Object)ocol.isMandatory()) || !StringUtils.equals((CharSequence)tableField.getFieldLabelName(), (CharSequence)ocol.getFieldLabelName()) && dbType.equals((Object)DBType.MySql);
                    if (!exits) continue;
                    sqlList.add(ddlOpt.makeModifyColumnSql(newTable.getTableName(), ocol, tableField));
                    continue;
                }
                sqlList.addAll(ddlOpt.makeReconfigurationColumnSqls(newTable.getTableName(), ocol.getColumnName(), tableField));
            }
            for (TableField tableField : oldTable.getColumns()) {
                TableField pcol = newTable.findFieldByColumn(tableField.getColumnName());
                if (pcol != null) continue;
                sqlList.add(ddlOpt.makeDropColumnSql(oldTable.getTableName(), tableField.getColumnName()));
            }
        }
        return sqlList;
    }
}

