/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.EnumBaseOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.FieldType;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryAndParams;
import com.centit.support.database.utils.QueryLogUtils;
import com.centit.support.database.utils.QueryUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatabaseAccess {
    protected static final Logger logger = LoggerFactory.getLogger(DatabaseAccess.class);

    private DatabaseAccess() {
        throw new IllegalAccessError("Utility class");
    }

    public static SQLException createAccessExceptionWithData(String sql, SQLException e, Object ... data) {
        StringBuilder sb = new StringBuilder(e.getMessage());
        sb.append("\r\nSQL: ").append(sql);
        if (data != null && data.length > 0) {
            sb.append("\r\nWith data: ");
            if (data.length == 1) {
                sb.append(JSON.toJSONString((Object)data[0]));
            } else {
                sb.append(JSON.toJSONString((Object)data));
            }
        }
        SQLException exception = new SQLException(sb.toString(), e.getSQLState(), e.getErrorCode(), e.getCause());
        exception.setNextException(e.getNextException());
        exception.setStackTrace(e.getStackTrace());
        return exception;
    }

    public static SQLException createAccessException(String sql, SQLException e) {
        return DatabaseAccess.createAccessExceptionWithData(sql, e, new Object[0]);
    }

    private static Object transObjectForSqlParam(Object param) {
        if (param instanceof Timestamp || param instanceof Date) {
            return param;
        }
        if (param instanceof java.util.Date) {
            return DatetimeOpt.convertToSqlTimestamp((java.util.Date)((java.util.Date)param));
        }
        if (param instanceof LocalDate || param instanceof LocalDateTime) {
            return DatetimeOpt.convertToSqlTimestamp((java.util.Date)DatetimeOpt.castObjectToDate((Object)param));
        }
        Class<?> paramClass = param.getClass();
        if (Boolean.class.isAssignableFrom(paramClass)) {
            return BooleanBaseOpt.castObjectToBoolean((Object)param, (Boolean)false) != false ? "T" : "F";
        }
        if (paramClass.isEnum()) {
            return EnumBaseOpt.enumToString((Object)param);
        }
        if (ReflectionOpt.isScalarType(paramClass) || param instanceof byte[]) {
            return param;
        }
        return JSON.toJSONString((Object)param);
    }

    public static Object callFunction(Connection conn, String procName, int sqlType, Object ... paramObjs) throws SQLException {
        Object object;
        block12: {
            int n = paramObjs.length;
            StringBuilder procDesc = new StringBuilder("{?=call ");
            procDesc.append(procName).append("(");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    procDesc.append(",");
                }
                procDesc.append("?");
            }
            procDesc.append(")}");
            String sqlCen = procDesc.toString();
            QueryLogUtils.printSql(logger, sqlCen);
            CallableStatement stmt = conn.prepareCall(sqlCen);
            try {
                stmt.registerOutParameter(1, sqlType);
                for (int i = 0; i < n; ++i) {
                    if (paramObjs[i] == null) {
                        stmt.setNull(i + 2, 0);
                        continue;
                    }
                    stmt.setObject(i + 2, DatabaseAccess.transObjectForSqlParam(paramObjs[i]));
                }
                stmt.execute();
                object = stmt.getObject(1);
                if (stmt == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw DatabaseAccess.createAccessExceptionWithData(sqlCen, e, paramObjs);
                }
            }
            stmt.close();
        }
        return object;
    }

    public static boolean callProcedure(Connection conn, String procName, Object ... paramObjs) throws SQLException {
        boolean bl;
        block10: {
            int n = paramObjs.length;
            StringBuilder procDesc = new StringBuilder("{call ");
            procDesc.append(procName).append("(");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    procDesc.append(",");
                }
                procDesc.append("?");
            }
            procDesc.append(")}");
            String sqlCen = procDesc.toString();
            QueryLogUtils.printSql(logger, sqlCen);
            CallableStatement stmt = conn.prepareCall(sqlCen);
            try {
                DatabaseAccess.setQueryStmtParameters((PreparedStatement)stmt, paramObjs);
                bl = stmt.execute();
                if (stmt == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw DatabaseAccess.createAccessExceptionWithData(sqlCen, e, paramObjs);
                }
            }
            stmt.close();
        }
        return bl;
    }

    public static boolean doExecuteSql(Connection conn, String sSql) throws SQLException {
        boolean bl;
        block8: {
            PreparedStatement stmt = conn.prepareStatement(sSql);
            try {
                QueryLogUtils.printSql(logger, sSql);
                bl = stmt.execute();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw DatabaseAccess.createAccessException(sSql, e);
                }
            }
            stmt.close();
        }
        return bl;
    }

    public static void setQueryStmtParameters(PreparedStatement stmt, Object[] paramObjs) throws SQLException {
        if (paramObjs != null) {
            for (int i = 0; i < paramObjs.length; ++i) {
                if (paramObjs[i] == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                stmt.setObject(i + 1, DatabaseAccess.transObjectForSqlParam(paramObjs[i]));
            }
        }
    }

    public static void setQueryStmtParameters(PreparedStatement stmt, List<Object> paramObjs) throws SQLException {
        if (paramObjs != null) {
            for (int i = 0; i < paramObjs.size(); ++i) {
                if (paramObjs.get(i) == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                stmt.setObject(i + 1, DatabaseAccess.transObjectForSqlParam(paramObjs.get(i)));
            }
        }
    }

    public static void setQueryStmtParameters(PreparedStatement stmt, List<String> paramsName, Map<String, Object> paramObjs) throws SQLException {
        if (paramObjs != null) {
            for (int i = 0; i < paramsName.size(); ++i) {
                Object pobj = paramObjs.get(paramsName.get(i));
                if (pobj == null) {
                    stmt.setNull(i + 1, 0);
                    continue;
                }
                stmt.setObject(i + 1, DatabaseAccess.transObjectForSqlParam(pobj));
            }
        }
    }

    public static int doExecuteSql(Connection conn, String sSql, Object[] values) throws SQLException {
        int n;
        block8: {
            QueryLogUtils.printSql(logger, sSql, values);
            PreparedStatement stmt = conn.prepareStatement(sSql);
            try {
                DatabaseAccess.setQueryStmtParameters(stmt, values);
                n = stmt.executeUpdate();
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw DatabaseAccess.createAccessExceptionWithData(sSql, e, values);
                }
            }
            stmt.close();
        }
        return n;
    }

    public static int doExecuteNamedSql(Connection conn, String sSql, Map<String, Object> values) throws SQLException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.doExecuteSql(conn, qap.getQuery(), qap.getParams());
    }

    private static JSONObject innerFetchResultSetRowToJSONObject(ResultSet rs, int cc, String[] fieldNames) throws SQLException, IOException {
        JSONObject jo = new JSONObject();
        for (int i = 0; i < cc; ++i) {
            Object obj = rs.getObject(i + 1);
            if (obj == null) continue;
            if (obj instanceof Clob) {
                jo.put((Object)fieldNames[i], (Object)DatabaseAccess.fetchClobString((Clob)obj));
                continue;
            }
            if (obj instanceof Blob) {
                jo.put((Object)fieldNames[i], (Object)DatabaseAccess.fetchBlobBytes((Blob)obj));
                continue;
            }
            if (obj instanceof LocalDateTime || obj instanceof LocalDate) {
                jo.put((Object)fieldNames[i], (Object)DatetimeOpt.castObjectToDate((Object)obj));
                continue;
            }
            if (obj.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
                jo.put((Object)fieldNames[i], (Object)rs.getTimestamp(i + 1));
                continue;
            }
            if (obj.getClass().getName().startsWith("com.clickhouse.data.value.Unsigned")) {
                jo.put((Object)fieldNames[i], (Object)rs.getLong(i + 1));
                continue;
            }
            jo.put((Object)fieldNames[i], obj);
        }
        return jo;
    }

    public static JSONObject fetchResultSetRowToJSONObject(ResultSet rs, String[] fieldNames) throws SQLException, IOException {
        if (rs.next()) {
            int cc = rs.getMetaData().getColumnCount();
            String[] fields = new String[cc];
            int asFn = 0;
            if (fieldNames != null && fieldNames.length > 0) {
                asFn = fieldNames.length;
                System.arraycopy(fieldNames, 0, fields, 0, asFn);
            }
            for (int i = asFn; i < cc; ++i) {
                fields[i] = FieldType.mapPropName(rs.getMetaData().getColumnLabel(i + 1));
            }
            return DatabaseAccess.innerFetchResultSetRowToJSONObject(rs, cc, fields);
        }
        return null;
    }

    public static JSONObject fetchResultSetRowToJSONObject(ResultSet rs) throws SQLException, IOException {
        return DatabaseAccess.fetchResultSetRowToJSONObject(rs, null);
    }

    public static JSONArray fetchResultSetToJSONArray(ResultSet rs, String[] fieldNames) throws SQLException, IOException {
        int i;
        JSONArray ja = new JSONArray();
        int cc = rs.getMetaData().getColumnCount();
        String[] fields = new String[cc];
        int asFn = 0;
        if (fieldNames != null) {
            asFn = fieldNames.length;
            for (i = 0; i < asFn; ++i) {
                fields[i] = StringUtils.isBlank((CharSequence)fieldNames[i]) ? FieldType.mapPropName(rs.getMetaData().getColumnLabel(i + 1)) : fieldNames[i];
            }
        }
        for (i = asFn; i < cc; ++i) {
            fields[i] = FieldType.mapPropName(rs.getMetaData().getColumnLabel(i + 1));
        }
        while (rs.next()) {
            ja.add((Object)DatabaseAccess.innerFetchResultSetRowToJSONObject(rs, cc, fields));
        }
        return ja;
    }

    public static String[] mapColumnsNameToFields(List<String> colNames) {
        if (colNames == null || colNames.size() == 0) {
            return null;
        }
        String[] fns = new String[colNames.size()];
        for (int i = 0; i < colNames.size(); ++i) {
            fns[i] = FieldType.mapPropName(colNames.get(i));
        }
        return fns;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values, String[] fieldNames) throws SQLException, IOException {
        QueryLogUtils.printSql(logger, sSql, values);
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            JSONArray jSONArray;
            block19: {
                ResultSet rs;
                block17: {
                    JSONArray jSONArray2;
                    block18: {
                        DatabaseAccess.setQueryStmtParameters(stmt, values);
                        rs = stmt.executeQuery();
                        try {
                            if (rs != null) break block17;
                            jSONArray2 = new JSONArray();
                            if (rs == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return jSONArray2;
                }
                Object[] fns = fieldNames;
                if (ArrayUtils.isEmpty((Object[])fns)) {
                    List<String> fields = QueryUtils.getSqlFiledNames(sSql);
                    fns = DatabaseAccess.mapColumnsNameToFields(fields);
                }
                jSONArray = DatabaseAccess.fetchResultSetToJSONArray(rs, (String[])fns);
                if (rs == null) break block19;
                rs.close();
            }
            return jSONArray;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessExceptionWithData(sSql, e, values);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JSONObject getObjectAsJSON(Connection conn, String sSql, Object[] values, String[] fieldNames) throws SQLException, IOException {
        QueryLogUtils.printSql(logger, sSql, values);
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            JSONObject jSONObject;
            block19: {
                ResultSet rs;
                block17: {
                    JSONObject jSONObject2;
                    block18: {
                        DatabaseAccess.setQueryStmtParameters(stmt, values);
                        rs = stmt.executeQuery();
                        try {
                            if (rs != null) break block17;
                            jSONObject2 = null;
                            if (rs == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return jSONObject2;
                }
                Object[] fns = fieldNames;
                if (ArrayUtils.isEmpty((Object[])fns)) {
                    List<String> fields = QueryUtils.getSqlFiledNames(sSql);
                    fns = DatabaseAccess.mapColumnsNameToFields(fields);
                }
                jSONObject = DatabaseAccess.fetchResultSetRowToJSONObject(rs, (String[])fns);
                if (rs == null) break block19;
                rs.close();
            }
            return jSONObject;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessExceptionWithData(sSql, e, values);
        }
    }

    public static JSONObject getObjectAsJSON(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.getObjectAsJSON(conn, sSql, values, null);
    }

    public static JSONObject getObjectAsJSON(Connection conn, String sSql) throws SQLException, IOException {
        return DatabaseAccess.getObjectAsJSON(conn, sSql, (Object[])null, null);
    }

    public static JSONObject getObjectAsJSON(Connection conn, String sSql, Map<String, Object> values, String[] fieldNames) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.getObjectAsJSON(conn, qap.getQuery(), qap.getParams(), fieldNames);
    }

    public static JSONObject getObjectAsJSON(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.getObjectAsJSON(conn, qap.getQuery(), qap.getParams(), null);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, values, null);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, null, null);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object value) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, new Object[]{value}, null);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object value, String[] fieldNames) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, new Object[]{value}, fieldNames);
    }

    public static JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values, String[] fieldNames) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), fieldNames);
    }

    public static JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), null);
    }

    public static String fetchClobString(Clob clob) throws IOException {
        String string;
        block9: {
            Reader reader = clob.getCharacterStream();
            try {
                int len;
                StringWriter writer = new StringWriter();
                char[] buf = new char[4096];
                while ((len = reader.read(buf)) != -1) {
                    writer.write(buf, 0, len);
                }
                string = writer.toString();
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new IOException("write clob error", e);
                }
            }
            reader.close();
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] fetchBlobBytes(Blob blob) throws IOException {
        try (InputStream is = blob.getBinaryStream();){
            int len;
            if (is == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException("write clob error", e);
        }
    }

    public static String fetchBlobAsBase64(Blob blob) throws IOException {
        byte[] readBytes = DatabaseAccess.fetchBlobBytes(blob);
        if (readBytes == null) {
            return null;
        }
        return new String(Base64.encodeBase64((byte[])readBytes));
    }

    public static Object fetchLobField(Object fieldData, boolean blobAsBase64String) {
        if (fieldData == null) {
            return null;
        }
        try {
            if (fieldData instanceof Clob) {
                return DatabaseAccess.fetchClobString((Clob)fieldData);
            }
            if (fieldData instanceof Blob) {
                if (blobAsBase64String) {
                    return DatabaseAccess.fetchBlobAsBase64((Blob)fieldData);
                }
                return DatabaseAccess.fetchBlobBytes((Blob)fieldData);
            }
            return fieldData;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static List<Object[]> fetchResultSetToObjectsList(ResultSet rs) throws SQLException, IOException {
        ArrayList<Object[]> datas;
        int col = rs.getMetaData().getColumnCount();
        if (rs.next()) {
            datas = new ArrayList<Object[]>();
            datas.add(DatabaseAccess.innerFetchResultSetRowToObjects(rs, col));
        } else {
            return null;
        }
        while (rs.next()) {
            datas.add(DatabaseAccess.innerFetchResultSetRowToObjects(rs, col));
        }
        return datas;
    }

    private static Object[] innerFetchResultSetRowToObjects(ResultSet rs, int col) throws SQLException, IOException {
        Object[] objs = new Object[col];
        for (int i = 1; i <= col; ++i) {
            Object obj = rs.getObject(i);
            if (obj != null) {
                if (obj instanceof Clob) {
                    objs[i - 1] = DatabaseAccess.fetchClobString((Clob)obj);
                    continue;
                }
                if (obj instanceof Blob) {
                    objs[i - 1] = DatabaseAccess.fetchBlobBytes((Blob)obj);
                    continue;
                }
                if (obj instanceof LocalDateTime || obj instanceof LocalDate) {
                    objs[i - 1] = DatetimeOpt.castObjectToDate((Object)obj);
                    continue;
                }
                if (obj.getClass().getName().startsWith("oracle.sql.TIMESTAMP")) {
                    objs[i - 1] = rs.getTimestamp(i);
                    continue;
                }
                if (obj.getClass().getName().startsWith("com.clickhouse.data.value.Unsigned")) {
                    objs[i - 1] = rs.getLong(i);
                    continue;
                }
                objs[i - 1] = obj;
                continue;
            }
            objs[i - 1] = null;
        }
        return objs;
    }

    public static Object[] fetchResultSetRowToObjects(ResultSet rs) throws SQLException, IOException {
        if (rs.next()) {
            int col = rs.getMetaData().getColumnCount();
            return DatabaseAccess.innerFetchResultSetRowToObjects(rs, col);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        QueryLogUtils.printSql(logger, sSql, values);
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            List<Object[]> list;
            block14: {
                DatabaseAccess.setQueryStmtParameters(stmt, values);
                ResultSet rs = stmt.executeQuery();
                try {
                    list = DatabaseAccess.fetchResultSetToObjectsList(rs);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessExceptionWithData(sSql, e, values);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql, List<Object> values) throws SQLException, IOException {
        QueryLogUtils.printSql(logger, sSql, values);
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            List<Object[]> list;
            block14: {
                DatabaseAccess.setQueryStmtParameters(stmt, values);
                ResultSet rs = stmt.executeQuery();
                try {
                    list = DatabaseAccess.fetchResultSetToObjectsList(rs);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessExceptionWithData(sSql, e, values);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql, Object value) throws SQLException, IOException {
        QueryLogUtils.printSql(logger, sSql, value);
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            List<Object[]> list;
            block14: {
                DatabaseAccess.setQueryStmtParameters(stmt, new Object[]{value});
                ResultSet rs = stmt.executeQuery();
                try {
                    list = DatabaseAccess.fetchResultSetToObjectsList(rs);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessExceptionWithData(sSql, e, value);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql) throws SQLException, IOException {
        QueryLogUtils.printSql(logger, sSql);
        try (PreparedStatement stmt = conn.prepareStatement(sSql);){
            List<Object[]> list;
            block14: {
                ResultSet rs = stmt.executeQuery();
                try {
                    list = DatabaseAccess.fetchResultSetToObjectsList(rs);
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw DatabaseAccess.createAccessException(sSql, e);
        }
    }

    public static List<Object[]> findObjectsByNamedSql(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsBySql(conn, qap.getQuery(), qap.getParams());
    }

    public static Object[] getSingleRow(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsByNamedSql(conn, sSql, values);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static Object[] getSingleRow(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, values);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static Object[] getSingleRow(Connection conn, String sSql) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static Object[] getSingleRow(Connection conn, String sSql, Object value) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, value);
        if (objList != null && objList.size() > 0) {
            return objList.get(0);
        }
        return null;
    }

    public static Object fetchScalarObject(List<Object[]> rsDatas) {
        if (rsDatas == null || rsDatas.size() == 0) {
            return null;
        }
        Object[] firstRow = rsDatas.get(0);
        if (firstRow == null || firstRow.length == 0) {
            return null;
        }
        return firstRow[0];
    }

    public static List<Object> fetchSingleColumn(List<Object[]> rsDatas, int columnIndex) {
        if (rsDatas == null || rsDatas.size() == 0) {
            return null;
        }
        ArrayList<Object> columnData = new ArrayList<Object>(rsDatas.size());
        for (Object[] row : rsDatas) {
            columnData.add(row[columnIndex]);
        }
        return columnData;
    }

    public static List<Object> fetchSingleColumn(List<Object[]> rsDatas) {
        return DatabaseAccess.fetchSingleColumn(rsDatas, 0);
    }

    public static List<String> fetchSingleColumnAsString(List<Object[]> rsDatas, int columnIndex) {
        if (rsDatas == null || rsDatas.size() == 0) {
            return null;
        }
        ArrayList<String> columnData = new ArrayList<String>(rsDatas.size());
        for (Object[] row : rsDatas) {
            columnData.add(StringBaseOpt.castObjectToString((Object)row[columnIndex]));
        }
        return columnData;
    }

    public static List<String> fetchSingleColumnAsString(List<Object[]> rsDatas) {
        return DatabaseAccess.fetchSingleColumnAsString(rsDatas, 0);
    }

    public static Object getScalarObjectQuery(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsByNamedSql(conn, sSql, values);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static Object getScalarObjectQuery(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, values);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static Object getScalarObjectQuery(Connection conn, String sSql) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static Object getScalarObjectQuery(Connection conn, String sSql, Object value) throws SQLException, IOException {
        List<Object[]> objList = DatabaseAccess.findObjectsBySql(conn, sSql, value);
        return DatabaseAccess.fetchScalarObject(objList);
    }

    public static Long queryTotalRows(Connection conn, String sSql, Object[] values) throws SQLException, IOException {
        Object scalarObj = DatabaseAccess.getScalarObjectQuery(conn, QueryUtils.buildGetCountSQL(sSql), values);
        return NumberBaseOpt.castObjectToLong((Object)scalarObj);
    }

    public static Long queryTotalRows(Connection conn, String sSql, Map<String, Object> values) throws SQLException, IOException {
        Object scalarObj = DatabaseAccess.getScalarObjectQuery(conn, QueryUtils.buildGetCountSQL(sSql), values);
        return NumberBaseOpt.castObjectToLong((Object)scalarObj);
    }

    private static String makePageQuerySql(Connection conn, String sSql, int pageNo, int pageSize) throws ObjectException {
        int offset = pageNo > 1 && pageSize > 0 ? (pageNo - 1) * pageSize : 0;
        return QueryUtils.buildLimitQuerySQL(sSql, offset, pageSize, false, DBType.mapDBType(conn));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<Object[]> findObjectsBySql(Connection conn, String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        String query = DatabaseAccess.makePageQuerySql(conn, sSql, pageNo, pageSize);
        if (query.equals(sSql)) {
            try (PreparedStatement stmt = conn.prepareStatement(sSql);){
                List<Object[]> list;
                block17: {
                    DatabaseAccess.setQueryStmtParameters(stmt, values);
                    if (pageNo > 0 && pageSize > 0) {
                        stmt.setMaxRows(pageNo * pageSize);
                    }
                    ResultSet rs = stmt.executeQuery();
                    try {
                        if (pageNo > 1 && pageSize > 0) {
                            rs.absolute((pageNo - 1) * pageSize);
                        }
                        list = DatabaseAccess.fetchResultSetToObjectsList(rs);
                        if (rs == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return list;
            }
            catch (SQLException e) {
                throw DatabaseAccess.createAccessExceptionWithData(sSql, e, values);
            }
        }
        return DatabaseAccess.findObjectsBySql(conn, query, values);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values, String[] fieldNames, int pageNo, int pageSize) throws SQLException, IOException {
        String query = DatabaseAccess.makePageQuerySql(conn, sSql, pageNo, pageSize);
        if (query.equals(sSql)) {
            try (PreparedStatement stmt = conn.prepareStatement(sSql);){
                JSONArray jSONArray;
                block23: {
                    Object[] fns;
                    ResultSet rs;
                    block21: {
                        JSONArray jSONArray2;
                        block22: {
                            DatabaseAccess.setQueryStmtParameters(stmt, values);
                            if (pageNo > 0 && pageSize > 0) {
                                stmt.setMaxRows(pageNo * pageSize);
                            }
                            rs = stmt.executeQuery();
                            try {
                                if (rs != null) break block21;
                                jSONArray2 = new JSONArray();
                                if (rs == null) break block22;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return jSONArray2;
                    }
                    if (pageNo > 1 && pageSize > 0) {
                        rs.absolute((pageNo - 1) * pageSize);
                    }
                    if (ArrayUtils.isEmpty((Object[])(fns = fieldNames))) {
                        List<String> fields = QueryUtils.getSqlFiledNames(sSql);
                        fns = DatabaseAccess.mapColumnsNameToFields(fields);
                    }
                    jSONArray = DatabaseAccess.fetchResultSetToJSONArray(rs, (String[])fns);
                    if (rs == null) break block23;
                    rs.close();
                }
                return jSONArray;
            }
            catch (SQLException e) {
                throw DatabaseAccess.createAccessExceptionWithData(sSql, e, values);
            }
        }
        Object[] fns = fieldNames;
        if (ArrayUtils.isEmpty((Object[])fns)) {
            List<String> fields = QueryUtils.getSqlFiledNames(sSql);
            fns = DatabaseAccess.mapColumnsNameToFields(fields);
        }
        return DatabaseAccess.findObjectsAsJSON(conn, query, values, (String[])fns);
    }

    public static JSONArray findObjectsAsJSON(Connection conn, String sSql, Object[] values, int pageNo, int pageSize) throws SQLException, IOException {
        return DatabaseAccess.findObjectsAsJSON(conn, sSql, values, null, pageNo, pageSize);
    }

    public static List<Object[]> findObjectsByNamedSql(Connection conn, String sSql, Map<String, Object> values, int pageNo, int pageSize) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsBySql(conn, qap.getQuery(), qap.getParams(), pageNo, pageSize);
    }

    public static JSONArray findObjectsByNamedSqlAsJSON(Connection conn, String sSql, Map<String, Object> values, String[] fieldNames, int pageNo, int pageSize) throws SQLException, IOException {
        QueryAndParams qap = QueryAndParams.createFromQueryAndNamedParams(new QueryAndNamedParams(sSql, values));
        return DatabaseAccess.findObjectsAsJSON(conn, qap.getQuery(), qap.getParams(), fieldNames, pageNo, pageSize);
    }
}

