/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.database.metadata;

import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableReference;
import com.centit.support.network.HtmlFormUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface TableInfo {
    public String getTableName();

    public String getTableLabelName();

    public String getTableComment();

    public String getPkName();

    public String getSchema();

    public String getTableType();

    public String getOrderBy();

    public TableField findFieldByName(String var1);

    public TableField findFieldByColumn(String var1);

    public List<? extends TableField> getColumns();

    public List<? extends TableReference> getReferences();

    default public int countPkColumn() {
        int pkColumn = 0;
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isPrimaryKey()) continue;
                ++pkColumn;
            }
        }
        return pkColumn;
    }

    default public boolean hasParmaryKey() {
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isPrimaryKey()) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean isParmaryKey(String colname) {
        TableField field = this.findFieldByColumn(colname);
        return field != null && field.isPrimaryKey();
    }

    @JSONField(serialize=false)
    default public List<String> getAllFieldsName() {
        ArrayList<String> allCols = new ArrayList<String>(4);
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                allCols.add(tableField.getPropertyName());
            }
        }
        return allCols;
    }

    @JSONField(serialize=false)
    default public List<String> getFieldsNameWithoutLazy() {
        ArrayList<String> pkCols = new ArrayList<String>(4);
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (tableField.isLazyFetch()) continue;
                pkCols.add(tableField.getPropertyName());
            }
        }
        return pkCols;
    }

    default public Map<String, Object> fetchObjectPk(Map<String, Object> object) {
        HashMap<String, Object> pk = new HashMap<String, Object>(8);
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isPrimaryKey()) continue;
                Object pkValue = object.get(tableField.getPropertyName());
                if (pkValue == null) {
                    return null;
                }
                pk.put(tableField.getPropertyName(), pkValue);
            }
        }
        return pk;
    }

    default public String fetchObjectPkAsId(Map<String, Object> object) {
        StringBuilder pkId = new StringBuilder();
        int pkNo = 0;
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isPrimaryKey()) continue;
                Object pkValue = object.get(tableField.getPropertyName());
                if (pkNo > 0) {
                    pkId.append(":");
                }
                pkId.append(StringBaseOpt.castObjectToString((Object)pkValue));
                ++pkNo;
            }
        }
        return pkId.toString();
    }

    default public Map<String, Object> parseObjectPkId(String pkId) {
        String[] pkIds = pkId.split(":");
        int len = pkIds.length;
        HashMap<String, Object> pk = new HashMap<String, Object>(8);
        int pkNo = 0;
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isPrimaryKey()) continue;
                if (pkNo >= len) {
                    return null;
                }
                pk.put(tableField.getPropertyName(), pkIds[pkNo]);
                ++pkNo;
            }
        }
        return pk;
    }

    default public String fetchObjectPkAsUrlParams(Map<String, Object> object) {
        StringBuilder pkId = new StringBuilder();
        int pkNo = 0;
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isPrimaryKey()) continue;
                Object pkValue = object.get(tableField.getPropertyName());
                if (pkNo > 0) {
                    pkId.append("&");
                }
                pkId.append(tableField.getPropertyName()).append("=").append(HtmlFormUtils.htmlValue((String)StringBaseOpt.castObjectToString((Object)pkValue)));
                ++pkNo;
            }
        }
        return pkId.toString();
    }

    default public Map<String, Object> parseObjectPkUrlParams(String pkParamString) {
        String[] pkParams = pkParamString.split("&");
        HashMap<String, Object> pk = new HashMap<String, Object>(8);
        for (String param : pkParams) {
            TableField field;
            String[] params = param.split("=");
            if (params.length <= 1 || (field = this.findFieldByName(params[0])) == null) continue;
            pk.put(field.getPropertyName(), HtmlFormUtils.htmlString((String)params[1]));
        }
        return pk;
    }

    @JSONField(serialize=false)
    default public List<? extends TableField> getPkFields() {
        ArrayList<TableField> pkCols = new ArrayList<TableField>(4);
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isPrimaryKey()) continue;
                pkCols.add(tableField);
            }
        }
        return pkCols;
    }

    @JSONField(serialize=false)
    default public List<? extends TableField> getLzayFields() {
        ArrayList<TableField> pkCols = new ArrayList<TableField>(4);
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isLazyFetch()) continue;
                pkCols.add(tableField);
            }
        }
        return pkCols;
    }

    @JSONField(serialize=false)
    default public List<? extends TableField> getMandatoryFields() {
        ArrayList<TableField> pkCols = new ArrayList<TableField>(4);
        List<? extends TableField> columns = this.getColumns();
        if (columns != null) {
            for (TableField tableField : columns) {
                if (!tableField.isMandatory()) continue;
                pkCols.add(tableField);
            }
        }
        return pkCols;
    }
}

