/*
 * Decompiled with CFR 0.152.
 */
package com.centit.search.service;

import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.security.SecurityOptUtils;
import java.util.Arrays;

public class ElasticConfig {
    private String serverHostIp;
    private String serverHostPort;
    private String clusterName;
    private String username;
    private String password;
    private float minScore;
    private String[] serverUrls;

    public void setUsername(String username) {
        this.username = SecurityOptUtils.decodeSecurityString((String)username);
    }

    public void setPassword(String password) {
        this.password = SecurityOptUtils.decodeSecurityString((String)password);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof ElasticConfig)) {
            return false;
        }
        ElasticConfig castOther = (ElasticConfig)other;
        return this.getServerHostIp().equals(castOther.getServerHostIp()) && this.getClusterName().equals(castOther.getClusterName()) && this.getServerHostPort().equals(castOther.getServerHostPort());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getServerHostIp() == null ? 0 : this.getServerHostIp().hashCode());
        result = 37 * result + Integer.valueOf(this.getServerHostPort()).hashCode();
        result = 37 * result + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        return result;
    }

    public String[] getServerUrls() {
        if (this.serverUrls == null || this.serverUrls.length == 0) {
            String[] hosts = this.serverHostIp.split(",");
            String[] ports = this.serverHostPort.split(",");
            if (hosts.length > 0) {
                this.serverUrls = new String[hosts.length];
                for (int i = 0; i < hosts.length; ++i) {
                    int port = 9200;
                    if (ports.length > i) {
                        port = NumberBaseOpt.castObjectToInteger((Object)ports[i], (Integer)port);
                    }
                    this.serverUrls[i] = "http://" + hosts[i] + ":" + port;
                }
            }
        }
        return this.serverUrls;
    }

    public String getServerHostIp() {
        return this.serverHostIp;
    }

    public String getServerHostPort() {
        return this.serverHostPort;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public float getMinScore() {
        return this.minScore;
    }

    public void setServerHostIp(String serverHostIp) {
        this.serverHostIp = serverHostIp;
    }

    public void setServerHostPort(String serverHostPort) {
        this.serverHostPort = serverHostPort;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMinScore(float minScore) {
        this.minScore = minScore;
    }

    public String toString() {
        return "ElasticConfig(serverHostIp=" + this.getServerHostIp() + ", serverHostPort=" + this.getServerHostPort() + ", clusterName=" + this.getClusterName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", minScore=" + this.getMinScore() + ", serverUrls=" + Arrays.deepToString(this.getServerUrls()) + ")";
    }
}

