/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.office;

import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.PdfCanvasProcessor;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import com.itextpdf.kernel.pdf.canvas.parser.listener.LocationTextExtractionStrategy;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocOptUtil {
    private static final Logger logger = LoggerFactory.getLogger(DocOptUtil.class);

    public static void mergePdfFiles(String outputPath, List<String> inputPaths) {
        try (FileOutputStream fos = new FileOutputStream(outputPath);){
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, (OutputStream)fos);
            document.open();
            for (String pdf : inputPaths) {
                com.itextpdf.text.pdf.PdfReader reader = new com.itextpdf.text.pdf.PdfReader(pdf);
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    document.newPage();
                    copy.addPage(copy.getImportedPage(reader, i));
                }
                reader.close();
            }
            document.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void mergePdfFiles(OutputStream fos, List<InputStream> osPdfs) {
        try {
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, fos);
            document.open();
            for (InputStream pdf : osPdfs) {
                com.itextpdf.text.pdf.PdfReader reader = new com.itextpdf.text.pdf.PdfReader(pdf);
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    document.newPage();
                    copy.addPage(copy.getImportedPage(reader, i));
                }
                reader.close();
            }
            document.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean pdfContainsJSAction(String pdfFilePath) {
        try (PDDocument document = Loader.loadPDF((File)new File(pdfFilePath));){
            String cosName = document.getDocument().getTrailer().toString();
            if (!cosName.contains("COSName{JS}")) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public static void pdfHighlightKeywords(InputStream inputPath, OutputStream outputPath, final List<String> keywords, Color color) throws IOException {
        PdfDocument pdfDoc = new PdfDocument(new PdfReader(inputPath), new PdfWriter(outputPath));
        DeviceRgb highlightColor = new DeviceRgb((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        for (int i = 1; i <= pdfDoc.getNumberOfPages(); ++i) {
            PdfPage page = pdfDoc.getPage(i);
            final ArrayList highlightRects = new ArrayList();
            LocationTextExtractionStrategy strategy = new LocationTextExtractionStrategy(){

                public void eventOccurred(IEventData data, EventType type) {
                    if (type == EventType.RENDER_TEXT) {
                        TextRenderInfo renderInfo = (TextRenderInfo)data;
                        String text = renderInfo.getText();
                        for (String keyword : keywords) {
                            if (!text.contains(keyword)) continue;
                            int index = text.indexOf(keyword);
                            while (index >= 0) {
                                try {
                                    List charInfos = renderInfo.getCharacterRenderInfos();
                                    if (index + keyword.length() <= charInfos.size()) {
                                        TextRenderInfo firstChar = (TextRenderInfo)charInfos.get(index);
                                        TextRenderInfo lastChar = (TextRenderInfo)charInfos.get(index + keyword.length() - 1);
                                        Rectangle firstBase = firstChar.getBaseline().getBoundingRectangle();
                                        Rectangle lastBase = lastChar.getBaseline().getBoundingRectangle();
                                        Rectangle firstAscent = firstChar.getAscentLine().getBoundingRectangle();
                                        Rectangle firstDescent = firstChar.getDescentLine().getBoundingRectangle();
                                        Rectangle keywordRect = new Rectangle(firstBase.getLeft(), firstDescent.getBottom(), lastBase.getRight() - firstBase.getLeft(), firstAscent.getTop() - firstDescent.getBottom());
                                        highlightRects.add(keywordRect);
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Error processing keyword highlight: {}", (Object)e.getMessage());
                                }
                                index = text.indexOf(keyword, index + 1);
                            }
                        }
                    }
                    super.eventOccurred(data, type);
                }
            };
            PdfCanvasProcessor parser = new PdfCanvasProcessor((IEventListener)strategy);
            parser.processPageContent(page);
            if (highlightRects.isEmpty()) continue;
            PdfCanvas canvas = new PdfCanvas(page.newContentStreamBefore(), page.getResources(), pdfDoc);
            canvas.saveState();
            canvas.setFillColor((com.itextpdf.kernel.colors.Color)highlightColor);
            for (Rectangle rect : highlightRects) {
                canvas.rectangle((double)rect.getLeft(), (double)rect.getBottom(), (double)rect.getWidth(), (double)rect.getHeight());
                canvas.fill();
            }
            canvas.restoreState();
        }
        pdfDoc.close();
    }

    public static void pdfHighlightKeywords(String inputPath, String outputPath, List<String> keywords, Color color) throws IOException {
        DocOptUtil.pdfHighlightKeywords(Files.newInputStream(Paths.get(inputPath, new String[0]), new OpenOption[0]), Files.newOutputStream(Paths.get(outputPath, new String[0]), new OpenOption[0]), keywords, color);
    }
}

