/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.AbstractCachedObject;
import com.centit.support.common.ObjectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedMap<K, T>
extends AbstractCachedObject<Map<K, T>> {
    protected Logger logger = LoggerFactory.getLogger(CachedMap.class);
    private ConcurrentMap<K, CachedIdentifiedObject> targetMap;
    private long freshPeriod;
    private Function<K, T> refresher;

    public CachedMap(Function<K, T> refresher, long freshPeriod, int initialCapacity) {
        this.targetMap = new ConcurrentHashMap<K, CachedIdentifiedObject>(initialCapacity);
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public CachedMap() {
        this(null, 900L, 16);
    }

    public CachedMap(Function<K, T> refresher, AbstractCachedObject<?> parentCache, int initialCapacity) {
        this(refresher, 900L, initialCapacity);
        parentCache.addDeriveCache(this);
    }

    public CachedMap(Function<K, T> refresher, long freshPeriod) {
        this(refresher, freshPeriod, 16);
    }

    public CachedMap(Function<K, T> refresher, AbstractCachedObject<?> parentCache) {
        this(refresher, parentCache, 16);
    }

    public void setRefresher(Function<K, T> refresher) {
        this.refresher = refresher;
    }

    public void setFreshPeriod(long freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    public void evictIdentifiedCache(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            identifiedObject.evictCache();
        }
    }

    @Override
    public void evictCache() {
        this.targetMap.clear();
        super.evictCache();
    }

    public AbstractCachedObject<T> getCachedObject(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject == null) {
            identifiedObject = new CachedIdentifiedObject(key);
            Object target = identifiedObject.getFreshTarget();
            if (target != null) {
                this.targetMap.put(key, identifiedObject);
            } else {
                identifiedObject = null;
            }
        }
        return identifiedObject;
    }

    public T getCachedValue(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.getCachedTarget();
        }
        identifiedObject = new CachedIdentifiedObject(key);
        Object target = identifiedObject.getFreshTarget();
        if (target != null) {
            this.targetMap.put(key, identifiedObject);
        }
        return target;
    }

    @Override
    public Map<K, T> getCachedTarget() {
        throw new ObjectException("CachedMap \u4e0d\u652f\u6301\u8fd9\u4e2a\u65b9\u6cd5");
    }

    public T getFreshValue(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.getFreshTarget();
        }
        identifiedObject = new CachedIdentifiedObject(key);
        Object target = identifiedObject.getFreshTarget();
        if (target != null) {
            this.targetMap.put(key, identifiedObject);
        }
        return target;
    }

    public boolean isFreshData(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.evicted;
        }
        return false;
    }

    @Override
    public Map<K, T> getRawTarget() {
        if (this.targetMap == null) {
            return null;
        }
        HashMap rawTargetMap = new HashMap(this.targetMap.size() + 1);
        for (Map.Entry ent : this.targetMap.entrySet()) {
            rawTargetMap.put(ent.getKey(), ((CachedIdentifiedObject)ent.getValue()).getRawTarget());
        }
        return rawTargetMap;
    }

    public void setFreshData(K key, T freshData) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            identifiedObject.setFreshData(freshData);
        } else {
            this.targetMap.put(key, new CachedIdentifiedObject(key, freshData));
        }
    }

    class CachedIdentifiedObject
    extends AbstractCachedObject<T> {
        private K key;
        private ReentrantLock freshLock;

        CachedIdentifiedObject(K key, T target) {
            this.key = key;
            this.target = CollectionsOpt.unmodifiableObject(target);
            this.refreshTime = DatetimeOpt.currentUtilDate();
            this.freshLock = new ReentrantLock();
            this.evicted = target == null;
        }

        CachedIdentifiedObject(K key) {
            this(key, null);
        }

        void refreshData() {
            if (this.freshLock.isLocked()) {
                try {
                    while (this.freshLock.isLocked() && this.target == null) {
                        Thread.sleep(15L);
                    }
                }
                catch (InterruptedException e) {
                    CachedMap.this.logger.error(e.getMessage());
                }
                return;
            }
            try {
                this.freshLock.lock();
                this.evictDerivativeCahce();
                Object tempTarget = CachedMap.this.refresher.apply(this.key);
                this.setRefreshDataAndState(tempTarget, CachedMap.this.freshPeriod, true);
            }
            finally {
                this.freshLock.unlock();
            }
        }

        @Override
        public T getCachedTarget() {
            if (this.target == null || this.isTargetOutOfDate(CachedMap.this.freshPeriod)) {
                this.refreshData();
            }
            return this.target;
        }

        T getFreshTarget() {
            this.refreshData();
            return this.target;
        }

        @Override
        public T getRawTarget() {
            return this.target;
        }

        void setFreshData(T freshData) {
            this.target = CollectionsOpt.unmodifiableObject(freshData);
            this.refreshTime = DatetimeOpt.currentUtilDate();
            this.evicted = false;
        }
    }
}

