/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.common.AbstractCachedObject;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedObject<T>
extends AbstractCachedObject<T> {
    protected Logger logger = LoggerFactory.getLogger(CachedObject.class);
    private Supplier<T> refresher;
    protected long freshPeriod;
    private ReentrantLock freshLock;

    public CachedObject(Supplier<T> refresher, long freshPeriod) {
        this.target = null;
        this.evicted = true;
        this.freshLock = new ReentrantLock();
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public CachedObject() {
        this(null, 900L);
    }

    public CachedObject(Supplier<T> refresher) {
        this(refresher, 900L);
    }

    public CachedObject(Supplier<T> refresher, AbstractCachedObject<?> parentCache) {
        this(refresher, 900L);
        parentCache.addDeriveCache(this);
    }

    public CachedObject(Supplier<T> refresher, AbstractCachedObject<?>[] parentCaches) {
        this(refresher, 900L);
        for (AbstractCachedObject<T> abstractCachedObject : parentCaches) {
            abstractCachedObject.addDeriveCache(this);
        }
    }

    public void setFreshPeriod(long freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    public void refreshData() {
        if (this.freshLock.isLocked()) {
            try {
                while (this.freshLock.isLocked() && this.target == null) {
                    Thread.sleep(20L);
                }
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage());
            }
            return;
        }
        try {
            this.freshLock.lock();
            this.evictDerivativeCahce();
            T tempTarget = this.refresher.get();
            this.setRefreshDataAndState(tempTarget, this.freshPeriod, true);
        }
        finally {
            this.freshLock.unlock();
        }
    }

    @Override
    public T getCachedTarget() {
        if (this.target == null || this.isTargetOutOfDate(this.freshPeriod)) {
            this.refreshData();
        }
        return (T)this.target;
    }

    public T getFreshTarget() {
        this.refreshData();
        return (T)this.target;
    }

    @Override
    public T getRawTarget() {
        return (T)this.target;
    }

    public void setRefresher(Supplier<T> refresher) {
        this.refresher = refresher;
    }

    public void setFreshData(T freshData) {
        this.target = CollectionsOpt.unmodifiableObject(freshData);
        this.refreshTime = DatetimeOpt.currentUtilDate();
        this.evicted = false;
    }
}

