/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.json.config;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.centit.support.algorithm.StringBaseOpt;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LobSerializer
implements ObjectWriter<Blob> {
    protected Logger logger = LoggerFactory.getLogger(LobSerializer.class);
    public static final LobSerializer instance = new LobSerializer();

    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (object instanceof Blob) {
            try {
                Blob lobData = (Blob)object;
                InputStream is = lobData.getBinaryStream();
                byte[] readBytes = new byte[is.available()];
                int count = is.read(readBytes);
                if (count > 0) {
                    jsonWriter.writeString(new String(Base64.encodeBase64((byte[])readBytes)));
                }
            }
            catch (IOException | SQLException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            jsonWriter.writeString(StringBaseOpt.objectToString(object));
        }
    }
}

