/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.extend;

import com.centit.support.common.ObjectException;
import com.centit.support.file.FileIOOpt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CallSystemProcess {
    private String pwd = ".";
    private Map<String, InputStream> extendFiles = new HashMap<String, InputStream>();

    public void addExtendFile(String fileName, InputStream inputStream) {
        this.extendFiles.put(fileName, inputStream);
    }

    public void setRunPath(String workingDirectory) {
        this.pwd = workingDirectory.endsWith("/") || workingDirectory.endsWith("\\") ? workingDirectory.substring(0, workingDirectory.length() - 1) : workingDirectory;
    }

    private String mapFilePath(String fileName) {
        if (fileName.startsWith("/") || fileName.indexOf(":") > 0) {
            return fileName;
        }
        return this.pwd + File.separatorChar + fileName;
    }

    public InputStream getExtendFile(String fileName) {
        try {
            return new FileInputStream(this.mapFilePath(fileName));
        }
        catch (FileNotFoundException e) {
            throw new ObjectException(604, "Open file " + fileName + " error: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> runCommand(String ... command) {
        try {
            String line;
            for (Map.Entry<String, InputStream> entry : this.extendFiles.entrySet()) {
                FileIOOpt.writeInputStreamToFile(entry.getValue(), this.mapFilePath(entry.getKey()));
            }
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.directory(new File(this.pwd));
            processBuilder.command(command);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            ArrayList<String> output = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
            process.waitFor();
            return output;
        }
        catch (IOException | InterruptedException e) {
            throw new ObjectException(615, "System call not correct: " + e.getMessage(), (Throwable)e);
        }
    }
}

