/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public abstract class CaptchaImageUtil {
    public static final String SESSIONCHECKCODE = "session_checkcode";
    public static final String REQUESTCHECKCODE = "j_checkcode";
    private static final String range = "0123456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";

    private CaptchaImageUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getRandomString(int len, String codeRepo) {
        Random random = new Random();
        StringBuffer result = new StringBuffer();
        int codeLen = codeRepo.length();
        for (int i = 0; i < len; ++i) {
            result.append(codeRepo.charAt(random.nextInt(codeLen)));
        }
        return result.toString();
    }

    public static String getRandomString(int len) {
        return CaptchaImageUtil.getRandomString(len, range);
    }

    public static String getRandomNumber(int len) {
        return CaptchaImageUtil.getRandomString(len, "0123456789");
    }

    public static String getRandomString() {
        return CaptchaImageUtil.getRandomString(4, range);
    }

    public static boolean checkcodeMatch(String sessionCheckcode, String requestCheckcode) {
        if (requestCheckcode == null || sessionCheckcode == null || "".equals(requestCheckcode) || sessionCheckcode.length() != requestCheckcode.length()) {
            return false;
        }
        for (int i = 0; i < sessionCheckcode.length(); ++i) {
            char r;
            char s = Character.toUpperCase(sessionCheckcode.charAt(i));
            if (s == (r = Character.toUpperCase(requestCheckcode.charAt(i))) || r == 'O' && s == '0' || (r == 'I' || r == 'L') && s == '1') continue;
            return false;
        }
        return true;
    }

    public static BufferedImage generateCaptchaImage(String captchaKey, Font font) {
        int width = 10 + 13 * captchaKey.length();
        int height = 22;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(CaptchaImageUtil.getRandColor(180, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(font);
        g.setColor(new Color(0, 0, 0));
        Random rand = new Random();
        for (int i = 0; i < captchaKey.length(); ++i) {
            ((Graphics)g).drawString(captchaKey.substring(i, i + 1), 13 * i + 6 + rand.nextInt(5), 14 + rand.nextInt(6));
        }
        g.dispose();
        return image;
    }

    public static BufferedImage generateCaptchaImage(String captchaKey, String fontName) {
        return CaptchaImageUtil.generateCaptchaImage(captchaKey, new Font(fontName, 0, 21));
    }

    public static BufferedImage generateCaptchaImage(String captchaKey) {
        return CaptchaImageUtil.generateCaptchaImage(captchaKey, new Font("Times New Roman", 0, 21));
    }

    public static Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

