/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertiesReader {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesReader.class);

    private PropertiesReader() {
        throw new IllegalAccessError("Utility class");
    }

    public static String getClassPathProperty(String fileName, String key) {
        String string;
        block8: {
            InputStream in = PropertiesReader.class.getResourceAsStream(fileName);
            try {
                string = PropertiesReader.getPropertyValue(in, key);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                    return "";
                }
            }
            in.close();
        }
        return string;
    }

    public static String getClassPathProperty(Class<?> clazz, String fileName, String key) {
        String string;
        block8: {
            InputStream in = clazz.getResourceAsStream(fileName);
            try {
                string = PropertiesReader.getPropertyValue(in, key);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                    return "";
                }
            }
            in.close();
        }
        return string;
    }

    public static String getFilePathProperty(String fileName, String key) {
        String string;
        FileInputStream fis = new FileInputStream(new File(fileName));
        try {
            string = PropertiesReader.getPropertyValue(fis, key);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                return "";
            }
        }
        fis.close();
        return string;
    }

    public static Properties getClassPathProperties(String fileName) {
        Properties properties;
        block8: {
            InputStream in = PropertiesReader.class.getResourceAsStream(fileName);
            try {
                properties = PropertiesReader.loadProperties(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                    return null;
                }
            }
            in.close();
        }
        return properties;
    }

    public static Properties getClassPathProperties(Class<?> clazz, String fileName) {
        Properties properties;
        block8: {
            InputStream in = clazz.getResourceAsStream(fileName);
            try {
                properties = PropertiesReader.loadProperties(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                    return null;
                }
            }
            in.close();
        }
        return properties;
    }

    public static Properties getFilePathProperties(String fileName) {
        Properties properties;
        FileInputStream fis = new FileInputStream(new File(fileName));
        try {
            properties = PropertiesReader.loadProperties(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.error("\u8bfb\u53d6\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519", (Throwable)e);
                return null;
            }
        }
        fis.close();
        return properties;
    }

    private static String getPropertyValue(InputStream resource, String key) throws IOException {
        if (resource == null) {
            return null;
        }
        Properties prop = new Properties();
        prop.load(resource);
        return prop.getProperty(key);
    }

    private static Properties loadProperties(InputStream resource) throws IOException {
        Properties prop = new Properties();
        if (resource != null) {
            prop.load(resource);
        }
        return prop;
    }
}

