/*
 * Decompiled with CFR 0.152.
 */
package org.extremecomponents.table.view.html;

import org.apache.commons.lang.StringUtils;
import org.extremecomponents.table.bean.Row;
import org.extremecomponents.table.core.TableModel;
import org.extremecomponents.util.HtmlBuilder;

public class RowBuilder {
    private HtmlBuilder html;
    private TableModel model;
    private Row row;

    public RowBuilder(TableModel model) {
        this(new HtmlBuilder(), model);
    }

    public RowBuilder(HtmlBuilder html, TableModel model) {
        this.html = html;
        this.model = model;
        this.row = model.getRowHandler().getRow();
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.html;
    }

    protected TableModel getTableModel() {
        return this.model;
    }

    protected Row getRow() {
        return this.row;
    }

    public void rowStart() {
        this.html.tr(1);
        this.styleClass();
        this.style();
        this.onclick();
        this.onmouseover();
        this.onmouseout();
        this.html.close();
    }

    public void rowEnd() {
        this.html.trEnd(1);
    }

    public void style() {
        String style = this.row.getStyle();
        this.html.style(style);
    }

    public void styleClass() {
        String styleClass = this.getStyleClass();
        this.html.styleClass(styleClass);
    }

    public void onclick() {
        String onclick = this.row.getOnclick();
        this.html.onclick(onclick);
    }

    public void onmouseover() {
        boolean highlightRow = this.row.isHighlightRow();
        if (highlightRow) {
            String highlightClass = this.row.getHighlightClass();
            if (StringUtils.isNotBlank((String)this.row.getOnmouseover())) {
                this.html.onmouseover("this.className='" + highlightClass + "';" + this.row.getOnmouseover());
            } else {
                this.html.onmouseover("this.className='" + highlightClass + "'");
            }
        } else {
            this.html.onmouseover(this.row.getOnmouseover());
        }
    }

    public void onmouseout() {
        boolean highlightRow = this.row.isHighlightRow();
        if (highlightRow) {
            String styleClass = this.getStyleClass();
            if (StringUtils.isNotBlank((String)this.row.getOnmouseout())) {
                this.html.onmouseout("this.className='" + styleClass + "';" + this.row.getOnmouseout());
            } else {
                this.html.onmouseout("this.className='" + styleClass + "'");
            }
        } else {
            this.html.onmouseout(this.row.getOnmouseout());
        }
    }

    protected String getStyleClass() {
        String styleClass = this.row.getStyleClass();
        if (StringUtils.isNotBlank((String)styleClass)) {
            return styleClass;
        }
        if (this.model.getRowHandler().isRowEven()) {
            return "even";
        }
        return "odd";
    }

    public String toString() {
        return this.html.toString();
    }
}

