/*
 * Decompiled with CFR 0.152.
 */
package org.tio.sitexxx.im.server.utils;

import cn.hutool.core.util.StrUtil;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.sitexxx.im.common.Command;
import org.tio.sitexxx.im.common.ImPacket;
import org.tio.sitexxx.im.common.bs.MsgTipNtf;
import org.tio.sitexxx.im.server.Ims;
import org.tio.sitexxx.service.cache.CacheConfig;
import org.tio.sitexxx.service.cache.Caches;
import org.tio.sitexxx.service.service.conf.ConfService;
import org.tio.sitexxx.service.service.conf.IpWhiteListService;
import org.tio.sitexxx.service.vo.Const;
import org.tio.utils.cache.ICache;

public class ImUtils
extends org.tio.sitexxx.im.common.utils.ImUtils {
    private static Logger log = LoggerFactory.getLogger(ImUtils.class);

    public static boolean isAllowAccessWs(HttpRequest request, HttpResponse httpResponse, ChannelContext channelContext) {
        String token = request.getParam(Const.Http.SESSION_COOKIE_NAME);
        int accessTokenOn = ConfService.getInt((String)"use.access.token.pc", (Integer)2);
        if (accessTokenOn == 1 && !IpWhiteListService.isWhiteIp((String)request.getClientIp())) {
            if (StrUtil.isBlank((CharSequence)token)) {
                return false;
            }
            String accessToken = request.getParam("tio_access_token");
            boolean needNewAccessToken = true;
            if (StrUtil.isNotBlank((CharSequence)accessToken)) {
                ICache cache2 = Caches.getCache((CacheConfig)CacheConfig.TIO_ACCESS_TOKEN);
                String valueInCache = (String)cache2.get(token, String.class);
                if (Objects.equals(accessToken, valueInCache)) {
                    needNewAccessToken = false;
                } else {
                    log.info("access_token\u8fd9\u4e00\u5173\u6ca1\u8fc7");
                }
            }
            if (needNewAccessToken) {
                return false;
            }
        }
        return true;
    }

    public static void sendMsgTip(ChannelContext channelContext, String msg, Short level, Short code) {
        MsgTipNtf msgTipNtf = new MsgTipNtf();
        msgTipNtf.setMsg(msg);
        if (level != null) {
            msgTipNtf.setLevel(level.shortValue());
        }
        msgTipNtf.setCode(code);
        ImPacket imPacket = new ImPacket(Command.MsgTip, (Object)msgTipNtf);
        Ims.send(channelContext, imPacket);
    }

    public static void pleaseLogin(ChannelContext channelContext, String msg) {
        ImUtils.sendMsgTip(channelContext, msg, (short)1, (short)1);
    }

    public static void warn(ChannelContext channelContext, String msg, Short code) {
        ImUtils.sendMsgTip(channelContext, msg, (short)2, code);
    }

    public static void info(ChannelContext channelContext, String msg, Short code) {
        ImUtils.sendMsgTip(channelContext, msg, (short)1, code);
    }
}

