/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.annotation.aspectj;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.alibaba.csp.sentinel.annotation.aspectj.AbstractSentinelAspectSupport;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class SentinelResourceAspect
extends AbstractSentinelAspectSupport {
    @Pointcut(value="@annotation(com.alibaba.csp.sentinel.annotation.SentinelResource)")
    public void sentinelResourceAnnotationPointcut() {
    }

    @Around(value="sentinelResourceAnnotationPointcut()")
    public Object invokeResourceWithSentinel(ProceedingJoinPoint pjp) throws Throwable {
        Method originMethod = this.resolveMethod(pjp);
        SentinelResource annotation = originMethod.getAnnotation(SentinelResource.class);
        if (annotation == null) {
            throw new IllegalStateException("Wrong state for SentinelResource annotation");
        }
        String resourceName = this.getResourceName(annotation.value(), originMethod);
        EntryType entryType = annotation.entryType();
        Entry entry = null;
        try {
            Object result;
            entry = SphU.entry((String)resourceName, (EntryType)entryType, (int)1, (Object[])pjp.getArgs());
            Object object = result = pjp.proceed();
            return object;
        }
        catch (BlockException ex) {
            Object object = this.handleBlockException(pjp, annotation, ex);
            return object;
        }
        catch (Throwable ex) {
            this.traceException(ex, annotation);
            throw ex;
        }
        finally {
            if (entry != null) {
                entry.exit(1, pjp.getArgs());
            }
        }
    }
}

