/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SQLIdentifierExpr
extends SQLExprImpl
implements SQLName {
    protected String name;
    private transient String lowerName;
    private transient Boolean parameter;

    public SQLIdentifierExpr() {
    }

    public SQLIdentifierExpr(String name) {
        this.name = name;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.lowerName = null;
    }

    public String getLowerName() {
        if (this.lowerName == null && this.name != null) {
            this.lowerName = this.name.toLowerCase();
        }
        return this.lowerName;
    }

    public Boolean isParameter() {
        return this.parameter;
    }

    public void setParameter(Boolean parameter) {
        this.parameter = parameter;
    }

    @Override
    public void output(StringBuffer buf) {
        buf.append(this.name);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLIdentifierExpr)) {
            return false;
        }
        SQLIdentifierExpr other = (SQLIdentifierExpr)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean equalsIgnoreCase(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLIdentifierExpr)) {
            return false;
        }
        SQLIdentifierExpr other = (SQLIdentifierExpr)obj;
        return !(this.name == null ? other.name != null : !SQLUtils.normalize(this.name).equalsIgnoreCase(SQLUtils.normalize(other.name)));
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public SQLIdentifierExpr clone() {
        return new SQLIdentifierExpr(this.name);
    }

    public String normalizedName() {
        return SQLUtils.normalize(this.name);
    }
}

