/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client;

import com.alibaba.dts.client.ClientService;
import com.alibaba.dts.client.executor.job.context.ClientContext;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.FailureJobProcessor;
import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.LoggerCleaner;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.GroupIdUtil;
import com.alibaba.dts.common.util.PathUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting.SplitEnvUtil;
import com.alibaba.edas.schedulerx.SchedulerXLogLevel;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

@Deprecated
public class DtsClient
implements ApplicationContextAware,
ApplicationListener,
Constants,
ClientService {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DtsClient.class);
    private final ClientContextImpl clientContext = new ClientContextImpl();
    private static final ConcurrentHashMap<String, Boolean> clientTable = new ConcurrentHashMap();
    private static Object lock = new Object();
    private static SchedulerXLogLevel defaultLogLevel = SchedulerXLogLevel.WARN;
    private static SchedulerXLogLevel executeLogLevel = SchedulerXLogLevel.WARN;
    private LoggerCleaner loggerCleaner = new LoggerCleaner(PathUtil.getLoggerPath());

    public void onApplicationEvent(ApplicationEvent event) {
        if (!(event instanceof ContextRefreshedEvent)) {
            return;
        }
        if (!this.clientContext.getClientConfig().isAutoInit()) {
            logger.warn("[SchedulerXClient]: do not AutoInit, clientConfig:" + this.clientContext.getClientConfig());
            return;
        }
        try {
            this.init();
        }
        catch (Throwable e) {
            String info = "[SchedulerXClient]: init error, clientConfig:" + this.clientContext.getClientConfig();
            logger.error(info, e);
            throw new RuntimeException(info, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws InitException {
        SchedulerXLoggerFactory.initLogByLevel(defaultLogLevel.getInformation(), executeLogLevel.getInformation());
        this.clientContext.getClientConfig().init();
        if (!("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment()) || "PrivateCloud".equals(this.clientContext.getClientConfig().getEnvironment()) || SplitEnvUtil.needStartDtsOnlyByEnv())) {
            logger.error("[SchedulerXClient]: init error, because of isolation environment");
            return;
        }
        if ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment())) {
            if (this.clientContext.getClientConfig().getInnerDebug() == 1) {
                this.clientContext.getHttpService().setUseHttps(false);
            } else {
                this.clientContext.getHttpService().setUseHttps(true);
            }
            if (StringUtil.isEmpty(this.clientContext.getClientConfig().getGroupId())) {
                this.initGroupId(this.clientContext.getClientConfig().getServiceGroup(), this.clientContext.getClientConfig().getRegionName(), this.clientContext.getClientConfig().getServiceGroupId());
            }
        }
        GroupIdUtil.checkGroupId(this.clientContext.getClientConfig().getGroupId());
        Object object = lock;
        synchronized (object) {
            logger.warn("[SchedulerXClient]: tell initialized, thread:" + Thread.currentThread().getName() + ", groupId:" + this.clientContext.getClientConfig().getGroupId());
            Boolean init = clientTable.get(this.clientContext.getClientConfig().getGroupId());
            if (null != init) {
                logger.warn("SchedulerXClient has already initialized, thread:" + Thread.currentThread().getName() + ", groupId:" + this.clientContext.getClientConfig().getGroupId());
                return;
            }
            clientTable.put(this.clientContext.getClientConfig().getGroupId(), new Boolean(true));
        }
        if ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment())) {
            this.clientContext.getSecurityCheck().init();
        }
        this.clientContext.getClientRemoting().init();
        if (!this.clientContext.getClientConfig().isAgent()) {
            this.clientContext.getJobProcessorFactory().init();
        }
        if (this.clientContext.getClientConfig().isAgent()) {
            this.loggerCleaner.init();
        }
        logger.warn("[SchedulerXClient]: init over, clientConfig:" + this.clientContext.getClientConfig().toString());
    }

    @Override
    public void initGroupId(String serviceGroup, String regionName, String serviceGroupId) throws InitException {
        if (StringUtil.isBlank(serviceGroupId)) {
            throw new InitException("[InitGroupId]: serviceGroupId  is null!");
        }
        if (StringUtil.isBlank(serviceGroup) || StringUtil.isBlank(regionName)) {
            throw new InitException("[InitGroupId]: serviceGroup or regionName is null!");
        }
        if (StringUtil.isBlank(serviceGroup) || StringUtil.isBlank(regionName)) {
            throw new InitException("[InitGroupId]: serviceGroup or regionName is null!");
        }
        Result<String> result = this.clientContext.getHttpService().acquireGroupID(this.clientContext.getClientConfig().getDomainName(), serviceGroupId, regionName);
        if (result.getResultCode() == null) {
            throw new InitException("[InitGroupId]: get groupid error, return null!");
        }
        if (result.getResultCode() != ResultCode.SUCCESS) {
            throw new InitException("[InitGroupId]: get groupid error," + result.getResultCode().getInformation());
        }
        if (StringUtil.isEmpty(result.getData())) {
            throw new InitException("[InitGroupId]: get groupid error," + result.getResultCode().getInformation());
        }
        this.clientContext.getClientConfig().setGroupId(result.getData());
    }

    @Override
    public void setRemotingThreads(int remotingThreads) {
        this.clientContext.getClientConfig().setRemotingThreads(remotingThreads);
    }

    @Override
    public void setHeartBeatIntervalTime(long heartBeatIntervalTime) {
        this.clientContext.getClientConfig().setHeartBeatIntervalTime(heartBeatIntervalTime);
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.clientContext.getClientConfig().setConnectionTimeout(connectionTimeout);
    }

    @Override
    public void setGroupId(String groupId) {
        this.clientContext.getClientConfig().setGroupId(groupId);
    }

    @Override
    public void setZkHosts(String zkHosts) {
        this.clientContext.getClientConfig().setZkHosts(zkHosts);
    }

    @Override
    public void setNamespace(String namespace) {
        this.clientContext.getClientConfig().setNamespace(namespace);
    }

    @Override
    public void setZkSessionTimeout(int zkSessionTimeout) {
        this.clientContext.getClientConfig().setZkSessionTimeout(zkSessionTimeout);
    }

    @Override
    public void setZkConnectionTimeout(int zkConnectionTimeout) {
        this.clientContext.getClientConfig().setZkConnectionTimeout(zkConnectionTimeout);
    }

    @Override
    public void setQueueSize(int queueSize) {
        this.clientContext.getClientConfig().setQueueSize(queueSize);
    }

    @Override
    public void setConsumerThreads(int consumerThreads) {
        this.clientContext.getClientConfig().setConsumerThreads(consumerThreads);
    }

    @Override
    public void setConsumerThreadsMap(Map<String, Integer> consumerThreadsMap) {
        this.clientContext.getClientConfig().setConsumerThreadsMap(consumerThreadsMap);
    }

    @Override
    public void setPageSize(int pageSize) {
        this.clientContext.getClientConfig().setPageSize(pageSize);
    }

    @Override
    public void setPageSizeMap(Map<String, Integer> pageSizeMap) {
        this.clientContext.getClientConfig().setPageSizeMap(pageSizeMap);
    }

    @Override
    public void setAccessKey(String accessKey) {
        this.clientContext.getClientConfig().setAccessKey(accessKey);
    }

    @Override
    public void setSecretKey(String secretKey) {
        this.clientContext.getClientConfig().setSecretKey(secretKey);
    }

    @Override
    public void setCrashRetry(boolean crashRetry) {
        this.clientContext.getClientConfig().setCrashRetry(crashRetry);
    }

    @Override
    public void setZkHostsAutoChange(boolean zkHostsAutoChange) {
        this.clientContext.getClientConfig().setZkHostsAutoChange(zkHostsAutoChange);
    }

    @Override
    public void setPullTaskListOverSleepTime(long pullTaskListOverSleepTime) {
        this.clientContext.getClientConfig().setPullTaskListOverSleepTime(pullTaskListOverSleepTime);
    }

    @Override
    public void setFailureJobProcessorMap(Map<String, FailureJobProcessor> failureJobProcessorMap) {
        this.clientContext.getClientConfig().setFailureJobProcessorMap(failureJobProcessorMap);
    }

    @Override
    public void setFinishLog(boolean finishLog) {
        this.clientContext.getClientConfig().setFinishLog(finishLog);
    }

    @Override
    public void setStopJobProcessor(StopJobProcessor stopJobProcessor) {
        this.clientContext.getClientConfig().setStopJobProcessor(stopJobProcessor);
    }

    @Override
    public void setEveryTimeNew(boolean isEveryTimeNew) {
        this.clientContext.getClientConfig().setEveryTimeNew(isEveryTimeNew);
    }

    @Override
    public void setEnvironment(String environment) {
        this.clientContext.getClientConfig().setEnvironment(environment);
    }

    @Override
    public void setServiceGroup(String serviceGroup) {
        this.clientContext.getClientConfig().setServiceGroup(serviceGroup);
    }

    @Override
    public void setServiceGroupId(String serviceGroupId) {
        this.clientContext.getClientConfig().setServiceGroupId(serviceGroupId);
    }

    @Override
    public void setRegionName(String regionName) {
        this.clientContext.getClientConfig().setRegionName(regionName);
    }

    @Override
    public void setInnerDebug(int innerDebug) {
        this.clientContext.getClientConfig().setInnerDebug(innerDebug);
    }

    @Override
    public void setDomainName(String domainName) {
        if (StringUtil.isBlank(domainName) || "default".equals(domainName)) {
            return;
        }
        this.clientContext.getClientConfig().setDomainName(domainName);
    }

    @Override
    public void setAutoInit(boolean autoInit) {
        this.clientContext.getClientConfig().setAutoInit(autoInit);
    }

    @Override
    public ClassLoader getCustomerClassLoader() {
        return this.clientContext.getProxyService().getCustomerClassLoader();
    }

    @Override
    public void setCustomerClassLoader(ClassLoader customerClassLoader) {
        this.clientContext.getProxyService().setCustomerClassLoader(customerClassLoader);
    }

    @Override
    public SchedulerXLogLevel getExecuteLogLevel() {
        return executeLogLevel;
    }

    @Override
    public void setExecuteLogLevel(SchedulerXLogLevel executeLogLevel) {
        DtsClient.executeLogLevel = executeLogLevel;
    }

    @Override
    public SchedulerXLogLevel getDefaultLogLevel() {
        return defaultLogLevel;
    }

    @Override
    public void setDefaultLogLevel(SchedulerXLogLevel defaultLogLevel) {
        DtsClient.defaultLogLevel = defaultLogLevel;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.clientContext.getJobProcessorFactory().setApplicationContext(applicationContext);
        this.clientContext.getClientConfig().setSpring(true);
        logger.warn("[SchedulerXClient]: setApplicationContext over, applicationContext:" + applicationContext);
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public void setNewInstance(boolean newInstance) {
        this.clientContext.getClientConfig().setNewInstance(newInstance);
    }

    public void stopService() {
        try {
            clientTable.remove(this.clientContext.getClientConfig().getGroupId());
            if (this.clientContext.getClientConfig().isAgent()) {
                this.loggerCleaner.stop();
            }
            this.clientContext.getClientConfig().removeDataListener();
            this.clientContext.getClientRemoting().stopService();
            this.clientContext.getExecutor().stopService();
            logger.info("[SchedulerXClient]: stopService success!");
        }
        catch (Exception e) {
            logger.error("[SchedulerXClient]: stopService error.", e);
        }
    }

    public static void main(String[] arguments) {
        DtsClient dtsClient = new DtsClient();
        dtsClient.getClientContext().getClientConfig().setAgent(true);
        dtsClient.getClientContext().getClientConfig().setConfigPath(arguments[0]);
        try {
            dtsClient.init();
        }
        catch (Throwable e) {
            logger.error("[SchedulerX-Agent]: main init error, clientConfig:" + dtsClient.getClientContext().getClientConfig() + ", arguments:" + Arrays.toString(arguments), e);
            System.exit(0);
        }
        logger.warn("[SchedulerX-Agent]: main init over, clientConfig:" + dtsClient.getClientContext().getClientConfig() + ", arguments:" + Arrays.toString(arguments));
    }
}

