/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.queue.send;

import com.alibaba.dts.client.executor.grid.queue.TaskEvent;
import com.alibaba.dts.client.executor.grid.queue.send.SendManager;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.client.route.RouteRule;
import com.alibaba.dts.client.route.impl.RoundRobinRule;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.springframework.util.CollectionUtils;

public class TaskRouter
implements Runnable {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskRouter.class);
    private ClientContextImpl clientContext;
    private SendManager sendManager;
    private Map<String, RouteRule> routeMap;
    private RouteRule routeRule = new RoundRobinRule();

    public TaskRouter(ClientContextImpl clientContext, SendManager sendManager) {
        this.clientContext = clientContext;
        this.sendManager = sendManager;
        this.routeMap = clientContext.getNodeConfig().getRouteMap();
    }

    @Override
    public void run() {
        BlockingQueue<TaskEvent> routeQueue = this.sendManager.getRouteQueue();
        BlockingQueue<TaskEvent> mergeQueue = this.sendManager.getMergeQueue();
        while (true) {
            TaskEvent taskEvent = null;
            try {
                taskEvent = routeQueue.take();
                long jobId = taskEvent.getExecutableTask().getJob().getId();
                long jobInstanceId = taskEvent.getExecutableTask().getJobInstanceSnapshot().getId();
                if (this.clientContext.getGridJobManager().containsInterruptedJobInstance(jobInstanceId)) {
                    logger.debug("job instance interrupted, jobId={}, jobInstanceId={}, taskId={}", jobId, jobInstanceId, taskEvent.getExecutableTask().getTaskSnapshot().getId());
                    continue;
                }
                try {
                    List<RemoteMachine> machines = this.sendManager.getMachinesByJob().get(taskEvent.getExecutableTask().getJob().getId());
                    if (this.routeMap != null && !CollectionUtils.isEmpty(this.routeMap)) {
                        RouteRule tryAcquireRouteRule = this.routeMap.get(taskEvent.getExecutableTask().getJob().getJobProcessor());
                        if (tryAcquireRouteRule != null) {
                            this.routeRule = tryAcquireRouteRule;
                        }
                    } else {
                        logger.debug("[TaskRouter] routeMap is null! jobId={}, jobInstanceId={}", (Object)jobId, (Object)jobInstanceId);
                    }
                    JobContextImpl jobContext = new JobContextImpl();
                    jobContext.setJob(taskEvent.getExecutableTask().getJob());
                    jobContext.setJobInstanceSnapshot(taskEvent.getExecutableTask().getJobInstanceSnapshot());
                    jobContext.setRouteTask(taskEvent.getTask());
                    jobContext.setTaskName(taskEvent.getExecutableTask().getTaskSnapshot().getTaskName());
                    RemoteMachine remoteMachine = this.routeRule.rule(jobContext, machines);
                    if (remoteMachine == null) {
                        logger.error("[TaskRouter] RoutePreProcess error,targetMachine is null! jobId={}, jobInstanceId={}", (Object)jobId, (Object)jobInstanceId);
                    }
                    taskEvent.setTargetMachine(remoteMachine);
                    mergeQueue.put(taskEvent);
                    logger.debug("[TaskRouter] RoutePreProcess,remoteMachine={}, jobId={}, jobInstanceId={}", remoteMachine, jobId, jobInstanceId);
                }
                catch (Throwable e) {
                    logger.error("[TaskRouter] RoutePreProcess error, jobId={}, jobInstanceId={}", jobId, jobInstanceId, e);
                }
                continue;
            }
            catch (Throwable e) {
                logger.error("failed to route task, task={}", (Object)taskEvent, (Object)e);
                continue;
            }
            break;
        }
    }
}

